<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Sql\Close;
use OpenSearch\Endpoints\Sql\Explain;
use OpenSearch\Endpoints\Sql\GetStats;
use OpenSearch\Endpoints\Sql\PostStats;
use OpenSearch\Endpoints\Sql\Query;
use OpenSearch\Endpoints\Sql\Settings;

/**
 * Class SqlNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SqlNamespace extends AbstractNamespace
{
    /**
     * Closes an open cursor to free server-side resources.
     *
     * $params['format']      = (string) Specifies the response format (JSON or YAML).
     * $params['sanitize']    = (boolean) Whether to escape special characters in the results. (Default = true)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function close(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(Close::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves performance metrics for the SQL plugin.
     *
     * $params['format']      = (string) Specifies the response format (JSON or YAML).
     * $params['sanitize']    = (boolean) Whether to escape special characters in the results. (Default = true)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getStats(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetStats::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves filtered performance metrics for the SQL plugin.
     *
     * $params['format']      = (string) Specifies the response format (JSON or YAML).
     * $params['sanitize']    = (boolean) Whether to escape special characters in the results. (Default = true)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function postStats(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PostStats::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates SQL plugin settings in the OpenSearch cluster configuration.
     *
     * $params['format']      = (string) Specifies the response format (JSON or YAML).
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function settings(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(Settings::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * This API will be removed in a future version. Use 'close' API instead.
     *
     * $params['cursor'] = (string) The cursor given by the server
     *
     * @param array{'cursor': string} $params Associative array of parameters
     * @return array
     */
    public function closeCursor(array $params): array
    {
        $endpoint = $this->endpointFactory->getEndpoint(Close::class);
        $endpoint->setBody(array_filter([
            'cursor' => $this->extractArgument($params, 'cursor'),
        ]));
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }    /**
     * $params['query'] = (string) The SQL Query
     *
     * @param array{'query': string} $params Associative array of parameters
     * @return array
     *
     * Note: Use of query parameter is deprecated. Pass it in `body` instead.
     */
    public function explain(array $params): array
    {
        $body = $this->extractArgument($params, 'body') ?? [];
        $query = $this->extractArgument($params, 'query');

        $endpoint = $this->endpointFactory->getEndpoint(Explain::class);
        $endpoint->setBody(array_merge($body, [
            'query' => $query,
        ]));
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }    /**
     * $params['query'] = (string) The SQL Query
     * $params['format'] = (string) The response format
     * $params['cursor'] = (string) The cursor given by the server
     * $params['fetch_size'] = (int) The fetch size
     *
     * @param array{'query'?: string, 'cursor'?: string, 'fetch_size'?: int} $params Associative array of parameters
     * @return array
     *
     * Note: Use of `query`, `cursor` and `fetch_size` parameters is deprecated. Pass them in `body` instead.
     *
     */
    public function query(array $params): array
    {
        $endpoint = $this->endpointFactory->getEndpoint(Query::class);
        $body = $this->extractArgument($params, 'body') ?? [];
        $endpoint->setBody(array_merge($body, array_filter([
            'query' => $this->extractArgument($params, 'query'),
            'cursor' => $this->extractArgument($params, 'cursor'),
            'fetch_size' => $this->extractArgument($params, 'fetch_size'),
        ])));
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
}
