<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Neural\Stats;

/**
 * Class NeuralNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class NeuralNamespace extends AbstractNamespace
{
    /**
     * Provides information about the current status of the neural-search plugin.
     *
     * $params['node_id']                  = (string) A comma-separated list of node IDs or names to limit the returned information; leave empty to get information from all nodes.
     * $params['stat']                     = (array) A comma-separated list of stats to retrieve; use empty string to retrieve all stats.
     * $params['flat_stat_paths']          = (boolean) Whether to return stats in the flat form, which can improve readability, especially for heavily nested stats. For example, the flat form of `"processors": { "ingest": { "text_embedding_executions": 20181212 } }` is `"processors.ingest.text_embedding_executions": "20181212"`. (Default = false)
     * $params['include_all_nodes']        = (boolean) When `true` includes aggregated statistics across all nodes in the `all_nodes` category. When `false`, excludes the `all_nodes` category from the response. (Default = true)
     * $params['include_individual_nodes'] = (boolean) When `true` includes statistics for individual nodes in the `nodes` category. When `false`, excludes the `nodes` category from the response. (Default = true)
     * $params['include_info']             = (boolean) When `true` includes cluster-wide information in the `info` category. When `false`, excludes the `info` category from the response. (Default = true)
     * $params['include_metadata']         = (boolean) Whether to return stat metadata instead of the raw stat value, includes additional information about the stat. These can include things like type hints, time since last stats being recorded, or recent rolling interval values (Default = false)
     * $params['pretty']                   = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                    = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']              = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                   = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']              = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function stats(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');
        $stat = $this->extractArgument($params, 'stat');

        $endpoint = $this->endpointFactory->getEndpoint(Stats::class);
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);
        $endpoint->setStat($stat);

        return $this->performRequest($endpoint);
    }

}
