<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SecurityAnalytics;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SearchFindingCorrelations extends AbstractEndpoint
{
    public function getURI(): string
    {
        return "/_plugins/_security_analytics/findings/correlate";
    }

    public function getParamWhitelist(): array
    {
        return [
            'detector_type',
            'finding',
            'nearby_findings',
            'time_window',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }
}
