<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetStats extends AbstractEndpoint
{
    protected $stat;

    public function getURI(): string
    {
        $stat = $this->stat ? rawurlencode($this->stat) : null;
        if (isset($stat)) {
            return "/_plugins/_search_relevance/stats/$stat";
        }
        return "/_plugins/_search_relevance/stats";
    }

    public function getParamWhitelist(): array
    {
        return [
            'flat_stat_paths',
            'include_all_nodes',
            'include_individual_nodes',
            'include_info',
            'include_metadata',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setStat($stat): static
    {
        if (is_null($stat)) {
            return $this;
        }
        $this->stat = $stat;

        return $this;
    }
}
