<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetSearchConfigurations extends AbstractEndpoint
{
    protected $search_configuration_id;

    public function getURI(): string
    {
        $search_configuration_id = $this->search_configuration_id ? rawurlencode($this->search_configuration_id) : null;
        if (isset($search_configuration_id)) {
            return "/_plugins/_search_relevance/search_configurations/$search_configuration_id";
        }
        return "/_plugins/_search_relevance/search_configurations";
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setSearchConfigurationId($search_configuration_id): static
    {
        if (is_null($search_configuration_id)) {
            return $this;
        }
        $this->search_configuration_id = $search_configuration_id;

        return $this;
    }
}
