<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetNodeStats extends AbstractEndpoint
{
    protected $node_id;
    protected $stat;

    public function getURI(): string
    {
        if (!isset($this->node_id) || $this->node_id === '') {
            throw new RuntimeException('node_id is required for get_node_stats');
        }
        $node_id = rawurlencode($this->node_id);
        $stat = $this->stat ? rawurlencode($this->stat) : null;
        if (isset($stat)) {
            return "/_plugins/_search_relevance/$node_id/stats/$stat";
        }
        return "/_plugins/_search_relevance/$node_id/stats";
    }

    public function getParamWhitelist(): array
    {
        return [
            'flat_stat_paths',
            'include_all_nodes',
            'include_individual_nodes',
            'include_info',
            'include_metadata',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setNodeId($node_id): static
    {
        if (is_null($node_id)) {
            return $this;
        }
        $this->node_id = $node_id;

        return $this;
    }

    public function setStat($stat): static
    {
        if (is_null($stat)) {
            return $this;
        }
        $this->stat = $stat;

        return $this;
    }
}
