<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetExperiments extends AbstractEndpoint
{
    protected $experiment_id;

    public function getURI(): string
    {
        $experiment_id = $this->experiment_id ? rawurlencode($this->experiment_id) : null;
        if (isset($experiment_id)) {
            return "/_plugins/_search_relevance/experiments/$experiment_id";
        }
        return "/_plugins/_search_relevance/experiments";
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setExperimentId($experiment_id): static
    {
        if (is_null($experiment_id)) {
            return $this;
        }
        $this->experiment_id = $experiment_id;

        return $this;
    }
}
