<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class DeleteQuerySets extends AbstractEndpoint
{
    protected $query_set_id;

    public function getURI(): string
    {
        $query_set_id = $this->query_set_id ? rawurlencode($this->query_set_id) : null;
        if (isset($query_set_id)) {
            return "/_plugins/_search_relevance/query_sets/$query_set_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint search_relevance.delete_query_sets');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'DELETE';
    }

    public function setQuerySetId($query_set_id): static
    {
        if (is_null($query_set_id)) {
            return $this;
        }
        $this->query_set_id = $query_set_id;

        return $this;
    }
}
