<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\SearchRelevance;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class DeleteJudgments extends AbstractEndpoint
{
    protected $judgment_id;

    public function getURI(): string
    {
        $judgment_id = $this->judgment_id ? rawurlencode($this->judgment_id) : null;
        if (isset($judgment_id)) {
            return "/_plugins/_search_relevance/judgments/$judgment_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint search_relevance.delete_judgments');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'DELETE';
    }

    public function setJudgmentId($judgment_id): static
    {
        if (is_null($judgment_id)) {
            return $this;
        }
        $this->judgment_id = $judgment_id;

        return $this;
    }
}
