<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Notifications;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class UpdateConfig extends AbstractEndpoint
{
    protected $config_id;

    public function getURI(): string
    {
        $config_id = $this->config_id ? rawurlencode($this->config_id) : null;
        if (isset($config_id)) {
            return "/_plugins/_notifications/configs/$config_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint notifications.update_config');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setConfigId($config_id): static
    {
        if (is_null($config_id)) {
            return $this;
        }
        $this->config_id = $config_id;

        return $this;
    }
}
