<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class UpdateAgenticMemory extends AbstractEndpoint
{
    protected $memory_container_id;
    protected $type;

    public function getURI(): string
    {
        $id = $this->id ? rawurlencode($this->id) : null;
        $memory_container_id = $this->memory_container_id ? rawurlencode($this->memory_container_id) : null;
        $type = $this->type ? rawurlencode($this->type) : null;
        if (isset($memory_container_id) && isset($type) && isset($id)) {
            return "/_plugins/_ml/memory_containers/$memory_container_id/memories/$type/$id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.update_agentic_memory');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setMemoryContainerId($memory_container_id): static
    {
        if (is_null($memory_container_id)) {
            return $this;
        }
        $this->memory_container_id = $memory_container_id;

        return $this;
    }

    public function setType($type): static
    {
        if (is_null($type)) {
            return $this;
        }
        $this->type = $type;

        return $this;
    }
}
