<?php

declare(strict_types=1);

/**
 *  Copyright OpenSearch Contributors
 *   SPDX-License-Identifier: Apache-2.0
 *
 *   The OpenSearch Contributors require contributions made to
 *   this file be licensed under the Apache-2.0 license or a
 *   compatible open source license.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class Predict extends AbstractEndpoint
{
    protected $algorithm_name;
    protected $model_id;

    public function getURI(): string
    {
        $algorithm_name = $this->algorithm_name ? rawurlencode($this->algorithm_name) : null;
        $model_id = $this->model_id ? rawurlencode($this->model_id) : null;
        if (isset($algorithm_name) && isset($model_id)) {
            return "/_plugins/_ml/_predict/$algorithm_name/$model_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.predict');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setAlgorithmName($algorithm_name): static
    {
        if (is_null($algorithm_name)) {
            return $this;
        }
        $this->algorithm_name = $algorithm_name;

        return $this;
    }

    public function setModelId($model_id): static
    {
        if (is_null($model_id)) {
            return $this;
        }
        $this->model_id = $model_id;

        return $this;
    }
}
