<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetMessage extends AbstractEndpoint
{
    protected $message_id;

    public function getURI(): string
    {
        $message_id = $this->message_id ? rawurlencode($this->message_id) : null;
        if (isset($message_id)) {
            return "/_plugins/_ml/memory/message/$message_id";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.get_message');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setMessageId($message_id): static
    {
        if (is_null($message_id)) {
            return $this;
        }
        $this->message_id = $message_id;

        return $this;
    }
}
