<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class CreateMemoryContainerSession extends AbstractEndpoint
{
    protected $memory_container_id;

    public function getURI(): string
    {
        $memory_container_id = $this->memory_container_id ? rawurlencode($this->memory_container_id) : null;
        if (isset($memory_container_id)) {
            return "/_plugins/_ml/memory_containers/$memory_container_id/memories/sessions";
        }
        throw new RuntimeException('Missing parameter for the endpoint ml.create_memory_container_session');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setMemoryContainerId($memory_container_id): static
    {
        if (is_null($memory_container_id)) {
            return $this;
        }
        $this->memory_container_id = $memory_container_id;

        return $this;
    }
}
