<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ltr;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class ClearCache extends AbstractEndpoint
{
    protected $store;

    public function getURI(): string
    {
        $store = $this->store ? rawurlencode($this->store) : null;
        if (isset($store)) {
            return "/_ltr/$store/_clearcache";
        }
        return "/_ltr/_clearcache";
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setStore($store): static
    {
        if (is_null($store)) {
            return $this;
        }
        $this->store = $store;

        return $this;
    }
}
