<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ltr;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class AddFeaturesToSetByQuery extends AbstractEndpoint
{
    protected $name;
    protected $query;
    protected $store;

    public function getURI(): string
    {
        if (!isset($this->name) || $this->name === '') {
            throw new RuntimeException('name is required for add_features_to_set_by_query');
        }
        $name = rawurlencode($this->name);
        if (!isset($this->query) || $this->query === '') {
            throw new RuntimeException('query is required for add_features_to_set_by_query');
        }
        $query = rawurlencode($this->query);
        $store = $this->store ? rawurlencode($this->store) : null;
        if (isset($store)) {
            return "/_ltr/$store/_featureset/$name/_addfeatures/$query";
        }
        return "/_ltr/_featureset/$name/_addfeatures/$query";
    }

    public function getParamWhitelist(): array
    {
        return [
            'merge',
            'routing',
            'version',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setName($name): static
    {
        if (is_null($name)) {
            return $this;
        }
        $this->name = $name;

        return $this;
    }

    public function setQuery($query): static
    {
        if (is_null($query)) {
            return $this;
        }
        $this->query = $query;

        return $this;
    }

    public function setStore($store): static
    {
        if (is_null($store)) {
            return $this;
        }
        $this->store = $store;

        return $this;
    }
}
