<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\List;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class Indices extends AbstractEndpoint
{
    public function getURI(): string
    {
        $index = $this->index ? rawurlencode($this->index) : null;
        if (isset($index)) {
            return "/_list/indices/$index";
        }
        return "/_list/indices";
    }

    public function getParamWhitelist(): array
    {
        return [
            'bytes',
            'cluster_manager_timeout',
            'expand_wildcards',
            'format',
            'h',
            'health',
            'help',
            'include_unloaded_segments',
            'local',
            'master_timeout',
            'next_token',
            'pri',
            's',
            'size',
            'sort',
            'time',
            'v',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    protected function getParamDeprecation(): array
    {
        return ['master_timeout' => 'cluster_manager_timeout'];
    }
}
