<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Cat;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SegmentReplication extends AbstractEndpoint
{
    public function getURI(): string
    {
        $index = $this->index ? rawurlencode($this->index) : null;
        if (isset($index)) {
            return "/_cat/segment_replication/$index";
        }
        return "/_cat/segment_replication";
    }

    public function getParamWhitelist(): array
    {
        return [
            'active_only',
            'allow_no_indices',
            'bytes',
            'completed_only',
            'detailed',
            'expand_wildcards',
            'format',
            'h',
            'help',
            'ignore_throttled',
            'ignore_unavailable',
            'index',
            's',
            'shards',
            'time',
            'timeout',
            'v',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }
}
