<?php

/**
 * TransformerPropertyTypeSettings.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * TransformerPropertyTypeSettings Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class TransformerPropertyTypeSettings implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'TransformerPropertyTypeSettings';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'customIdPrefix' => 'string',
        'propertyTypeNameTargetCase' => 'NamingConventionCase',
        'unwrapSingleObjectProperties' => 'bool',
        'unwrapSingleArrayProperties' => 'bool',
        'removePropertyTypes' => 'string[]',
        'preferSpecificLinkTypes' => 'bool',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'customIdPrefix' => null,
        'propertyTypeNameTargetCase' => null,
        'unwrapSingleObjectProperties' => null,
        'unwrapSingleArrayProperties' => null,
        'removePropertyTypes' => null,
        'preferSpecificLinkTypes' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'customIdPrefix' => true,
        'propertyTypeNameTargetCase' => true,
        'unwrapSingleObjectProperties' => true,
        'unwrapSingleArrayProperties' => true,
        'removePropertyTypes' => true,
        'preferSpecificLinkTypes' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customIdPrefix' => 'customIdPrefix',
        'propertyTypeNameTargetCase' => 'propertyTypeNameTargetCase',
        'unwrapSingleObjectProperties' => 'unwrapSingleObjectProperties',
        'unwrapSingleArrayProperties' => 'unwrapSingleArrayProperties',
        'removePropertyTypes' => 'removePropertyTypes',
        'preferSpecificLinkTypes' => 'preferSpecificLinkTypes',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'customIdPrefix' => 'setCustomIdPrefix',
        'propertyTypeNameTargetCase' => 'setPropertyTypeNameTargetCase',
        'unwrapSingleObjectProperties' => 'setUnwrapSingleObjectProperties',
        'unwrapSingleArrayProperties' => 'setUnwrapSingleArrayProperties',
        'removePropertyTypes' => 'setRemovePropertyTypes',
        'preferSpecificLinkTypes' => 'setPreferSpecificLinkTypes',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'customIdPrefix' => 'getCustomIdPrefix',
        'propertyTypeNameTargetCase' => 'getPropertyTypeNameTargetCase',
        'unwrapSingleObjectProperties' => 'getUnwrapSingleObjectProperties',
        'unwrapSingleArrayProperties' => 'getUnwrapSingleArrayProperties',
        'removePropertyTypes' => 'getRemovePropertyTypes',
        'preferSpecificLinkTypes' => 'getPreferSpecificLinkTypes',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customIdPrefix', $data ?? [], null);
        $this->setIfExists('propertyTypeNameTargetCase', $data ?? [], null);
        $this->setIfExists('unwrapSingleObjectProperties', $data ?? [], null);
        $this->setIfExists('unwrapSingleArrayProperties', $data ?? [], null);
        $this->setIfExists('removePropertyTypes', $data ?? [], null);
        $this->setIfExists('preferSpecificLinkTypes', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets customIdPrefix.
     *
     * @return null|string
     */
    public function getCustomIdPrefix()
    {
        return $this->container['customIdPrefix'];
    }

    /**
     * Sets customIdPrefix.
     *
     * @param null|string $customIdPrefix customIdPrefix
     *
     * @return self
     */
    public function setCustomIdPrefix($customIdPrefix)
    {
        if (is_null($customIdPrefix)) {
            array_push($this->openAPINullablesSetToNull, 'customIdPrefix');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customIdPrefix', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customIdPrefix'] = $customIdPrefix;

        return $this;
    }

    /**
     * Gets propertyTypeNameTargetCase.
     *
     * @return null|NamingConventionCase
     */
    public function getPropertyTypeNameTargetCase()
    {
        return $this->container['propertyTypeNameTargetCase'];
    }

    /**
     * Sets propertyTypeNameTargetCase.
     *
     * @param null|NamingConventionCase $propertyTypeNameTargetCase propertyTypeNameTargetCase
     *
     * @return self
     */
    public function setPropertyTypeNameTargetCase($propertyTypeNameTargetCase)
    {
        if (is_null($propertyTypeNameTargetCase)) {
            array_push($this->openAPINullablesSetToNull, 'propertyTypeNameTargetCase');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('propertyTypeNameTargetCase', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['propertyTypeNameTargetCase'] = $propertyTypeNameTargetCase;

        return $this;
    }

    /**
     * Gets unwrapSingleObjectProperties.
     *
     * @return null|bool
     */
    public function getUnwrapSingleObjectProperties()
    {
        return $this->container['unwrapSingleObjectProperties'];
    }

    /**
     * Sets unwrapSingleObjectProperties.
     *
     * @param null|bool $unwrapSingleObjectProperties unwrapSingleObjectProperties
     *
     * @return self
     */
    public function setUnwrapSingleObjectProperties($unwrapSingleObjectProperties)
    {
        if (is_null($unwrapSingleObjectProperties)) {
            array_push($this->openAPINullablesSetToNull, 'unwrapSingleObjectProperties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('unwrapSingleObjectProperties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['unwrapSingleObjectProperties'] = $unwrapSingleObjectProperties;

        return $this;
    }

    /**
     * Gets unwrapSingleArrayProperties.
     *
     * @return null|bool
     */
    public function getUnwrapSingleArrayProperties()
    {
        return $this->container['unwrapSingleArrayProperties'];
    }

    /**
     * Sets unwrapSingleArrayProperties.
     *
     * @param null|bool $unwrapSingleArrayProperties unwrapSingleArrayProperties
     *
     * @return self
     */
    public function setUnwrapSingleArrayProperties($unwrapSingleArrayProperties)
    {
        if (is_null($unwrapSingleArrayProperties)) {
            array_push($this->openAPINullablesSetToNull, 'unwrapSingleArrayProperties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('unwrapSingleArrayProperties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['unwrapSingleArrayProperties'] = $unwrapSingleArrayProperties;

        return $this;
    }

    /**
     * Gets removePropertyTypes.
     *
     * @return null|string[]
     */
    public function getRemovePropertyTypes()
    {
        return $this->container['removePropertyTypes'];
    }

    /**
     * Sets removePropertyTypes.
     *
     * @param null|string[] $removePropertyTypes removePropertyTypes
     *
     * @return self
     */
    public function setRemovePropertyTypes($removePropertyTypes)
    {
        if (is_null($removePropertyTypes)) {
            array_push($this->openAPINullablesSetToNull, 'removePropertyTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('removePropertyTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['removePropertyTypes'] = $removePropertyTypes;

        return $this;
    }

    /**
     * Gets preferSpecificLinkTypes.
     *
     * @return null|bool
     */
    public function getPreferSpecificLinkTypes()
    {
        return $this->container['preferSpecificLinkTypes'];
    }

    /**
     * Sets preferSpecificLinkTypes.
     *
     * @param null|bool $preferSpecificLinkTypes preferSpecificLinkTypes
     *
     * @return self
     */
    public function setPreferSpecificLinkTypes($preferSpecificLinkTypes)
    {
        if (is_null($preferSpecificLinkTypes)) {
            array_push($this->openAPINullablesSetToNull, 'preferSpecificLinkTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('preferSpecificLinkTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['preferSpecificLinkTypes'] = $preferSpecificLinkTypes;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
