<?php

/**
 * TransformerPropertySettings.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * TransformerPropertySettings Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class TransformerPropertySettings implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'TransformerPropertySettings';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'customIdPrefix' => 'string',
        'propertyNameTargetCase' => 'NamingConventionCase',
        'removePropertyFieldPrefix' => 'bool',
        'makeAllPropertiesOptional' => 'bool',
        'renameProperties' => 'mixed',
        'removeProperties' => 'mixed',
        'unwrapArrayProperties' => 'mixed',
        'defaultTextPropertySearchFormat' => 'ContentCloudSearchFormat',
        'propertySearchFormat' => 'mixed',
        'millisecondTimestamps' => 'bool',
        'assignTypes' => 'mixed',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'customIdPrefix' => null,
        'propertyNameTargetCase' => null,
        'removePropertyFieldPrefix' => null,
        'makeAllPropertiesOptional' => null,
        'renameProperties' => null,
        'removeProperties' => null,
        'unwrapArrayProperties' => null,
        'defaultTextPropertySearchFormat' => null,
        'propertySearchFormat' => null,
        'millisecondTimestamps' => null,
        'assignTypes' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'customIdPrefix' => true,
        'propertyNameTargetCase' => true,
        'removePropertyFieldPrefix' => true,
        'makeAllPropertiesOptional' => true,
        'renameProperties' => true,
        'removeProperties' => true,
        'unwrapArrayProperties' => true,
        'defaultTextPropertySearchFormat' => true,
        'propertySearchFormat' => true,
        'millisecondTimestamps' => true,
        'assignTypes' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customIdPrefix' => 'customIdPrefix',
        'propertyNameTargetCase' => 'propertyNameTargetCase',
        'removePropertyFieldPrefix' => 'removePropertyFieldPrefix',
        'makeAllPropertiesOptional' => 'makeAllPropertiesOptional',
        'renameProperties' => 'renameProperties',
        'removeProperties' => 'removeProperties',
        'unwrapArrayProperties' => 'unwrapArrayProperties',
        'defaultTextPropertySearchFormat' => 'defaultTextPropertySearchFormat',
        'propertySearchFormat' => 'propertySearchFormat',
        'millisecondTimestamps' => 'millisecondTimestamps',
        'assignTypes' => 'assignTypes',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'customIdPrefix' => 'setCustomIdPrefix',
        'propertyNameTargetCase' => 'setPropertyNameTargetCase',
        'removePropertyFieldPrefix' => 'setRemovePropertyFieldPrefix',
        'makeAllPropertiesOptional' => 'setMakeAllPropertiesOptional',
        'renameProperties' => 'setRenameProperties',
        'removeProperties' => 'setRemoveProperties',
        'unwrapArrayProperties' => 'setUnwrapArrayProperties',
        'defaultTextPropertySearchFormat' => 'setDefaultTextPropertySearchFormat',
        'propertySearchFormat' => 'setPropertySearchFormat',
        'millisecondTimestamps' => 'setMillisecondTimestamps',
        'assignTypes' => 'setAssignTypes',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'customIdPrefix' => 'getCustomIdPrefix',
        'propertyNameTargetCase' => 'getPropertyNameTargetCase',
        'removePropertyFieldPrefix' => 'getRemovePropertyFieldPrefix',
        'makeAllPropertiesOptional' => 'getMakeAllPropertiesOptional',
        'renameProperties' => 'getRenameProperties',
        'removeProperties' => 'getRemoveProperties',
        'unwrapArrayProperties' => 'getUnwrapArrayProperties',
        'defaultTextPropertySearchFormat' => 'getDefaultTextPropertySearchFormat',
        'propertySearchFormat' => 'getPropertySearchFormat',
        'millisecondTimestamps' => 'getMillisecondTimestamps',
        'assignTypes' => 'getAssignTypes',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customIdPrefix', $data ?? [], null);
        $this->setIfExists('propertyNameTargetCase', $data ?? [], null);
        $this->setIfExists('removePropertyFieldPrefix', $data ?? [], null);
        $this->setIfExists('makeAllPropertiesOptional', $data ?? [], null);
        $this->setIfExists('renameProperties', $data ?? [], null);
        $this->setIfExists('removeProperties', $data ?? [], null);
        $this->setIfExists('unwrapArrayProperties', $data ?? [], null);
        $this->setIfExists('defaultTextPropertySearchFormat', $data ?? [], null);
        $this->setIfExists('propertySearchFormat', $data ?? [], null);
        $this->setIfExists('millisecondTimestamps', $data ?? [], null);
        $this->setIfExists('assignTypes', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets customIdPrefix.
     *
     * @return null|string
     */
    public function getCustomIdPrefix()
    {
        return $this->container['customIdPrefix'];
    }

    /**
     * Sets customIdPrefix.
     *
     * @param null|string $customIdPrefix customIdPrefix
     *
     * @return self
     */
    public function setCustomIdPrefix($customIdPrefix)
    {
        if (is_null($customIdPrefix)) {
            array_push($this->openAPINullablesSetToNull, 'customIdPrefix');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customIdPrefix', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customIdPrefix'] = $customIdPrefix;

        return $this;
    }

    /**
     * Gets propertyNameTargetCase.
     *
     * @return null|NamingConventionCase
     */
    public function getPropertyNameTargetCase()
    {
        return $this->container['propertyNameTargetCase'];
    }

    /**
     * Sets propertyNameTargetCase.
     *
     * @param null|NamingConventionCase $propertyNameTargetCase propertyNameTargetCase
     *
     * @return self
     */
    public function setPropertyNameTargetCase($propertyNameTargetCase)
    {
        if (is_null($propertyNameTargetCase)) {
            array_push($this->openAPINullablesSetToNull, 'propertyNameTargetCase');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('propertyNameTargetCase', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['propertyNameTargetCase'] = $propertyNameTargetCase;

        return $this;
    }

    /**
     * Gets removePropertyFieldPrefix.
     *
     * @return null|bool
     */
    public function getRemovePropertyFieldPrefix()
    {
        return $this->container['removePropertyFieldPrefix'];
    }

    /**
     * Sets removePropertyFieldPrefix.
     *
     * @param null|bool $removePropertyFieldPrefix removePropertyFieldPrefix
     *
     * @return self
     */
    public function setRemovePropertyFieldPrefix($removePropertyFieldPrefix)
    {
        if (is_null($removePropertyFieldPrefix)) {
            array_push($this->openAPINullablesSetToNull, 'removePropertyFieldPrefix');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('removePropertyFieldPrefix', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['removePropertyFieldPrefix'] = $removePropertyFieldPrefix;

        return $this;
    }

    /**
     * Gets makeAllPropertiesOptional.
     *
     * @return null|bool
     */
    public function getMakeAllPropertiesOptional()
    {
        return $this->container['makeAllPropertiesOptional'];
    }

    /**
     * Sets makeAllPropertiesOptional.
     *
     * @param null|bool $makeAllPropertiesOptional makeAllPropertiesOptional
     *
     * @return self
     */
    public function setMakeAllPropertiesOptional($makeAllPropertiesOptional)
    {
        if (is_null($makeAllPropertiesOptional)) {
            array_push($this->openAPINullablesSetToNull, 'makeAllPropertiesOptional');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('makeAllPropertiesOptional', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['makeAllPropertiesOptional'] = $makeAllPropertiesOptional;

        return $this;
    }

    /**
     * Gets renameProperties.
     *
     * @return null|mixed
     */
    public function getRenameProperties()
    {
        return $this->container['renameProperties'];
    }

    /**
     * Sets renameProperties.
     *
     * @param null|mixed $renameProperties renameProperties
     *
     * @return self
     */
    public function setRenameProperties($renameProperties)
    {
        if (is_null($renameProperties)) {
            array_push($this->openAPINullablesSetToNull, 'renameProperties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('renameProperties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['renameProperties'] = $renameProperties;

        return $this;
    }

    /**
     * Gets removeProperties.
     *
     * @return null|mixed
     */
    public function getRemoveProperties()
    {
        return $this->container['removeProperties'];
    }

    /**
     * Sets removeProperties.
     *
     * @param null|mixed $removeProperties removeProperties
     *
     * @return self
     */
    public function setRemoveProperties($removeProperties)
    {
        if (is_null($removeProperties)) {
            array_push($this->openAPINullablesSetToNull, 'removeProperties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('removeProperties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['removeProperties'] = $removeProperties;

        return $this;
    }

    /**
     * Gets unwrapArrayProperties.
     *
     * @return null|mixed
     */
    public function getUnwrapArrayProperties()
    {
        return $this->container['unwrapArrayProperties'];
    }

    /**
     * Sets unwrapArrayProperties.
     *
     * @param null|mixed $unwrapArrayProperties unwrapArrayProperties
     *
     * @return self
     */
    public function setUnwrapArrayProperties($unwrapArrayProperties)
    {
        if (is_null($unwrapArrayProperties)) {
            array_push($this->openAPINullablesSetToNull, 'unwrapArrayProperties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('unwrapArrayProperties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['unwrapArrayProperties'] = $unwrapArrayProperties;

        return $this;
    }

    /**
     * Gets defaultTextPropertySearchFormat.
     *
     * @return null|ContentCloudSearchFormat
     */
    public function getDefaultTextPropertySearchFormat()
    {
        return $this->container['defaultTextPropertySearchFormat'];
    }

    /**
     * Sets defaultTextPropertySearchFormat.
     *
     * @param null|ContentCloudSearchFormat $defaultTextPropertySearchFormat defaultTextPropertySearchFormat
     *
     * @return self
     */
    public function setDefaultTextPropertySearchFormat($defaultTextPropertySearchFormat)
    {
        if (is_null($defaultTextPropertySearchFormat)) {
            array_push($this->openAPINullablesSetToNull, 'defaultTextPropertySearchFormat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('defaultTextPropertySearchFormat', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['defaultTextPropertySearchFormat'] = $defaultTextPropertySearchFormat;

        return $this;
    }

    /**
     * Gets propertySearchFormat.
     *
     * @return null|mixed
     */
    public function getPropertySearchFormat()
    {
        return $this->container['propertySearchFormat'];
    }

    /**
     * Sets propertySearchFormat.
     *
     * @param null|mixed $propertySearchFormat propertySearchFormat
     *
     * @return self
     */
    public function setPropertySearchFormat($propertySearchFormat)
    {
        if (is_null($propertySearchFormat)) {
            array_push($this->openAPINullablesSetToNull, 'propertySearchFormat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('propertySearchFormat', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['propertySearchFormat'] = $propertySearchFormat;

        return $this;
    }

    /**
     * Gets millisecondTimestamps.
     *
     * @return null|bool
     */
    public function getMillisecondTimestamps()
    {
        return $this->container['millisecondTimestamps'];
    }

    /**
     * Sets millisecondTimestamps.
     *
     * @param null|bool $millisecondTimestamps millisecondTimestamps
     *
     * @return self
     */
    public function setMillisecondTimestamps($millisecondTimestamps)
    {
        if (is_null($millisecondTimestamps)) {
            array_push($this->openAPINullablesSetToNull, 'millisecondTimestamps');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('millisecondTimestamps', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['millisecondTimestamps'] = $millisecondTimestamps;

        return $this;
    }

    /**
     * Gets assignTypes.
     *
     * @return null|mixed
     */
    public function getAssignTypes()
    {
        return $this->container['assignTypes'];
    }

    /**
     * Sets assignTypes.
     *
     * @param null|mixed $assignTypes assignTypes
     *
     * @return self
     */
    public function setAssignTypes($assignTypes)
    {
        if (is_null($assignTypes)) {
            array_push($this->openAPINullablesSetToNull, 'assignTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('assignTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['assignTypes'] = $assignTypes;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
