<?php

/**
 * TransformerContentTypeSettings.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * TransformerContentTypeSettings Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class TransformerContentTypeSettings implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'TransformerContentTypeSettings';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'customIdPrefix' => 'string',
        'contentTypeNameTargetCase' => 'NamingConventionCase',
        'renameContentTypeNamespaces' => 'mixed',
        'renameContentTypes' => 'mixed',
        'removeContentTypes' => 'string[]',
        'embedContentTypes' => 'string[]',
        'tagContentTypes' => 'string[]',
        'assetContentTypes' => 'string[]',
        'withInheritance' => 'bool',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'customIdPrefix' => null,
        'contentTypeNameTargetCase' => null,
        'renameContentTypeNamespaces' => null,
        'renameContentTypes' => null,
        'removeContentTypes' => null,
        'embedContentTypes' => null,
        'tagContentTypes' => null,
        'assetContentTypes' => null,
        'withInheritance' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'customIdPrefix' => true,
        'contentTypeNameTargetCase' => true,
        'renameContentTypeNamespaces' => true,
        'renameContentTypes' => true,
        'removeContentTypes' => true,
        'embedContentTypes' => true,
        'tagContentTypes' => true,
        'assetContentTypes' => true,
        'withInheritance' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customIdPrefix' => 'customIdPrefix',
        'contentTypeNameTargetCase' => 'contentTypeNameTargetCase',
        'renameContentTypeNamespaces' => 'renameContentTypeNamespaces',
        'renameContentTypes' => 'renameContentTypes',
        'removeContentTypes' => 'removeContentTypes',
        'embedContentTypes' => 'embedContentTypes',
        'tagContentTypes' => 'tagContentTypes',
        'assetContentTypes' => 'assetContentTypes',
        'withInheritance' => 'withInheritance',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'customIdPrefix' => 'setCustomIdPrefix',
        'contentTypeNameTargetCase' => 'setContentTypeNameTargetCase',
        'renameContentTypeNamespaces' => 'setRenameContentTypeNamespaces',
        'renameContentTypes' => 'setRenameContentTypes',
        'removeContentTypes' => 'setRemoveContentTypes',
        'embedContentTypes' => 'setEmbedContentTypes',
        'tagContentTypes' => 'setTagContentTypes',
        'assetContentTypes' => 'setAssetContentTypes',
        'withInheritance' => 'setWithInheritance',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'customIdPrefix' => 'getCustomIdPrefix',
        'contentTypeNameTargetCase' => 'getContentTypeNameTargetCase',
        'renameContentTypeNamespaces' => 'getRenameContentTypeNamespaces',
        'renameContentTypes' => 'getRenameContentTypes',
        'removeContentTypes' => 'getRemoveContentTypes',
        'embedContentTypes' => 'getEmbedContentTypes',
        'tagContentTypes' => 'getTagContentTypes',
        'assetContentTypes' => 'getAssetContentTypes',
        'withInheritance' => 'getWithInheritance',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customIdPrefix', $data ?? [], null);
        $this->setIfExists('contentTypeNameTargetCase', $data ?? [], null);
        $this->setIfExists('renameContentTypeNamespaces', $data ?? [], null);
        $this->setIfExists('renameContentTypes', $data ?? [], null);
        $this->setIfExists('removeContentTypes', $data ?? [], null);
        $this->setIfExists('embedContentTypes', $data ?? [], null);
        $this->setIfExists('tagContentTypes', $data ?? [], null);
        $this->setIfExists('assetContentTypes', $data ?? [], null);
        $this->setIfExists('withInheritance', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets customIdPrefix.
     *
     * @return null|string
     */
    public function getCustomIdPrefix()
    {
        return $this->container['customIdPrefix'];
    }

    /**
     * Sets customIdPrefix.
     *
     * @param null|string $customIdPrefix customIdPrefix
     *
     * @return self
     */
    public function setCustomIdPrefix($customIdPrefix)
    {
        if (is_null($customIdPrefix)) {
            array_push($this->openAPINullablesSetToNull, 'customIdPrefix');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customIdPrefix', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customIdPrefix'] = $customIdPrefix;

        return $this;
    }

    /**
     * Gets contentTypeNameTargetCase.
     *
     * @return null|NamingConventionCase
     */
    public function getContentTypeNameTargetCase()
    {
        return $this->container['contentTypeNameTargetCase'];
    }

    /**
     * Sets contentTypeNameTargetCase.
     *
     * @param null|NamingConventionCase $contentTypeNameTargetCase contentTypeNameTargetCase
     *
     * @return self
     */
    public function setContentTypeNameTargetCase($contentTypeNameTargetCase)
    {
        if (is_null($contentTypeNameTargetCase)) {
            array_push($this->openAPINullablesSetToNull, 'contentTypeNameTargetCase');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('contentTypeNameTargetCase', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['contentTypeNameTargetCase'] = $contentTypeNameTargetCase;

        return $this;
    }

    /**
     * Gets renameContentTypeNamespaces.
     *
     * @return null|mixed
     */
    public function getRenameContentTypeNamespaces()
    {
        return $this->container['renameContentTypeNamespaces'];
    }

    /**
     * Sets renameContentTypeNamespaces.
     *
     * @param null|mixed $renameContentTypeNamespaces renameContentTypeNamespaces
     *
     * @return self
     */
    public function setRenameContentTypeNamespaces($renameContentTypeNamespaces)
    {
        if (is_null($renameContentTypeNamespaces)) {
            array_push($this->openAPINullablesSetToNull, 'renameContentTypeNamespaces');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('renameContentTypeNamespaces', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['renameContentTypeNamespaces'] = $renameContentTypeNamespaces;

        return $this;
    }

    /**
     * Gets renameContentTypes.
     *
     * @return null|mixed
     */
    public function getRenameContentTypes()
    {
        return $this->container['renameContentTypes'];
    }

    /**
     * Sets renameContentTypes.
     *
     * @param null|mixed $renameContentTypes renameContentTypes
     *
     * @return self
     */
    public function setRenameContentTypes($renameContentTypes)
    {
        if (is_null($renameContentTypes)) {
            array_push($this->openAPINullablesSetToNull, 'renameContentTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('renameContentTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['renameContentTypes'] = $renameContentTypes;

        return $this;
    }

    /**
     * Gets removeContentTypes.
     *
     * @return null|string[]
     */
    public function getRemoveContentTypes()
    {
        return $this->container['removeContentTypes'];
    }

    /**
     * Sets removeContentTypes.
     *
     * @param null|string[] $removeContentTypes removeContentTypes
     *
     * @return self
     */
    public function setRemoveContentTypes($removeContentTypes)
    {
        if (is_null($removeContentTypes)) {
            array_push($this->openAPINullablesSetToNull, 'removeContentTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('removeContentTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['removeContentTypes'] = $removeContentTypes;

        return $this;
    }

    /**
     * Gets embedContentTypes.
     *
     * @return null|string[]
     */
    public function getEmbedContentTypes()
    {
        return $this->container['embedContentTypes'];
    }

    /**
     * Sets embedContentTypes.
     *
     * @param null|string[] $embedContentTypes embedContentTypes
     *
     * @return self
     */
    public function setEmbedContentTypes($embedContentTypes)
    {
        if (is_null($embedContentTypes)) {
            array_push($this->openAPINullablesSetToNull, 'embedContentTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('embedContentTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['embedContentTypes'] = $embedContentTypes;

        return $this;
    }

    /**
     * Gets tagContentTypes.
     *
     * @return null|string[]
     */
    public function getTagContentTypes()
    {
        return $this->container['tagContentTypes'];
    }

    /**
     * Sets tagContentTypes.
     *
     * @param null|string[] $tagContentTypes tagContentTypes
     *
     * @return self
     */
    public function setTagContentTypes($tagContentTypes)
    {
        if (is_null($tagContentTypes)) {
            array_push($this->openAPINullablesSetToNull, 'tagContentTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tagContentTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tagContentTypes'] = $tagContentTypes;

        return $this;
    }

    /**
     * Gets assetContentTypes.
     *
     * @return null|string[]
     */
    public function getAssetContentTypes()
    {
        return $this->container['assetContentTypes'];
    }

    /**
     * Sets assetContentTypes.
     *
     * @param null|string[] $assetContentTypes assetContentTypes
     *
     * @return self
     */
    public function setAssetContentTypes($assetContentTypes)
    {
        if (is_null($assetContentTypes)) {
            array_push($this->openAPINullablesSetToNull, 'assetContentTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('assetContentTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['assetContentTypes'] = $assetContentTypes;

        return $this;
    }

    /**
     * Gets withInheritance.
     *
     * @return null|bool
     */
    public function getWithInheritance()
    {
        return $this->container['withInheritance'];
    }

    /**
     * Sets withInheritance.
     *
     * @param null|bool $withInheritance withInheritance
     *
     * @return self
     */
    public function setWithInheritance($withInheritance)
    {
        if (is_null($withInheritance)) {
            array_push($this->openAPINullablesSetToNull, 'withInheritance');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('withInheritance', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['withInheritance'] = $withInheritance;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
