<?php

/**
 * SyndicationUsageSummary.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SyndicationUsageSummary Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SyndicationUsageSummary implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SyndicationUsageSummary';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'startedAt' => 'float',
        'finishedAt' => 'float',
        'thisSite' => '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationUsageSummaryThisSite',
        'sourceSite' => 'SyndicationEntityWithUsage',
        'targetSite' => 'SyndicationEntityWithUsage',
        'targetSites' => '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage[]',
        'targetSummary' => '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationUsageSummaryStatusGroup[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'startedAt' => null,
        'finishedAt' => null,
        'thisSite' => null,
        'sourceSite' => null,
        'targetSite' => null,
        'targetSites' => null,
        'targetSummary' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'startedAt' => false,
        'finishedAt' => true,
        'thisSite' => false,
        'sourceSite' => true,
        'targetSite' => true,
        'targetSites' => true,
        'targetSummary' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'startedAt' => 'startedAt',
        'finishedAt' => 'finishedAt',
        'thisSite' => 'thisSite',
        'sourceSite' => 'sourceSite',
        'targetSite' => 'targetSite',
        'targetSites' => 'targetSites',
        'targetSummary' => 'targetSummary',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'startedAt' => 'setStartedAt',
        'finishedAt' => 'setFinishedAt',
        'thisSite' => 'setThisSite',
        'sourceSite' => 'setSourceSite',
        'targetSite' => 'setTargetSite',
        'targetSites' => 'setTargetSites',
        'targetSummary' => 'setTargetSummary',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'startedAt' => 'getStartedAt',
        'finishedAt' => 'getFinishedAt',
        'thisSite' => 'getThisSite',
        'sourceSite' => 'getSourceSite',
        'targetSite' => 'getTargetSite',
        'targetSites' => 'getTargetSites',
        'targetSummary' => 'getTargetSummary',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('startedAt', $data ?? [], null);
        $this->setIfExists('finishedAt', $data ?? [], null);
        $this->setIfExists('thisSite', $data ?? [], null);
        $this->setIfExists('sourceSite', $data ?? [], null);
        $this->setIfExists('targetSite', $data ?? [], null);
        $this->setIfExists('targetSites', $data ?? [], null);
        $this->setIfExists('targetSummary', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['startedAt']) {
            $invalidProperties[] = "'startedAt' can't be null";
        }
        if (null === $this->container['thisSite']) {
            $invalidProperties[] = "'thisSite' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets startedAt.
     *
     * @return float
     */
    public function getStartedAt()
    {
        return $this->container['startedAt'];
    }

    /**
     * Sets startedAt.
     *
     * @param float $startedAt startedAt
     *
     * @return self
     */
    public function setStartedAt($startedAt)
    {
        if (is_null($startedAt)) {
            throw new \InvalidArgumentException('non-nullable startedAt cannot be null');
        }
        $this->container['startedAt'] = $startedAt;

        return $this;
    }

    /**
     * Gets finishedAt.
     *
     * @return null|float
     */
    public function getFinishedAt()
    {
        return $this->container['finishedAt'];
    }

    /**
     * Sets finishedAt.
     *
     * @param null|float $finishedAt finishedAt
     *
     * @return self
     */
    public function setFinishedAt($finishedAt)
    {
        if (is_null($finishedAt)) {
            array_push($this->openAPINullablesSetToNull, 'finishedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('finishedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['finishedAt'] = $finishedAt;

        return $this;
    }

    /**
     * Gets thisSite.
     *
     * @return SyndicationUsageSummaryThisSite
     */
    public function getThisSite()
    {
        return $this->container['thisSite'];
    }

    /**
     * Sets thisSite.
     *
     * @param SyndicationUsageSummaryThisSite $thisSite thisSite
     *
     * @return self
     */
    public function setThisSite($thisSite)
    {
        if (is_null($thisSite)) {
            throw new \InvalidArgumentException('non-nullable thisSite cannot be null');
        }
        $this->container['thisSite'] = $thisSite;

        return $this;
    }

    /**
     * Gets sourceSite.
     *
     * @return null|SyndicationEntityWithUsage
     */
    public function getSourceSite()
    {
        return $this->container['sourceSite'];
    }

    /**
     * Sets sourceSite.
     *
     * @param null|SyndicationEntityWithUsage $sourceSite sourceSite
     *
     * @return self
     */
    public function setSourceSite($sourceSite)
    {
        if (is_null($sourceSite)) {
            array_push($this->openAPINullablesSetToNull, 'sourceSite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sourceSite', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sourceSite'] = $sourceSite;

        return $this;
    }

    /**
     * Gets targetSite.
     *
     * @return null|SyndicationEntityWithUsage
     */
    public function getTargetSite()
    {
        return $this->container['targetSite'];
    }

    /**
     * Sets targetSite.
     *
     * @param null|SyndicationEntityWithUsage $targetSite targetSite
     *
     * @return self
     */
    public function setTargetSite($targetSite)
    {
        if (is_null($targetSite)) {
            array_push($this->openAPINullablesSetToNull, 'targetSite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('targetSite', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['targetSite'] = $targetSite;

        return $this;
    }

    /**
     * Gets targetSites.
     *
     * @return null|SyndicationEntityWithUsage[]
     */
    public function getTargetSites()
    {
        return $this->container['targetSites'];
    }

    /**
     * Sets targetSites.
     *
     * @param null|SyndicationEntityWithUsage[] $targetSites targetSites
     *
     * @return self
     */
    public function setTargetSites($targetSites)
    {
        if (is_null($targetSites)) {
            array_push($this->openAPINullablesSetToNull, 'targetSites');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('targetSites', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['targetSites'] = $targetSites;

        return $this;
    }

    /**
     * Gets targetSummary.
     *
     * @return null|SyndicationUsageSummaryStatusGroup[]
     */
    public function getTargetSummary()
    {
        return $this->container['targetSummary'];
    }

    /**
     * Sets targetSummary.
     *
     * @param null|SyndicationUsageSummaryStatusGroup[] $targetSummary targetSummary
     *
     * @return self
     */
    public function setTargetSummary($targetSummary)
    {
        if (is_null($targetSummary)) {
            array_push($this->openAPINullablesSetToNull, 'targetSummary');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('targetSummary', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['targetSummary'] = $targetSummary;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
