<?php

/**
 * SyndicationEntityWithUsage.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SyndicationEntityWithUsage Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SyndicationEntityWithUsage implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SyndicationEntityWithUsage';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'rootEntityReference' => 'RemoteEntityReference',
        'rootEntityDetails' => 'RemoteEntityDetails',
        'status' => 'SyndicationStatus',
        'type' => 'SyndicationType',
        'rootEntity' => 'DynamicReference',
        'rootEntityType' => 'DynamicReference',
        'rootEntityTypeVersion' => 'DynamicReference',
        'targetSite' => 'DynamicReference',
        'pools' => '\EdgeBox\SyncCore\V2\Raw\Model\DynamicReference[]',
        'flow' => 'DynamicReference',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'project' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'operations' => '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationOperation[]',
        'migration' => 'DynamicReference',
        'migrationType' => 'MigrationType',
        'webhook' => 'DynamicReference',
        'webhookEntityType' => 'WebhookEntityType',
        'finishedAt' => 'float',
        'dryRun' => 'bool',
        'skipSyndication' => 'bool',
        'skipOptimization' => 'bool',
        'isUpdate' => 'bool',
        'isAutoUpdate' => 'bool',
        'isRegularSyndication' => 'bool',
        'changedLanguages' => 'string[]',
        'deletedLanguages' => 'string[]',
        'rdTotal' => 'float',
        'rdCount' => 'float',
        'rdAverage' => 'float',
        'rdShortest' => 'float',
        'rdLongest' => 'float',
        'duration' => 'float',
        'fullDuration' => 'float',
        'skipUnchanged' => 'bool',
        'trace' => 'bool',
        'priority' => 'float',
        'projectLinkTargets' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeSyndicationProjectLinkTarget[]',
        'dependsOnSyndication' => 'DynamicReference',
        'runAfterSyndication' => 'DynamicReference',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
        'originalType' => 'SyndicationType',
        'isClone' => 'bool',
        'usage' => 'RemoteEntityUsageEntity',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'rootEntityReference' => null,
        'rootEntityDetails' => null,
        'status' => null,
        'type' => null,
        'rootEntity' => null,
        'rootEntityType' => null,
        'rootEntityTypeVersion' => null,
        'targetSite' => null,
        'pools' => null,
        'flow' => null,
        'customer' => null,
        'project' => null,
        'operations' => null,
        'migration' => null,
        'migrationType' => null,
        'webhook' => null,
        'webhookEntityType' => null,
        'finishedAt' => null,
        'dryRun' => null,
        'skipSyndication' => null,
        'skipOptimization' => null,
        'isUpdate' => null,
        'isAutoUpdate' => null,
        'isRegularSyndication' => null,
        'changedLanguages' => null,
        'deletedLanguages' => null,
        'rdTotal' => null,
        'rdCount' => null,
        'rdAverage' => null,
        'rdShortest' => null,
        'rdLongest' => null,
        'duration' => null,
        'fullDuration' => null,
        'skipUnchanged' => null,
        'trace' => null,
        'priority' => null,
        'projectLinkTargets' => null,
        'dependsOnSyndication' => null,
        'runAfterSyndication' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
        'originalType' => null,
        'isClone' => null,
        'usage' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'rootEntityReference' => true,
        'rootEntityDetails' => true,
        'status' => false,
        'type' => false,
        'rootEntity' => true,
        'rootEntityType' => true,
        'rootEntityTypeVersion' => true,
        'targetSite' => true,
        'pools' => true,
        'flow' => true,
        'customer' => false,
        'project' => false,
        'operations' => true,
        'migration' => true,
        'migrationType' => true,
        'webhook' => true,
        'webhookEntityType' => true,
        'finishedAt' => true,
        'dryRun' => true,
        'skipSyndication' => true,
        'skipOptimization' => true,
        'isUpdate' => true,
        'isAutoUpdate' => true,
        'isRegularSyndication' => true,
        'changedLanguages' => true,
        'deletedLanguages' => true,
        'rdTotal' => true,
        'rdCount' => true,
        'rdAverage' => true,
        'rdShortest' => true,
        'rdLongest' => true,
        'duration' => true,
        'fullDuration' => true,
        'skipUnchanged' => true,
        'trace' => true,
        'priority' => true,
        'projectLinkTargets' => true,
        'dependsOnSyndication' => true,
        'runAfterSyndication' => true,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
        'originalType' => true,
        'isClone' => true,
        'usage' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rootEntityReference' => 'rootEntityReference',
        'rootEntityDetails' => 'rootEntityDetails',
        'status' => 'status',
        'type' => 'type',
        'rootEntity' => 'rootEntity',
        'rootEntityType' => 'rootEntityType',
        'rootEntityTypeVersion' => 'rootEntityTypeVersion',
        'targetSite' => 'targetSite',
        'pools' => 'pools',
        'flow' => 'flow',
        'customer' => 'customer',
        'project' => 'project',
        'operations' => 'operations',
        'migration' => 'migration',
        'migrationType' => 'migrationType',
        'webhook' => 'webhook',
        'webhookEntityType' => 'webhookEntityType',
        'finishedAt' => 'finishedAt',
        'dryRun' => 'dryRun',
        'skipSyndication' => 'skipSyndication',
        'skipOptimization' => 'skipOptimization',
        'isUpdate' => 'isUpdate',
        'isAutoUpdate' => 'isAutoUpdate',
        'isRegularSyndication' => 'isRegularSyndication',
        'changedLanguages' => 'changedLanguages',
        'deletedLanguages' => 'deletedLanguages',
        'rdTotal' => 'rdTotal',
        'rdCount' => 'rdCount',
        'rdAverage' => 'rdAverage',
        'rdShortest' => 'rdShortest',
        'rdLongest' => 'rdLongest',
        'duration' => 'duration',
        'fullDuration' => 'fullDuration',
        'skipUnchanged' => 'skipUnchanged',
        'trace' => 'trace',
        'priority' => 'priority',
        'projectLinkTargets' => 'projectLinkTargets',
        'dependsOnSyndication' => 'dependsOnSyndication',
        'runAfterSyndication' => 'runAfterSyndication',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
        'originalType' => 'originalType',
        'isClone' => 'isClone',
        'usage' => 'usage',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'rootEntityReference' => 'setRootEntityReference',
        'rootEntityDetails' => 'setRootEntityDetails',
        'status' => 'setStatus',
        'type' => 'setType',
        'rootEntity' => 'setRootEntity',
        'rootEntityType' => 'setRootEntityType',
        'rootEntityTypeVersion' => 'setRootEntityTypeVersion',
        'targetSite' => 'setTargetSite',
        'pools' => 'setPools',
        'flow' => 'setFlow',
        'customer' => 'setCustomer',
        'project' => 'setProject',
        'operations' => 'setOperations',
        'migration' => 'setMigration',
        'migrationType' => 'setMigrationType',
        'webhook' => 'setWebhook',
        'webhookEntityType' => 'setWebhookEntityType',
        'finishedAt' => 'setFinishedAt',
        'dryRun' => 'setDryRun',
        'skipSyndication' => 'setSkipSyndication',
        'skipOptimization' => 'setSkipOptimization',
        'isUpdate' => 'setIsUpdate',
        'isAutoUpdate' => 'setIsAutoUpdate',
        'isRegularSyndication' => 'setIsRegularSyndication',
        'changedLanguages' => 'setChangedLanguages',
        'deletedLanguages' => 'setDeletedLanguages',
        'rdTotal' => 'setRdTotal',
        'rdCount' => 'setRdCount',
        'rdAverage' => 'setRdAverage',
        'rdShortest' => 'setRdShortest',
        'rdLongest' => 'setRdLongest',
        'duration' => 'setDuration',
        'fullDuration' => 'setFullDuration',
        'skipUnchanged' => 'setSkipUnchanged',
        'trace' => 'setTrace',
        'priority' => 'setPriority',
        'projectLinkTargets' => 'setProjectLinkTargets',
        'dependsOnSyndication' => 'setDependsOnSyndication',
        'runAfterSyndication' => 'setRunAfterSyndication',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
        'originalType' => 'setOriginalType',
        'isClone' => 'setIsClone',
        'usage' => 'setUsage',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'rootEntityReference' => 'getRootEntityReference',
        'rootEntityDetails' => 'getRootEntityDetails',
        'status' => 'getStatus',
        'type' => 'getType',
        'rootEntity' => 'getRootEntity',
        'rootEntityType' => 'getRootEntityType',
        'rootEntityTypeVersion' => 'getRootEntityTypeVersion',
        'targetSite' => 'getTargetSite',
        'pools' => 'getPools',
        'flow' => 'getFlow',
        'customer' => 'getCustomer',
        'project' => 'getProject',
        'operations' => 'getOperations',
        'migration' => 'getMigration',
        'migrationType' => 'getMigrationType',
        'webhook' => 'getWebhook',
        'webhookEntityType' => 'getWebhookEntityType',
        'finishedAt' => 'getFinishedAt',
        'dryRun' => 'getDryRun',
        'skipSyndication' => 'getSkipSyndication',
        'skipOptimization' => 'getSkipOptimization',
        'isUpdate' => 'getIsUpdate',
        'isAutoUpdate' => 'getIsAutoUpdate',
        'isRegularSyndication' => 'getIsRegularSyndication',
        'changedLanguages' => 'getChangedLanguages',
        'deletedLanguages' => 'getDeletedLanguages',
        'rdTotal' => 'getRdTotal',
        'rdCount' => 'getRdCount',
        'rdAverage' => 'getRdAverage',
        'rdShortest' => 'getRdShortest',
        'rdLongest' => 'getRdLongest',
        'duration' => 'getDuration',
        'fullDuration' => 'getFullDuration',
        'skipUnchanged' => 'getSkipUnchanged',
        'trace' => 'getTrace',
        'priority' => 'getPriority',
        'projectLinkTargets' => 'getProjectLinkTargets',
        'dependsOnSyndication' => 'getDependsOnSyndication',
        'runAfterSyndication' => 'getRunAfterSyndication',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
        'originalType' => 'getOriginalType',
        'isClone' => 'getIsClone',
        'usage' => 'getUsage',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('rootEntityReference', $data ?? [], null);
        $this->setIfExists('rootEntityDetails', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('rootEntity', $data ?? [], null);
        $this->setIfExists('rootEntityType', $data ?? [], null);
        $this->setIfExists('rootEntityTypeVersion', $data ?? [], null);
        $this->setIfExists('targetSite', $data ?? [], null);
        $this->setIfExists('pools', $data ?? [], null);
        $this->setIfExists('flow', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('project', $data ?? [], null);
        $this->setIfExists('operations', $data ?? [], null);
        $this->setIfExists('migration', $data ?? [], null);
        $this->setIfExists('migrationType', $data ?? [], null);
        $this->setIfExists('webhook', $data ?? [], null);
        $this->setIfExists('webhookEntityType', $data ?? [], null);
        $this->setIfExists('finishedAt', $data ?? [], null);
        $this->setIfExists('dryRun', $data ?? [], null);
        $this->setIfExists('skipSyndication', $data ?? [], null);
        $this->setIfExists('skipOptimization', $data ?? [], null);
        $this->setIfExists('isUpdate', $data ?? [], null);
        $this->setIfExists('isAutoUpdate', $data ?? [], null);
        $this->setIfExists('isRegularSyndication', $data ?? [], null);
        $this->setIfExists('changedLanguages', $data ?? [], null);
        $this->setIfExists('deletedLanguages', $data ?? [], null);
        $this->setIfExists('rdTotal', $data ?? [], null);
        $this->setIfExists('rdCount', $data ?? [], null);
        $this->setIfExists('rdAverage', $data ?? [], null);
        $this->setIfExists('rdShortest', $data ?? [], null);
        $this->setIfExists('rdLongest', $data ?? [], null);
        $this->setIfExists('duration', $data ?? [], null);
        $this->setIfExists('fullDuration', $data ?? [], null);
        $this->setIfExists('skipUnchanged', $data ?? [], null);
        $this->setIfExists('trace', $data ?? [], null);
        $this->setIfExists('priority', $data ?? [], null);
        $this->setIfExists('projectLinkTargets', $data ?? [], null);
        $this->setIfExists('dependsOnSyndication', $data ?? [], null);
        $this->setIfExists('runAfterSyndication', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
        $this->setIfExists('originalType', $data ?? [], null);
        $this->setIfExists('isClone', $data ?? [], null);
        $this->setIfExists('usage', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }
        if (null === $this->container['type']) {
            $invalidProperties[] = "'type' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['project']) {
            $invalidProperties[] = "'project' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets rootEntityReference.
     *
     * @return null|RemoteEntityReference
     */
    public function getRootEntityReference()
    {
        return $this->container['rootEntityReference'];
    }

    /**
     * Sets rootEntityReference.
     *
     * @param null|RemoteEntityReference $rootEntityReference rootEntityReference
     *
     * @return self
     */
    public function setRootEntityReference($rootEntityReference)
    {
        if (is_null($rootEntityReference)) {
            array_push($this->openAPINullablesSetToNull, 'rootEntityReference');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rootEntityReference', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rootEntityReference'] = $rootEntityReference;

        return $this;
    }

    /**
     * Gets rootEntityDetails.
     *
     * @return null|RemoteEntityDetails
     */
    public function getRootEntityDetails()
    {
        return $this->container['rootEntityDetails'];
    }

    /**
     * Sets rootEntityDetails.
     *
     * @param null|RemoteEntityDetails $rootEntityDetails rootEntityDetails
     *
     * @return self
     */
    public function setRootEntityDetails($rootEntityDetails)
    {
        if (is_null($rootEntityDetails)) {
            array_push($this->openAPINullablesSetToNull, 'rootEntityDetails');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rootEntityDetails', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rootEntityDetails'] = $rootEntityDetails;

        return $this;
    }

    /**
     * Gets status.
     *
     * @return SyndicationStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param SyndicationStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets type.
     *
     * @return SyndicationType
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type.
     *
     * @param SyndicationType $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets rootEntity.
     *
     * @return null|DynamicReference
     */
    public function getRootEntity()
    {
        return $this->container['rootEntity'];
    }

    /**
     * Sets rootEntity.
     *
     * @param null|DynamicReference $rootEntity rootEntity
     *
     * @return self
     */
    public function setRootEntity($rootEntity)
    {
        if (is_null($rootEntity)) {
            array_push($this->openAPINullablesSetToNull, 'rootEntity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rootEntity', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rootEntity'] = $rootEntity;

        return $this;
    }

    /**
     * Gets rootEntityType.
     *
     * @return null|DynamicReference
     */
    public function getRootEntityType()
    {
        return $this->container['rootEntityType'];
    }

    /**
     * Sets rootEntityType.
     *
     * @param null|DynamicReference $rootEntityType rootEntityType
     *
     * @return self
     */
    public function setRootEntityType($rootEntityType)
    {
        if (is_null($rootEntityType)) {
            array_push($this->openAPINullablesSetToNull, 'rootEntityType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rootEntityType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rootEntityType'] = $rootEntityType;

        return $this;
    }

    /**
     * Gets rootEntityTypeVersion.
     *
     * @return null|DynamicReference
     */
    public function getRootEntityTypeVersion()
    {
        return $this->container['rootEntityTypeVersion'];
    }

    /**
     * Sets rootEntityTypeVersion.
     *
     * @param null|DynamicReference $rootEntityTypeVersion rootEntityTypeVersion
     *
     * @return self
     */
    public function setRootEntityTypeVersion($rootEntityTypeVersion)
    {
        if (is_null($rootEntityTypeVersion)) {
            array_push($this->openAPINullablesSetToNull, 'rootEntityTypeVersion');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rootEntityTypeVersion', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rootEntityTypeVersion'] = $rootEntityTypeVersion;

        return $this;
    }

    /**
     * Gets targetSite.
     *
     * @return null|DynamicReference
     */
    public function getTargetSite()
    {
        return $this->container['targetSite'];
    }

    /**
     * Sets targetSite.
     *
     * @param null|DynamicReference $targetSite targetSite
     *
     * @return self
     */
    public function setTargetSite($targetSite)
    {
        if (is_null($targetSite)) {
            array_push($this->openAPINullablesSetToNull, 'targetSite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('targetSite', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['targetSite'] = $targetSite;

        return $this;
    }

    /**
     * Gets pools.
     *
     * @return null|DynamicReference[]
     */
    public function getPools()
    {
        return $this->container['pools'];
    }

    /**
     * Sets pools.
     *
     * @param null|DynamicReference[] $pools pools
     *
     * @return self
     */
    public function setPools($pools)
    {
        if (is_null($pools)) {
            array_push($this->openAPINullablesSetToNull, 'pools');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pools', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pools'] = $pools;

        return $this;
    }

    /**
     * Gets flow.
     *
     * @return null|DynamicReference
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow.
     *
     * @param null|DynamicReference $flow flow
     *
     * @return self
     */
    public function setFlow($flow)
    {
        if (is_null($flow)) {
            array_push($this->openAPINullablesSetToNull, 'flow');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flow', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets project.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getProject()
    {
        return $this->container['project'];
    }

    /**
     * Sets project.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $project project
     *
     * @return self
     */
    public function setProject($project)
    {
        if (is_null($project)) {
            throw new \InvalidArgumentException('non-nullable project cannot be null');
        }
        $this->container['project'] = $project;

        return $this;
    }

    /**
     * Gets operations.
     *
     * @return null|SyndicationOperation[]
     */
    public function getOperations()
    {
        return $this->container['operations'];
    }

    /**
     * Sets operations.
     *
     * @param null|SyndicationOperation[] $operations operations
     *
     * @return self
     */
    public function setOperations($operations)
    {
        if (is_null($operations)) {
            array_push($this->openAPINullablesSetToNull, 'operations');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('operations', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['operations'] = $operations;

        return $this;
    }

    /**
     * Gets migration.
     *
     * @return null|DynamicReference
     */
    public function getMigration()
    {
        return $this->container['migration'];
    }

    /**
     * Sets migration.
     *
     * @param null|DynamicReference $migration migration
     *
     * @return self
     */
    public function setMigration($migration)
    {
        if (is_null($migration)) {
            array_push($this->openAPINullablesSetToNull, 'migration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('migration', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['migration'] = $migration;

        return $this;
    }

    /**
     * Gets migrationType.
     *
     * @return null|MigrationType
     */
    public function getMigrationType()
    {
        return $this->container['migrationType'];
    }

    /**
     * Sets migrationType.
     *
     * @param null|MigrationType $migrationType migrationType
     *
     * @return self
     */
    public function setMigrationType($migrationType)
    {
        if (is_null($migrationType)) {
            array_push($this->openAPINullablesSetToNull, 'migrationType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('migrationType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['migrationType'] = $migrationType;

        return $this;
    }

    /**
     * Gets webhook.
     *
     * @return null|DynamicReference
     */
    public function getWebhook()
    {
        return $this->container['webhook'];
    }

    /**
     * Sets webhook.
     *
     * @param null|DynamicReference $webhook webhook
     *
     * @return self
     */
    public function setWebhook($webhook)
    {
        if (is_null($webhook)) {
            array_push($this->openAPINullablesSetToNull, 'webhook');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('webhook', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['webhook'] = $webhook;

        return $this;
    }

    /**
     * Gets webhookEntityType.
     *
     * @return null|WebhookEntityType
     */
    public function getWebhookEntityType()
    {
        return $this->container['webhookEntityType'];
    }

    /**
     * Sets webhookEntityType.
     *
     * @param null|WebhookEntityType $webhookEntityType webhookEntityType
     *
     * @return self
     */
    public function setWebhookEntityType($webhookEntityType)
    {
        if (is_null($webhookEntityType)) {
            array_push($this->openAPINullablesSetToNull, 'webhookEntityType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('webhookEntityType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['webhookEntityType'] = $webhookEntityType;

        return $this;
    }

    /**
     * Gets finishedAt.
     *
     * @return null|float
     */
    public function getFinishedAt()
    {
        return $this->container['finishedAt'];
    }

    /**
     * Sets finishedAt.
     *
     * @param null|float $finishedAt finishedAt
     *
     * @return self
     */
    public function setFinishedAt($finishedAt)
    {
        if (is_null($finishedAt)) {
            array_push($this->openAPINullablesSetToNull, 'finishedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('finishedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['finishedAt'] = $finishedAt;

        return $this;
    }

    /**
     * Gets dryRun.
     *
     * @return null|bool
     */
    public function getDryRun()
    {
        return $this->container['dryRun'];
    }

    /**
     * Sets dryRun.
     *
     * @param null|bool $dryRun dryRun
     *
     * @return self
     */
    public function setDryRun($dryRun)
    {
        if (is_null($dryRun)) {
            array_push($this->openAPINullablesSetToNull, 'dryRun');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dryRun', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dryRun'] = $dryRun;

        return $this;
    }

    /**
     * Gets skipSyndication.
     *
     * @return null|bool
     */
    public function getSkipSyndication()
    {
        return $this->container['skipSyndication'];
    }

    /**
     * Sets skipSyndication.
     *
     * @param null|bool $skipSyndication skipSyndication
     *
     * @return self
     */
    public function setSkipSyndication($skipSyndication)
    {
        if (is_null($skipSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'skipSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipSyndication'] = $skipSyndication;

        return $this;
    }

    /**
     * Gets skipOptimization.
     *
     * @return null|bool
     */
    public function getSkipOptimization()
    {
        return $this->container['skipOptimization'];
    }

    /**
     * Sets skipOptimization.
     *
     * @param null|bool $skipOptimization skipOptimization
     *
     * @return self
     */
    public function setSkipOptimization($skipOptimization)
    {
        if (is_null($skipOptimization)) {
            array_push($this->openAPINullablesSetToNull, 'skipOptimization');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipOptimization', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipOptimization'] = $skipOptimization;

        return $this;
    }

    /**
     * Gets isUpdate.
     *
     * @return null|bool
     */
    public function getIsUpdate()
    {
        return $this->container['isUpdate'];
    }

    /**
     * Sets isUpdate.
     *
     * @param null|bool $isUpdate isUpdate
     *
     * @return self
     */
    public function setIsUpdate($isUpdate)
    {
        if (is_null($isUpdate)) {
            array_push($this->openAPINullablesSetToNull, 'isUpdate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isUpdate', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['isUpdate'] = $isUpdate;

        return $this;
    }

    /**
     * Gets isAutoUpdate.
     *
     * @return null|bool
     */
    public function getIsAutoUpdate()
    {
        return $this->container['isAutoUpdate'];
    }

    /**
     * Sets isAutoUpdate.
     *
     * @param null|bool $isAutoUpdate isAutoUpdate
     *
     * @return self
     */
    public function setIsAutoUpdate($isAutoUpdate)
    {
        if (is_null($isAutoUpdate)) {
            array_push($this->openAPINullablesSetToNull, 'isAutoUpdate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isAutoUpdate', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['isAutoUpdate'] = $isAutoUpdate;

        return $this;
    }

    /**
     * Gets isRegularSyndication.
     *
     * @return null|bool
     */
    public function getIsRegularSyndication()
    {
        return $this->container['isRegularSyndication'];
    }

    /**
     * Sets isRegularSyndication.
     *
     * @param null|bool $isRegularSyndication isRegularSyndication
     *
     * @return self
     */
    public function setIsRegularSyndication($isRegularSyndication)
    {
        if (is_null($isRegularSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'isRegularSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isRegularSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['isRegularSyndication'] = $isRegularSyndication;

        return $this;
    }

    /**
     * Gets changedLanguages.
     *
     * @return null|string[]
     */
    public function getChangedLanguages()
    {
        return $this->container['changedLanguages'];
    }

    /**
     * Sets changedLanguages.
     *
     * @param null|string[] $changedLanguages changedLanguages
     *
     * @return self
     */
    public function setChangedLanguages($changedLanguages)
    {
        if (is_null($changedLanguages)) {
            array_push($this->openAPINullablesSetToNull, 'changedLanguages');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('changedLanguages', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['changedLanguages'] = $changedLanguages;

        return $this;
    }

    /**
     * Gets deletedLanguages.
     *
     * @return null|string[]
     */
    public function getDeletedLanguages()
    {
        return $this->container['deletedLanguages'];
    }

    /**
     * Sets deletedLanguages.
     *
     * @param null|string[] $deletedLanguages deletedLanguages
     *
     * @return self
     */
    public function setDeletedLanguages($deletedLanguages)
    {
        if (is_null($deletedLanguages)) {
            array_push($this->openAPINullablesSetToNull, 'deletedLanguages');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedLanguages', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedLanguages'] = $deletedLanguages;

        return $this;
    }

    /**
     * Gets rdTotal.
     *
     * @return null|float
     */
    public function getRdTotal()
    {
        return $this->container['rdTotal'];
    }

    /**
     * Sets rdTotal.
     *
     * @param null|float $rdTotal rdTotal
     *
     * @return self
     */
    public function setRdTotal($rdTotal)
    {
        if (is_null($rdTotal)) {
            array_push($this->openAPINullablesSetToNull, 'rdTotal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rdTotal', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rdTotal'] = $rdTotal;

        return $this;
    }

    /**
     * Gets rdCount.
     *
     * @return null|float
     */
    public function getRdCount()
    {
        return $this->container['rdCount'];
    }

    /**
     * Sets rdCount.
     *
     * @param null|float $rdCount rdCount
     *
     * @return self
     */
    public function setRdCount($rdCount)
    {
        if (is_null($rdCount)) {
            array_push($this->openAPINullablesSetToNull, 'rdCount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rdCount', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rdCount'] = $rdCount;

        return $this;
    }

    /**
     * Gets rdAverage.
     *
     * @return null|float
     */
    public function getRdAverage()
    {
        return $this->container['rdAverage'];
    }

    /**
     * Sets rdAverage.
     *
     * @param null|float $rdAverage rdAverage
     *
     * @return self
     */
    public function setRdAverage($rdAverage)
    {
        if (is_null($rdAverage)) {
            array_push($this->openAPINullablesSetToNull, 'rdAverage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rdAverage', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rdAverage'] = $rdAverage;

        return $this;
    }

    /**
     * Gets rdShortest.
     *
     * @return null|float
     */
    public function getRdShortest()
    {
        return $this->container['rdShortest'];
    }

    /**
     * Sets rdShortest.
     *
     * @param null|float $rdShortest rdShortest
     *
     * @return self
     */
    public function setRdShortest($rdShortest)
    {
        if (is_null($rdShortest)) {
            array_push($this->openAPINullablesSetToNull, 'rdShortest');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rdShortest', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rdShortest'] = $rdShortest;

        return $this;
    }

    /**
     * Gets rdLongest.
     *
     * @return null|float
     */
    public function getRdLongest()
    {
        return $this->container['rdLongest'];
    }

    /**
     * Sets rdLongest.
     *
     * @param null|float $rdLongest rdLongest
     *
     * @return self
     */
    public function setRdLongest($rdLongest)
    {
        if (is_null($rdLongest)) {
            array_push($this->openAPINullablesSetToNull, 'rdLongest');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rdLongest', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rdLongest'] = $rdLongest;

        return $this;
    }

    /**
     * Gets duration.
     *
     * @return null|float
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration.
     *
     * @param null|float $duration duration
     *
     * @return self
     */
    public function setDuration($duration)
    {
        if (is_null($duration)) {
            array_push($this->openAPINullablesSetToNull, 'duration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('duration', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['duration'] = $duration;

        return $this;
    }

    /**
     * Gets fullDuration.
     *
     * @return null|float
     */
    public function getFullDuration()
    {
        return $this->container['fullDuration'];
    }

    /**
     * Sets fullDuration.
     *
     * @param null|float $fullDuration fullDuration
     *
     * @return self
     */
    public function setFullDuration($fullDuration)
    {
        if (is_null($fullDuration)) {
            array_push($this->openAPINullablesSetToNull, 'fullDuration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fullDuration', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fullDuration'] = $fullDuration;

        return $this;
    }

    /**
     * Gets skipUnchanged.
     *
     * @return null|bool
     */
    public function getSkipUnchanged()
    {
        return $this->container['skipUnchanged'];
    }

    /**
     * Sets skipUnchanged.
     *
     * @param null|bool $skipUnchanged skipUnchanged
     *
     * @return self
     */
    public function setSkipUnchanged($skipUnchanged)
    {
        if (is_null($skipUnchanged)) {
            array_push($this->openAPINullablesSetToNull, 'skipUnchanged');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipUnchanged', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipUnchanged'] = $skipUnchanged;

        return $this;
    }

    /**
     * Gets trace.
     *
     * @return null|bool
     */
    public function getTrace()
    {
        return $this->container['trace'];
    }

    /**
     * Sets trace.
     *
     * @param null|bool $trace trace
     *
     * @return self
     */
    public function setTrace($trace)
    {
        if (is_null($trace)) {
            array_push($this->openAPINullablesSetToNull, 'trace');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('trace', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['trace'] = $trace;

        return $this;
    }

    /**
     * Gets priority.
     *
     * @return null|float
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority.
     *
     * @param null|float $priority priority
     *
     * @return self
     */
    public function setPriority($priority)
    {
        if (is_null($priority)) {
            array_push($this->openAPINullablesSetToNull, 'priority');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('priority', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets projectLinkTargets.
     *
     * @return null|RuntimeSyndicationProjectLinkTarget[]
     */
    public function getProjectLinkTargets()
    {
        return $this->container['projectLinkTargets'];
    }

    /**
     * Sets projectLinkTargets.
     *
     * @param null|RuntimeSyndicationProjectLinkTarget[] $projectLinkTargets projectLinkTargets
     *
     * @return self
     */
    public function setProjectLinkTargets($projectLinkTargets)
    {
        if (is_null($projectLinkTargets)) {
            array_push($this->openAPINullablesSetToNull, 'projectLinkTargets');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('projectLinkTargets', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['projectLinkTargets'] = $projectLinkTargets;

        return $this;
    }

    /**
     * Gets dependsOnSyndication.
     *
     * @return null|DynamicReference
     */
    public function getDependsOnSyndication()
    {
        return $this->container['dependsOnSyndication'];
    }

    /**
     * Sets dependsOnSyndication.
     *
     * @param null|DynamicReference $dependsOnSyndication dependsOnSyndication
     *
     * @return self
     */
    public function setDependsOnSyndication($dependsOnSyndication)
    {
        if (is_null($dependsOnSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'dependsOnSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dependsOnSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dependsOnSyndication'] = $dependsOnSyndication;

        return $this;
    }

    /**
     * Gets runAfterSyndication.
     *
     * @return null|DynamicReference
     */
    public function getRunAfterSyndication()
    {
        return $this->container['runAfterSyndication'];
    }

    /**
     * Sets runAfterSyndication.
     *
     * @param null|DynamicReference $runAfterSyndication runAfterSyndication
     *
     * @return self
     */
    public function setRunAfterSyndication($runAfterSyndication)
    {
        if (is_null($runAfterSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'runAfterSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('runAfterSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['runAfterSyndication'] = $runAfterSyndication;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Gets originalType.
     *
     * @return null|SyndicationType
     */
    public function getOriginalType()
    {
        return $this->container['originalType'];
    }

    /**
     * Sets originalType.
     *
     * @param null|SyndicationType $originalType originalType
     *
     * @return self
     */
    public function setOriginalType($originalType)
    {
        if (is_null($originalType)) {
            array_push($this->openAPINullablesSetToNull, 'originalType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('originalType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['originalType'] = $originalType;

        return $this;
    }

    /**
     * Gets isClone.
     *
     * @return null|bool
     */
    public function getIsClone()
    {
        return $this->container['isClone'];
    }

    /**
     * Sets isClone.
     *
     * @param null|bool $isClone isClone
     *
     * @return self
     */
    public function setIsClone($isClone)
    {
        if (is_null($isClone)) {
            array_push($this->openAPINullablesSetToNull, 'isClone');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isClone', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['isClone'] = $isClone;

        return $this;
    }

    /**
     * Gets usage.
     *
     * @return null|RemoteEntityUsageEntity
     */
    public function getUsage()
    {
        return $this->container['usage'];
    }

    /**
     * Sets usage.
     *
     * @param null|RemoteEntityUsageEntity $usage usage
     *
     * @return self
     */
    public function setUsage($usage)
    {
        if (is_null($usage)) {
            array_push($this->openAPINullablesSetToNull, 'usage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('usage', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['usage'] = $usage;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
