<?php

/**
 * SyncCoreRemoteEntityUsageEntityReference.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SyncCoreRemoteEntityUsageEntityReference Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SyncCoreRemoteEntityUsageEntityReference implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SyncCoreRemoteEntityUsageEntityReference';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'entity' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'language' => 'string',
        'isTranslationRoot' => 'bool',
        'match' => 'EntityMatchType',
        'status' => 'EntityRemoteStatus',
        'versionId' => 'string',
        'versionIdWithTranslations' => 'string',
        'viewUrl' => 'string',
        'lastPush' => 'float',
        'lastPull' => 'float',
        'revisionId' => 'float',
        'isLatest' => 'bool',
        'updateStatus' => 'EntityRemoteUpdateStatus',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'entity' => null,
        'language' => null,
        'isTranslationRoot' => null,
        'match' => null,
        'status' => null,
        'versionId' => null,
        'versionIdWithTranslations' => null,
        'viewUrl' => null,
        'lastPush' => null,
        'lastPull' => null,
        'revisionId' => null,
        'isLatest' => null,
        'updateStatus' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'entity' => false,
        'language' => false,
        'isTranslationRoot' => false,
        'match' => true,
        'status' => false,
        'versionId' => true,
        'versionIdWithTranslations' => true,
        'viewUrl' => true,
        'lastPush' => true,
        'lastPull' => true,
        'revisionId' => true,
        'isLatest' => true,
        'updateStatus' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entity' => 'entity',
        'language' => 'language',
        'isTranslationRoot' => 'isTranslationRoot',
        'match' => 'match',
        'status' => 'status',
        'versionId' => 'versionId',
        'versionIdWithTranslations' => 'versionIdWithTranslations',
        'viewUrl' => 'viewUrl',
        'lastPush' => 'lastPush',
        'lastPull' => 'lastPull',
        'revisionId' => 'revisionId',
        'isLatest' => 'isLatest',
        'updateStatus' => 'updateStatus',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'entity' => 'setEntity',
        'language' => 'setLanguage',
        'isTranslationRoot' => 'setIsTranslationRoot',
        'match' => 'setMatch',
        'status' => 'setStatus',
        'versionId' => 'setVersionId',
        'versionIdWithTranslations' => 'setVersionIdWithTranslations',
        'viewUrl' => 'setViewUrl',
        'lastPush' => 'setLastPush',
        'lastPull' => 'setLastPull',
        'revisionId' => 'setRevisionId',
        'isLatest' => 'setIsLatest',
        'updateStatus' => 'setUpdateStatus',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'entity' => 'getEntity',
        'language' => 'getLanguage',
        'isTranslationRoot' => 'getIsTranslationRoot',
        'match' => 'getMatch',
        'status' => 'getStatus',
        'versionId' => 'getVersionId',
        'versionIdWithTranslations' => 'getVersionIdWithTranslations',
        'viewUrl' => 'getViewUrl',
        'lastPush' => 'getLastPush',
        'lastPull' => 'getLastPull',
        'revisionId' => 'getRevisionId',
        'isLatest' => 'getIsLatest',
        'updateStatus' => 'getUpdateStatus',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('isTranslationRoot', $data ?? [], null);
        $this->setIfExists('match', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('versionId', $data ?? [], null);
        $this->setIfExists('versionIdWithTranslations', $data ?? [], null);
        $this->setIfExists('viewUrl', $data ?? [], null);
        $this->setIfExists('lastPush', $data ?? [], null);
        $this->setIfExists('lastPull', $data ?? [], null);
        $this->setIfExists('revisionId', $data ?? [], null);
        $this->setIfExists('isLatest', $data ?? [], null);
        $this->setIfExists('updateStatus', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['entity']) {
            $invalidProperties[] = "'entity' can't be null";
        }
        if (null === $this->container['language']) {
            $invalidProperties[] = "'language' can't be null";
        }
        if (null === $this->container['isTranslationRoot']) {
            $invalidProperties[] = "'isTranslationRoot' can't be null";
        }
        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets entity.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets language.
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language.
     *
     * @param string $language language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets isTranslationRoot.
     *
     * @return bool
     */
    public function getIsTranslationRoot()
    {
        return $this->container['isTranslationRoot'];
    }

    /**
     * Sets isTranslationRoot.
     *
     * @param bool $isTranslationRoot isTranslationRoot
     *
     * @return self
     */
    public function setIsTranslationRoot($isTranslationRoot)
    {
        if (is_null($isTranslationRoot)) {
            throw new \InvalidArgumentException('non-nullable isTranslationRoot cannot be null');
        }
        $this->container['isTranslationRoot'] = $isTranslationRoot;

        return $this;
    }

    /**
     * Gets match.
     *
     * @return null|EntityMatchType
     */
    public function getMatch()
    {
        return $this->container['match'];
    }

    /**
     * Sets match.
     *
     * @param null|EntityMatchType $match match
     *
     * @return self
     */
    public function setMatch($match)
    {
        if (is_null($match)) {
            array_push($this->openAPINullablesSetToNull, 'match');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('match', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['match'] = $match;

        return $this;
    }

    /**
     * Gets status.
     *
     * @return EntityRemoteStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param EntityRemoteStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets versionId.
     *
     * @return null|string
     */
    public function getVersionId()
    {
        return $this->container['versionId'];
    }

    /**
     * Sets versionId.
     *
     * @param null|string $versionId versionId
     *
     * @return self
     */
    public function setVersionId($versionId)
    {
        if (is_null($versionId)) {
            array_push($this->openAPINullablesSetToNull, 'versionId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('versionId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['versionId'] = $versionId;

        return $this;
    }

    /**
     * Gets versionIdWithTranslations.
     *
     * @return null|string
     */
    public function getVersionIdWithTranslations()
    {
        return $this->container['versionIdWithTranslations'];
    }

    /**
     * Sets versionIdWithTranslations.
     *
     * @param null|string $versionIdWithTranslations versionIdWithTranslations
     *
     * @return self
     */
    public function setVersionIdWithTranslations($versionIdWithTranslations)
    {
        if (is_null($versionIdWithTranslations)) {
            array_push($this->openAPINullablesSetToNull, 'versionIdWithTranslations');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('versionIdWithTranslations', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['versionIdWithTranslations'] = $versionIdWithTranslations;

        return $this;
    }

    /**
     * Gets viewUrl.
     *
     * @return null|string
     */
    public function getViewUrl()
    {
        return $this->container['viewUrl'];
    }

    /**
     * Sets viewUrl.
     *
     * @param null|string $viewUrl viewUrl
     *
     * @return self
     */
    public function setViewUrl($viewUrl)
    {
        if (is_null($viewUrl)) {
            array_push($this->openAPINullablesSetToNull, 'viewUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('viewUrl', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['viewUrl'] = $viewUrl;

        return $this;
    }

    /**
     * Gets lastPush.
     *
     * @return null|float
     */
    public function getLastPush()
    {
        return $this->container['lastPush'];
    }

    /**
     * Sets lastPush.
     *
     * @param null|float $lastPush lastPush
     *
     * @return self
     */
    public function setLastPush($lastPush)
    {
        if (is_null($lastPush)) {
            array_push($this->openAPINullablesSetToNull, 'lastPush');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lastPush', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lastPush'] = $lastPush;

        return $this;
    }

    /**
     * Gets lastPull.
     *
     * @return null|float
     */
    public function getLastPull()
    {
        return $this->container['lastPull'];
    }

    /**
     * Sets lastPull.
     *
     * @param null|float $lastPull lastPull
     *
     * @return self
     */
    public function setLastPull($lastPull)
    {
        if (is_null($lastPull)) {
            array_push($this->openAPINullablesSetToNull, 'lastPull');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lastPull', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lastPull'] = $lastPull;

        return $this;
    }

    /**
     * Gets revisionId.
     *
     * @return null|float
     */
    public function getRevisionId()
    {
        return $this->container['revisionId'];
    }

    /**
     * Sets revisionId.
     *
     * @param null|float $revisionId revisionId
     *
     * @return self
     */
    public function setRevisionId($revisionId)
    {
        if (is_null($revisionId)) {
            array_push($this->openAPINullablesSetToNull, 'revisionId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('revisionId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['revisionId'] = $revisionId;

        return $this;
    }

    /**
     * Gets isLatest.
     *
     * @return null|bool
     */
    public function getIsLatest()
    {
        return $this->container['isLatest'];
    }

    /**
     * Sets isLatest.
     *
     * @param null|bool $isLatest isLatest
     *
     * @return self
     */
    public function setIsLatest($isLatest)
    {
        if (is_null($isLatest)) {
            array_push($this->openAPINullablesSetToNull, 'isLatest');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('isLatest', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['isLatest'] = $isLatest;

        return $this;
    }

    /**
     * Gets updateStatus.
     *
     * @return null|EntityRemoteUpdateStatus
     */
    public function getUpdateStatus()
    {
        return $this->container['updateStatus'];
    }

    /**
     * Sets updateStatus.
     *
     * @param null|EntityRemoteUpdateStatus $updateStatus updateStatus
     *
     * @return self
     */
    public function setUpdateStatus($updateStatus)
    {
        if (is_null($updateStatus)) {
            array_push($this->openAPINullablesSetToNull, 'updateStatus');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('updateStatus', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['updateStatus'] = $updateStatus;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
