<?php

/**
 * SiteStatusResponse.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SiteStatusResponse Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SiteStatusResponse implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SiteStatusResponse';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'name' => 'string',
        'baseUrl' => 'string',
        'uuid' => 'string',
        'appVersion' => 'string',
        'appModuleVersion' => 'string',
        'featureFlags' => 'mixed',
        'extensions' => '\EdgeBox\SyncCore\V2\Raw\Model\SiteExtension[]',
        'domains' => 'string[]',
        'requirements' => 'mixed',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'name' => null,
        'baseUrl' => null,
        'uuid' => null,
        'appVersion' => null,
        'appModuleVersion' => null,
        'featureFlags' => null,
        'extensions' => null,
        'domains' => null,
        'requirements' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'name' => false,
        'baseUrl' => false,
        'uuid' => true,
        'appVersion' => false,
        'appModuleVersion' => false,
        'featureFlags' => true,
        'extensions' => true,
        'domains' => true,
        'requirements' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'baseUrl' => 'baseUrl',
        'uuid' => 'uuid',
        'appVersion' => 'appVersion',
        'appModuleVersion' => 'appModuleVersion',
        'featureFlags' => 'featureFlags',
        'extensions' => 'extensions',
        'domains' => 'domains',
        'requirements' => 'requirements',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'baseUrl' => 'setBaseUrl',
        'uuid' => 'setUuid',
        'appVersion' => 'setAppVersion',
        'appModuleVersion' => 'setAppModuleVersion',
        'featureFlags' => 'setFeatureFlags',
        'extensions' => 'setExtensions',
        'domains' => 'setDomains',
        'requirements' => 'setRequirements',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'baseUrl' => 'getBaseUrl',
        'uuid' => 'getUuid',
        'appVersion' => 'getAppVersion',
        'appModuleVersion' => 'getAppModuleVersion',
        'featureFlags' => 'getFeatureFlags',
        'extensions' => 'getExtensions',
        'domains' => 'getDomains',
        'requirements' => 'getRequirements',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('baseUrl', $data ?? [], null);
        $this->setIfExists('uuid', $data ?? [], null);
        $this->setIfExists('appVersion', $data ?? [], null);
        $this->setIfExists('appModuleVersion', $data ?? [], null);
        $this->setIfExists('featureFlags', $data ?? [], null);
        $this->setIfExists('extensions', $data ?? [], null);
        $this->setIfExists('domains', $data ?? [], null);
        $this->setIfExists('requirements', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['name']) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (null === $this->container['baseUrl']) {
            $invalidProperties[] = "'baseUrl' can't be null";
        }
        if (null === $this->container['appVersion']) {
            $invalidProperties[] = "'appVersion' can't be null";
        }
        if (null === $this->container['appModuleVersion']) {
            $invalidProperties[] = "'appModuleVersion' can't be null";
        }
        if (null === $this->container['featureFlags']) {
            $invalidProperties[] = "'featureFlags' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name.
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets baseUrl.
     *
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->container['baseUrl'];
    }

    /**
     * Sets baseUrl.
     *
     * @param string $baseUrl baseUrl
     *
     * @return self
     */
    public function setBaseUrl($baseUrl)
    {
        if (is_null($baseUrl)) {
            throw new \InvalidArgumentException('non-nullable baseUrl cannot be null');
        }
        $this->container['baseUrl'] = $baseUrl;

        return $this;
    }

    /**
     * Gets uuid.
     *
     * @return null|string
     */
    public function getUuid()
    {
        return $this->container['uuid'];
    }

    /**
     * Sets uuid.
     *
     * @param null|string $uuid uuid
     *
     * @return self
     */
    public function setUuid($uuid)
    {
        if (is_null($uuid)) {
            array_push($this->openAPINullablesSetToNull, 'uuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('uuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['uuid'] = $uuid;

        return $this;
    }

    /**
     * Gets appVersion.
     *
     * @return string
     */
    public function getAppVersion()
    {
        return $this->container['appVersion'];
    }

    /**
     * Sets appVersion.
     *
     * @param string $appVersion appVersion
     *
     * @return self
     */
    public function setAppVersion($appVersion)
    {
        if (is_null($appVersion)) {
            throw new \InvalidArgumentException('non-nullable appVersion cannot be null');
        }
        $this->container['appVersion'] = $appVersion;

        return $this;
    }

    /**
     * Gets appModuleVersion.
     *
     * @return string
     */
    public function getAppModuleVersion()
    {
        return $this->container['appModuleVersion'];
    }

    /**
     * Sets appModuleVersion.
     *
     * @param string $appModuleVersion appModuleVersion
     *
     * @return self
     */
    public function setAppModuleVersion($appModuleVersion)
    {
        if (is_null($appModuleVersion)) {
            throw new \InvalidArgumentException('non-nullable appModuleVersion cannot be null');
        }
        $this->container['appModuleVersion'] = $appModuleVersion;

        return $this;
    }

    /**
     * Gets featureFlags.
     *
     * @return mixed
     */
    public function getFeatureFlags()
    {
        return $this->container['featureFlags'];
    }

    /**
     * Sets featureFlags.
     *
     * @param mixed $featureFlags featureFlags
     *
     * @return self
     */
    public function setFeatureFlags($featureFlags)
    {
        if (is_null($featureFlags)) {
            array_push($this->openAPINullablesSetToNull, 'featureFlags');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('featureFlags', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['featureFlags'] = $featureFlags;

        return $this;
    }

    /**
     * Gets extensions.
     *
     * @return null|SiteExtension[]
     */
    public function getExtensions()
    {
        return $this->container['extensions'];
    }

    /**
     * Sets extensions.
     *
     * @param null|SiteExtension[] $extensions extensions
     *
     * @return self
     */
    public function setExtensions($extensions)
    {
        if (is_null($extensions)) {
            array_push($this->openAPINullablesSetToNull, 'extensions');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('extensions', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['extensions'] = $extensions;

        return $this;
    }

    /**
     * Gets domains.
     *
     * @return null|string[]
     */
    public function getDomains()
    {
        return $this->container['domains'];
    }

    /**
     * Sets domains.
     *
     * @param null|string[] $domains domains
     *
     * @return self
     */
    public function setDomains($domains)
    {
        if (is_null($domains)) {
            array_push($this->openAPINullablesSetToNull, 'domains');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('domains', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['domains'] = $domains;

        return $this;
    }

    /**
     * Gets requirements.
     *
     * @return null|mixed
     */
    public function getRequirements()
    {
        return $this->container['requirements'];
    }

    /**
     * Sets requirements.
     *
     * @param null|mixed $requirements requirements
     *
     * @return self
     */
    public function setRequirements($requirements)
    {
        if (is_null($requirements)) {
            array_push($this->openAPINullablesSetToNull, 'requirements');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requirements', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requirements'] = $requirements;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
