<?php

/**
 * SiteRequestDetails.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SiteRequestDetails Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SiteRequestDetails implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SiteRequestDetails';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'requestUrl' => 'string',
        'requestBody' => 'string',
        'requestHeaders' => 'mixed',
        'requestMethod' => 'string',
        'requestRedirects' => 'string',
        'requestMaxFollow' => 'float',
        'requestMaxSize' => 'float',
        'requestTimeout' => 'float',
        'requestStart' => 'float',
        'requestEnd' => 'float',
        'responseBody' => 'string',
        'responseHeaders' => 'mixed',
        'responseStatusCode' => 'float',
        'responseStatusText' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'requestUrl' => null,
        'requestBody' => null,
        'requestHeaders' => null,
        'requestMethod' => null,
        'requestRedirects' => null,
        'requestMaxFollow' => null,
        'requestMaxSize' => null,
        'requestTimeout' => null,
        'requestStart' => null,
        'requestEnd' => null,
        'responseBody' => null,
        'responseHeaders' => null,
        'responseStatusCode' => null,
        'responseStatusText' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'requestUrl' => true,
        'requestBody' => true,
        'requestHeaders' => true,
        'requestMethod' => true,
        'requestRedirects' => true,
        'requestMaxFollow' => true,
        'requestMaxSize' => true,
        'requestTimeout' => true,
        'requestStart' => true,
        'requestEnd' => true,
        'responseBody' => true,
        'responseHeaders' => true,
        'responseStatusCode' => true,
        'responseStatusText' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'requestUrl' => 'requestUrl',
        'requestBody' => 'requestBody',
        'requestHeaders' => 'requestHeaders',
        'requestMethod' => 'requestMethod',
        'requestRedirects' => 'requestRedirects',
        'requestMaxFollow' => 'requestMaxFollow',
        'requestMaxSize' => 'requestMaxSize',
        'requestTimeout' => 'requestTimeout',
        'requestStart' => 'requestStart',
        'requestEnd' => 'requestEnd',
        'responseBody' => 'responseBody',
        'responseHeaders' => 'responseHeaders',
        'responseStatusCode' => 'responseStatusCode',
        'responseStatusText' => 'responseStatusText',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'requestUrl' => 'setRequestUrl',
        'requestBody' => 'setRequestBody',
        'requestHeaders' => 'setRequestHeaders',
        'requestMethod' => 'setRequestMethod',
        'requestRedirects' => 'setRequestRedirects',
        'requestMaxFollow' => 'setRequestMaxFollow',
        'requestMaxSize' => 'setRequestMaxSize',
        'requestTimeout' => 'setRequestTimeout',
        'requestStart' => 'setRequestStart',
        'requestEnd' => 'setRequestEnd',
        'responseBody' => 'setResponseBody',
        'responseHeaders' => 'setResponseHeaders',
        'responseStatusCode' => 'setResponseStatusCode',
        'responseStatusText' => 'setResponseStatusText',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'requestUrl' => 'getRequestUrl',
        'requestBody' => 'getRequestBody',
        'requestHeaders' => 'getRequestHeaders',
        'requestMethod' => 'getRequestMethod',
        'requestRedirects' => 'getRequestRedirects',
        'requestMaxFollow' => 'getRequestMaxFollow',
        'requestMaxSize' => 'getRequestMaxSize',
        'requestTimeout' => 'getRequestTimeout',
        'requestStart' => 'getRequestStart',
        'requestEnd' => 'getRequestEnd',
        'responseBody' => 'getResponseBody',
        'responseHeaders' => 'getResponseHeaders',
        'responseStatusCode' => 'getResponseStatusCode',
        'responseStatusText' => 'getResponseStatusText',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('requestUrl', $data ?? [], null);
        $this->setIfExists('requestBody', $data ?? [], null);
        $this->setIfExists('requestHeaders', $data ?? [], null);
        $this->setIfExists('requestMethod', $data ?? [], null);
        $this->setIfExists('requestRedirects', $data ?? [], null);
        $this->setIfExists('requestMaxFollow', $data ?? [], null);
        $this->setIfExists('requestMaxSize', $data ?? [], null);
        $this->setIfExists('requestTimeout', $data ?? [], null);
        $this->setIfExists('requestStart', $data ?? [], null);
        $this->setIfExists('requestEnd', $data ?? [], null);
        $this->setIfExists('responseBody', $data ?? [], null);
        $this->setIfExists('responseHeaders', $data ?? [], null);
        $this->setIfExists('responseStatusCode', $data ?? [], null);
        $this->setIfExists('responseStatusText', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets requestUrl.
     *
     * @return null|string
     */
    public function getRequestUrl()
    {
        return $this->container['requestUrl'];
    }

    /**
     * Sets requestUrl.
     *
     * @param null|string $requestUrl requestUrl
     *
     * @return self
     */
    public function setRequestUrl($requestUrl)
    {
        if (is_null($requestUrl)) {
            array_push($this->openAPINullablesSetToNull, 'requestUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestUrl', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestUrl'] = $requestUrl;

        return $this;
    }

    /**
     * Gets requestBody.
     *
     * @return null|string
     */
    public function getRequestBody()
    {
        return $this->container['requestBody'];
    }

    /**
     * Sets requestBody.
     *
     * @param null|string $requestBody requestBody
     *
     * @return self
     */
    public function setRequestBody($requestBody)
    {
        if (is_null($requestBody)) {
            array_push($this->openAPINullablesSetToNull, 'requestBody');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestBody', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestBody'] = $requestBody;

        return $this;
    }

    /**
     * Gets requestHeaders.
     *
     * @return null|mixed
     */
    public function getRequestHeaders()
    {
        return $this->container['requestHeaders'];
    }

    /**
     * Sets requestHeaders.
     *
     * @param null|mixed $requestHeaders requestHeaders
     *
     * @return self
     */
    public function setRequestHeaders($requestHeaders)
    {
        if (is_null($requestHeaders)) {
            array_push($this->openAPINullablesSetToNull, 'requestHeaders');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestHeaders', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestHeaders'] = $requestHeaders;

        return $this;
    }

    /**
     * Gets requestMethod.
     *
     * @return null|string
     */
    public function getRequestMethod()
    {
        return $this->container['requestMethod'];
    }

    /**
     * Sets requestMethod.
     *
     * @param null|string $requestMethod requestMethod
     *
     * @return self
     */
    public function setRequestMethod($requestMethod)
    {
        if (is_null($requestMethod)) {
            array_push($this->openAPINullablesSetToNull, 'requestMethod');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestMethod', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestMethod'] = $requestMethod;

        return $this;
    }

    /**
     * Gets requestRedirects.
     *
     * @return null|string
     */
    public function getRequestRedirects()
    {
        return $this->container['requestRedirects'];
    }

    /**
     * Sets requestRedirects.
     *
     * @param null|string $requestRedirects requestRedirects
     *
     * @return self
     */
    public function setRequestRedirects($requestRedirects)
    {
        if (is_null($requestRedirects)) {
            array_push($this->openAPINullablesSetToNull, 'requestRedirects');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestRedirects', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestRedirects'] = $requestRedirects;

        return $this;
    }

    /**
     * Gets requestMaxFollow.
     *
     * @return null|float
     */
    public function getRequestMaxFollow()
    {
        return $this->container['requestMaxFollow'];
    }

    /**
     * Sets requestMaxFollow.
     *
     * @param null|float $requestMaxFollow requestMaxFollow
     *
     * @return self
     */
    public function setRequestMaxFollow($requestMaxFollow)
    {
        if (is_null($requestMaxFollow)) {
            array_push($this->openAPINullablesSetToNull, 'requestMaxFollow');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestMaxFollow', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestMaxFollow'] = $requestMaxFollow;

        return $this;
    }

    /**
     * Gets requestMaxSize.
     *
     * @return null|float
     */
    public function getRequestMaxSize()
    {
        return $this->container['requestMaxSize'];
    }

    /**
     * Sets requestMaxSize.
     *
     * @param null|float $requestMaxSize requestMaxSize
     *
     * @return self
     */
    public function setRequestMaxSize($requestMaxSize)
    {
        if (is_null($requestMaxSize)) {
            array_push($this->openAPINullablesSetToNull, 'requestMaxSize');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestMaxSize', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestMaxSize'] = $requestMaxSize;

        return $this;
    }

    /**
     * Gets requestTimeout.
     *
     * @return null|float
     */
    public function getRequestTimeout()
    {
        return $this->container['requestTimeout'];
    }

    /**
     * Sets requestTimeout.
     *
     * @param null|float $requestTimeout requestTimeout
     *
     * @return self
     */
    public function setRequestTimeout($requestTimeout)
    {
        if (is_null($requestTimeout)) {
            array_push($this->openAPINullablesSetToNull, 'requestTimeout');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestTimeout', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestTimeout'] = $requestTimeout;

        return $this;
    }

    /**
     * Gets requestStart.
     *
     * @return null|float
     */
    public function getRequestStart()
    {
        return $this->container['requestStart'];
    }

    /**
     * Sets requestStart.
     *
     * @param null|float $requestStart requestStart
     *
     * @return self
     */
    public function setRequestStart($requestStart)
    {
        if (is_null($requestStart)) {
            array_push($this->openAPINullablesSetToNull, 'requestStart');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestStart', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestStart'] = $requestStart;

        return $this;
    }

    /**
     * Gets requestEnd.
     *
     * @return null|float
     */
    public function getRequestEnd()
    {
        return $this->container['requestEnd'];
    }

    /**
     * Sets requestEnd.
     *
     * @param null|float $requestEnd requestEnd
     *
     * @return self
     */
    public function setRequestEnd($requestEnd)
    {
        if (is_null($requestEnd)) {
            array_push($this->openAPINullablesSetToNull, 'requestEnd');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestEnd', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestEnd'] = $requestEnd;

        return $this;
    }

    /**
     * Gets responseBody.
     *
     * @return null|string
     */
    public function getResponseBody()
    {
        return $this->container['responseBody'];
    }

    /**
     * Sets responseBody.
     *
     * @param null|string $responseBody responseBody
     *
     * @return self
     */
    public function setResponseBody($responseBody)
    {
        if (is_null($responseBody)) {
            array_push($this->openAPINullablesSetToNull, 'responseBody');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('responseBody', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['responseBody'] = $responseBody;

        return $this;
    }

    /**
     * Gets responseHeaders.
     *
     * @return null|mixed
     */
    public function getResponseHeaders()
    {
        return $this->container['responseHeaders'];
    }

    /**
     * Sets responseHeaders.
     *
     * @param null|mixed $responseHeaders responseHeaders
     *
     * @return self
     */
    public function setResponseHeaders($responseHeaders)
    {
        if (is_null($responseHeaders)) {
            array_push($this->openAPINullablesSetToNull, 'responseHeaders');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('responseHeaders', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['responseHeaders'] = $responseHeaders;

        return $this;
    }

    /**
     * Gets responseStatusCode.
     *
     * @return null|float
     */
    public function getResponseStatusCode()
    {
        return $this->container['responseStatusCode'];
    }

    /**
     * Sets responseStatusCode.
     *
     * @param null|float $responseStatusCode responseStatusCode
     *
     * @return self
     */
    public function setResponseStatusCode($responseStatusCode)
    {
        if (is_null($responseStatusCode)) {
            array_push($this->openAPINullablesSetToNull, 'responseStatusCode');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('responseStatusCode', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['responseStatusCode'] = $responseStatusCode;

        return $this;
    }

    /**
     * Gets responseStatusText.
     *
     * @return null|string
     */
    public function getResponseStatusText()
    {
        return $this->container['responseStatusText'];
    }

    /**
     * Sets responseStatusText.
     *
     * @param null|string $responseStatusText responseStatusText
     *
     * @return self
     */
    public function setResponseStatusText($responseStatusText)
    {
        if (is_null($responseStatusText)) {
            array_push($this->openAPINullablesSetToNull, 'responseStatusText');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('responseStatusText', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['responseStatusText'] = $responseStatusText;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
