<?php

/**
 * SiteConfigResponse.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * SiteConfigResponse Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class SiteConfigResponse implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'SiteConfigResponse';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'poolCount' => 'float',
        'pools' => '\EdgeBox\SyncCore\V2\Raw\Model\CreatePoolDto[]',
        'flowCount' => 'float',
        'flows' => '\EdgeBox\SyncCore\V2\Raw\Model\CreateFlowDto[]',
        'entityTypeCount' => 'float',
        'entityTypes' => '\EdgeBox\SyncCore\V2\Raw\Model\CreateRemoteEntityTypeVersionDto[]',
        'languageCount' => 'float',
        'languages' => '\EdgeBox\SyncCore\V2\Raw\Model\LanguageDefinition[]',
        'defaultLanguageCode' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'poolCount' => null,
        'pools' => null,
        'flowCount' => null,
        'flows' => null,
        'entityTypeCount' => null,
        'entityTypes' => null,
        'languageCount' => null,
        'languages' => null,
        'defaultLanguageCode' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'poolCount' => true,
        'pools' => true,
        'flowCount' => true,
        'flows' => true,
        'entityTypeCount' => true,
        'entityTypes' => true,
        'languageCount' => true,
        'languages' => true,
        'defaultLanguageCode' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'poolCount' => 'poolCount',
        'pools' => 'pools',
        'flowCount' => 'flowCount',
        'flows' => 'flows',
        'entityTypeCount' => 'entityTypeCount',
        'entityTypes' => 'entityTypes',
        'languageCount' => 'languageCount',
        'languages' => 'languages',
        'defaultLanguageCode' => 'defaultLanguageCode',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'poolCount' => 'setPoolCount',
        'pools' => 'setPools',
        'flowCount' => 'setFlowCount',
        'flows' => 'setFlows',
        'entityTypeCount' => 'setEntityTypeCount',
        'entityTypes' => 'setEntityTypes',
        'languageCount' => 'setLanguageCount',
        'languages' => 'setLanguages',
        'defaultLanguageCode' => 'setDefaultLanguageCode',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'poolCount' => 'getPoolCount',
        'pools' => 'getPools',
        'flowCount' => 'getFlowCount',
        'flows' => 'getFlows',
        'entityTypeCount' => 'getEntityTypeCount',
        'entityTypes' => 'getEntityTypes',
        'languageCount' => 'getLanguageCount',
        'languages' => 'getLanguages',
        'defaultLanguageCode' => 'getDefaultLanguageCode',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('poolCount', $data ?? [], null);
        $this->setIfExists('pools', $data ?? [], null);
        $this->setIfExists('flowCount', $data ?? [], null);
        $this->setIfExists('flows', $data ?? [], null);
        $this->setIfExists('entityTypeCount', $data ?? [], null);
        $this->setIfExists('entityTypes', $data ?? [], null);
        $this->setIfExists('languageCount', $data ?? [], null);
        $this->setIfExists('languages', $data ?? [], null);
        $this->setIfExists('defaultLanguageCode', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets poolCount.
     *
     * @return null|float
     */
    public function getPoolCount()
    {
        return $this->container['poolCount'];
    }

    /**
     * Sets poolCount.
     *
     * @param null|float $poolCount poolCount
     *
     * @return self
     */
    public function setPoolCount($poolCount)
    {
        if (is_null($poolCount)) {
            array_push($this->openAPINullablesSetToNull, 'poolCount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('poolCount', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['poolCount'] = $poolCount;

        return $this;
    }

    /**
     * Gets pools.
     *
     * @return null|CreatePoolDto[]
     */
    public function getPools()
    {
        return $this->container['pools'];
    }

    /**
     * Sets pools.
     *
     * @param null|CreatePoolDto[] $pools pools
     *
     * @return self
     */
    public function setPools($pools)
    {
        if (is_null($pools)) {
            array_push($this->openAPINullablesSetToNull, 'pools');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pools', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pools'] = $pools;

        return $this;
    }

    /**
     * Gets flowCount.
     *
     * @return null|float
     */
    public function getFlowCount()
    {
        return $this->container['flowCount'];
    }

    /**
     * Sets flowCount.
     *
     * @param null|float $flowCount flowCount
     *
     * @return self
     */
    public function setFlowCount($flowCount)
    {
        if (is_null($flowCount)) {
            array_push($this->openAPINullablesSetToNull, 'flowCount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flowCount', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flowCount'] = $flowCount;

        return $this;
    }

    /**
     * Gets flows.
     *
     * @return null|CreateFlowDto[]
     */
    public function getFlows()
    {
        return $this->container['flows'];
    }

    /**
     * Sets flows.
     *
     * @param null|CreateFlowDto[] $flows flows
     *
     * @return self
     */
    public function setFlows($flows)
    {
        if (is_null($flows)) {
            array_push($this->openAPINullablesSetToNull, 'flows');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flows', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flows'] = $flows;

        return $this;
    }

    /**
     * Gets entityTypeCount.
     *
     * @return null|float
     */
    public function getEntityTypeCount()
    {
        return $this->container['entityTypeCount'];
    }

    /**
     * Sets entityTypeCount.
     *
     * @param null|float $entityTypeCount entityTypeCount
     *
     * @return self
     */
    public function setEntityTypeCount($entityTypeCount)
    {
        if (is_null($entityTypeCount)) {
            array_push($this->openAPINullablesSetToNull, 'entityTypeCount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityTypeCount', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityTypeCount'] = $entityTypeCount;

        return $this;
    }

    /**
     * Gets entityTypes.
     *
     * @return null|CreateRemoteEntityTypeVersionDto[]
     */
    public function getEntityTypes()
    {
        return $this->container['entityTypes'];
    }

    /**
     * Sets entityTypes.
     *
     * @param null|CreateRemoteEntityTypeVersionDto[] $entityTypes entityTypes
     *
     * @return self
     */
    public function setEntityTypes($entityTypes)
    {
        if (is_null($entityTypes)) {
            array_push($this->openAPINullablesSetToNull, 'entityTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityTypes'] = $entityTypes;

        return $this;
    }

    /**
     * Gets languageCount.
     *
     * @return null|float
     */
    public function getLanguageCount()
    {
        return $this->container['languageCount'];
    }

    /**
     * Sets languageCount.
     *
     * @param null|float $languageCount languageCount
     *
     * @return self
     */
    public function setLanguageCount($languageCount)
    {
        if (is_null($languageCount)) {
            array_push($this->openAPINullablesSetToNull, 'languageCount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('languageCount', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['languageCount'] = $languageCount;

        return $this;
    }

    /**
     * Gets languages.
     *
     * @return null|LanguageDefinition[]
     */
    public function getLanguages()
    {
        return $this->container['languages'];
    }

    /**
     * Sets languages.
     *
     * @param null|LanguageDefinition[] $languages languages
     *
     * @return self
     */
    public function setLanguages($languages)
    {
        if (is_null($languages)) {
            array_push($this->openAPINullablesSetToNull, 'languages');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('languages', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['languages'] = $languages;

        return $this;
    }

    /**
     * Gets defaultLanguageCode.
     *
     * @return null|string
     */
    public function getDefaultLanguageCode()
    {
        return $this->container['defaultLanguageCode'];
    }

    /**
     * Sets defaultLanguageCode.
     *
     * @param null|string $defaultLanguageCode defaultLanguageCode
     *
     * @return self
     */
    public function setDefaultLanguageCode($defaultLanguageCode)
    {
        if (is_null($defaultLanguageCode)) {
            array_push($this->openAPINullablesSetToNull, 'defaultLanguageCode');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('defaultLanguageCode', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['defaultLanguageCode'] = $defaultLanguageCode;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
