<?php

/**
 * RemoteRequestQueryParamsEntityList.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * RemoteRequestQueryParamsEntityList Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class RemoteRequestQueryParamsEntityList implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'RemoteRequestQueryParamsEntityList';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'page' => 'float',
        'itemsPerPage' => 'float',
        'mode' => 'RemoteEntityListRequestMode',
        'changedAfter' => 'float',
        'namespaceMachineName' => 'string',
        'machineName' => 'string',
        'versionId' => 'string',
        'force2xx' => 'string',
        'trace' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'page' => null,
        'itemsPerPage' => null,
        'mode' => null,
        'changedAfter' => null,
        'namespaceMachineName' => null,
        'machineName' => null,
        'versionId' => null,
        'force2xx' => null,
        'trace' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'page' => true,
        'itemsPerPage' => true,
        'mode' => false,
        'changedAfter' => true,
        'namespaceMachineName' => true,
        'machineName' => true,
        'versionId' => true,
        'force2xx' => true,
        'trace' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'page' => 'page',
        'itemsPerPage' => 'itemsPerPage',
        'mode' => 'mode',
        'changedAfter' => 'changedAfter',
        'namespaceMachineName' => 'namespaceMachineName',
        'machineName' => 'machineName',
        'versionId' => 'versionId',
        'force2xx' => 'force2xx',
        'trace' => 'trace',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'page' => 'setPage',
        'itemsPerPage' => 'setItemsPerPage',
        'mode' => 'setMode',
        'changedAfter' => 'setChangedAfter',
        'namespaceMachineName' => 'setNamespaceMachineName',
        'machineName' => 'setMachineName',
        'versionId' => 'setVersionId',
        'force2xx' => 'setForce2xx',
        'trace' => 'setTrace',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'page' => 'getPage',
        'itemsPerPage' => 'getItemsPerPage',
        'mode' => 'getMode',
        'changedAfter' => 'getChangedAfter',
        'namespaceMachineName' => 'getNamespaceMachineName',
        'machineName' => 'getMachineName',
        'versionId' => 'getVersionId',
        'force2xx' => 'getForce2xx',
        'trace' => 'getTrace',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('page', $data ?? [], null);
        $this->setIfExists('itemsPerPage', $data ?? [], null);
        $this->setIfExists('mode', $data ?? [], null);
        $this->setIfExists('changedAfter', $data ?? [], null);
        $this->setIfExists('namespaceMachineName', $data ?? [], null);
        $this->setIfExists('machineName', $data ?? [], null);
        $this->setIfExists('versionId', $data ?? [], null);
        $this->setIfExists('force2xx', $data ?? [], null);
        $this->setIfExists('trace', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['mode']) {
            $invalidProperties[] = "'mode' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets page.
     *
     * @return null|float
     */
    public function getPage()
    {
        return $this->container['page'];
    }

    /**
     * Sets page.
     *
     * @param null|float $page page
     *
     * @return self
     */
    public function setPage($page)
    {
        if (is_null($page)) {
            array_push($this->openAPINullablesSetToNull, 'page');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('page', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['page'] = $page;

        return $this;
    }

    /**
     * Gets itemsPerPage.
     *
     * @return null|float
     */
    public function getItemsPerPage()
    {
        return $this->container['itemsPerPage'];
    }

    /**
     * Sets itemsPerPage.
     *
     * @param null|float $itemsPerPage itemsPerPage
     *
     * @return self
     */
    public function setItemsPerPage($itemsPerPage)
    {
        if (is_null($itemsPerPage)) {
            array_push($this->openAPINullablesSetToNull, 'itemsPerPage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('itemsPerPage', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['itemsPerPage'] = $itemsPerPage;

        return $this;
    }

    /**
     * Gets mode.
     *
     * @return RemoteEntityListRequestMode
     */
    public function getMode()
    {
        return $this->container['mode'];
    }

    /**
     * Sets mode.
     *
     * @param RemoteEntityListRequestMode $mode mode
     *
     * @return self
     */
    public function setMode($mode)
    {
        if (is_null($mode)) {
            throw new \InvalidArgumentException('non-nullable mode cannot be null');
        }
        $this->container['mode'] = $mode;

        return $this;
    }

    /**
     * Gets changedAfter.
     *
     * @return null|float
     */
    public function getChangedAfter()
    {
        return $this->container['changedAfter'];
    }

    /**
     * Sets changedAfter.
     *
     * @param null|float $changedAfter changedAfter
     *
     * @return self
     */
    public function setChangedAfter($changedAfter)
    {
        if (is_null($changedAfter)) {
            array_push($this->openAPINullablesSetToNull, 'changedAfter');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('changedAfter', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['changedAfter'] = $changedAfter;

        return $this;
    }

    /**
     * Gets namespaceMachineName.
     *
     * @return null|string
     */
    public function getNamespaceMachineName()
    {
        return $this->container['namespaceMachineName'];
    }

    /**
     * Sets namespaceMachineName.
     *
     * @param null|string $namespaceMachineName namespaceMachineName
     *
     * @return self
     */
    public function setNamespaceMachineName($namespaceMachineName)
    {
        if (is_null($namespaceMachineName)) {
            array_push($this->openAPINullablesSetToNull, 'namespaceMachineName');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('namespaceMachineName', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['namespaceMachineName'] = $namespaceMachineName;

        return $this;
    }

    /**
     * Gets machineName.
     *
     * @return null|string
     */
    public function getMachineName()
    {
        return $this->container['machineName'];
    }

    /**
     * Sets machineName.
     *
     * @param null|string $machineName machineName
     *
     * @return self
     */
    public function setMachineName($machineName)
    {
        if (is_null($machineName)) {
            array_push($this->openAPINullablesSetToNull, 'machineName');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('machineName', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['machineName'] = $machineName;

        return $this;
    }

    /**
     * Gets versionId.
     *
     * @return null|string
     */
    public function getVersionId()
    {
        return $this->container['versionId'];
    }

    /**
     * Sets versionId.
     *
     * @param null|string $versionId versionId
     *
     * @return self
     */
    public function setVersionId($versionId)
    {
        if (is_null($versionId)) {
            array_push($this->openAPINullablesSetToNull, 'versionId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('versionId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['versionId'] = $versionId;

        return $this;
    }

    /**
     * Gets force2xx.
     *
     * @return null|string
     */
    public function getForce2xx()
    {
        return $this->container['force2xx'];
    }

    /**
     * Sets force2xx.
     *
     * @param null|string $force2xx force2xx
     *
     * @return self
     */
    public function setForce2xx($force2xx)
    {
        if (is_null($force2xx)) {
            array_push($this->openAPINullablesSetToNull, 'force2xx');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('force2xx', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['force2xx'] = $force2xx;

        return $this;
    }

    /**
     * Gets trace.
     *
     * @return null|string
     */
    public function getTrace()
    {
        return $this->container['trace'];
    }

    /**
     * Sets trace.
     *
     * @param null|string $trace trace
     *
     * @return self
     */
    public function setTrace($trace)
    {
        if (is_null($trace)) {
            array_push($this->openAPINullablesSetToNull, 'trace');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('trace', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['trace'] = $trace;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
