<?php

/**
 * RemoteEntityTypeProperty.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * RemoteEntityTypeProperty Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class RemoteEntityTypeProperty implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'RemoteEntityTypeProperty';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'machineName' => 'string',
        'name' => 'string',
        'type' => 'RemoteEntityTypePropertyType',
        'description' => 'string',
        'required' => 'bool',
        'multiple' => 'bool',
        'localized' => 'bool',
        'shared' => 'bool',
        'remoteTypeName' => 'string',
        'properties' => '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeProperty[]',
        'format' => 'RemoteEntityTypePropertyFormat',
        'encoding' => 'RemoteEntityTypePropertyEncoding',
        'allowedValues' => '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityPropertyDraft[]',
        'minValue' => 'float',
        'maxValue' => 'float',
        'minLength' => 'float',
        'maxLength' => 'float',
        'minItems' => 'float',
        'maxItems' => 'float',
        'mainProperty' => 'string',
        'nameProperty' => 'string',
        'unit' => 'string',
        'byteSize' => 'float',
        'allowedEntityTypes' => '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeRestriction[]',
        'regularExpressionFormat' => 'RegularExpression',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'machineName' => null,
        'name' => null,
        'type' => null,
        'description' => null,
        'required' => null,
        'multiple' => null,
        'localized' => null,
        'shared' => null,
        'remoteTypeName' => null,
        'properties' => null,
        'format' => null,
        'encoding' => null,
        'allowedValues' => null,
        'minValue' => null,
        'maxValue' => null,
        'minLength' => null,
        'maxLength' => null,
        'minItems' => null,
        'maxItems' => null,
        'mainProperty' => null,
        'nameProperty' => null,
        'unit' => null,
        'byteSize' => null,
        'allowedEntityTypes' => null,
        'regularExpressionFormat' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'machineName' => false,
        'name' => false,
        'type' => false,
        'description' => true,
        'required' => true,
        'multiple' => true,
        'localized' => true,
        'shared' => true,
        'remoteTypeName' => true,
        'properties' => true,
        'format' => true,
        'encoding' => true,
        'allowedValues' => true,
        'minValue' => true,
        'maxValue' => true,
        'minLength' => true,
        'maxLength' => true,
        'minItems' => true,
        'maxItems' => true,
        'mainProperty' => true,
        'nameProperty' => true,
        'unit' => true,
        'byteSize' => true,
        'allowedEntityTypes' => true,
        'regularExpressionFormat' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'machineName' => 'machineName',
        'name' => 'name',
        'type' => 'type',
        'description' => 'description',
        'required' => 'required',
        'multiple' => 'multiple',
        'localized' => 'localized',
        'shared' => 'shared',
        'remoteTypeName' => 'remoteTypeName',
        'properties' => 'properties',
        'format' => 'format',
        'encoding' => 'encoding',
        'allowedValues' => 'allowedValues',
        'minValue' => 'minValue',
        'maxValue' => 'maxValue',
        'minLength' => 'minLength',
        'maxLength' => 'maxLength',
        'minItems' => 'minItems',
        'maxItems' => 'maxItems',
        'mainProperty' => 'mainProperty',
        'nameProperty' => 'nameProperty',
        'unit' => 'unit',
        'byteSize' => 'byteSize',
        'allowedEntityTypes' => 'allowedEntityTypes',
        'regularExpressionFormat' => 'regularExpressionFormat',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'machineName' => 'setMachineName',
        'name' => 'setName',
        'type' => 'setType',
        'description' => 'setDescription',
        'required' => 'setRequired',
        'multiple' => 'setMultiple',
        'localized' => 'setLocalized',
        'shared' => 'setShared',
        'remoteTypeName' => 'setRemoteTypeName',
        'properties' => 'setProperties',
        'format' => 'setFormat',
        'encoding' => 'setEncoding',
        'allowedValues' => 'setAllowedValues',
        'minValue' => 'setMinValue',
        'maxValue' => 'setMaxValue',
        'minLength' => 'setMinLength',
        'maxLength' => 'setMaxLength',
        'minItems' => 'setMinItems',
        'maxItems' => 'setMaxItems',
        'mainProperty' => 'setMainProperty',
        'nameProperty' => 'setNameProperty',
        'unit' => 'setUnit',
        'byteSize' => 'setByteSize',
        'allowedEntityTypes' => 'setAllowedEntityTypes',
        'regularExpressionFormat' => 'setRegularExpressionFormat',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'machineName' => 'getMachineName',
        'name' => 'getName',
        'type' => 'getType',
        'description' => 'getDescription',
        'required' => 'getRequired',
        'multiple' => 'getMultiple',
        'localized' => 'getLocalized',
        'shared' => 'getShared',
        'remoteTypeName' => 'getRemoteTypeName',
        'properties' => 'getProperties',
        'format' => 'getFormat',
        'encoding' => 'getEncoding',
        'allowedValues' => 'getAllowedValues',
        'minValue' => 'getMinValue',
        'maxValue' => 'getMaxValue',
        'minLength' => 'getMinLength',
        'maxLength' => 'getMaxLength',
        'minItems' => 'getMinItems',
        'maxItems' => 'getMaxItems',
        'mainProperty' => 'getMainProperty',
        'nameProperty' => 'getNameProperty',
        'unit' => 'getUnit',
        'byteSize' => 'getByteSize',
        'allowedEntityTypes' => 'getAllowedEntityTypes',
        'regularExpressionFormat' => 'getRegularExpressionFormat',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('machineName', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('required', $data ?? [], null);
        $this->setIfExists('multiple', $data ?? [], null);
        $this->setIfExists('localized', $data ?? [], null);
        $this->setIfExists('shared', $data ?? [], null);
        $this->setIfExists('remoteTypeName', $data ?? [], null);
        $this->setIfExists('properties', $data ?? [], null);
        $this->setIfExists('format', $data ?? [], null);
        $this->setIfExists('encoding', $data ?? [], null);
        $this->setIfExists('allowedValues', $data ?? [], null);
        $this->setIfExists('minValue', $data ?? [], null);
        $this->setIfExists('maxValue', $data ?? [], null);
        $this->setIfExists('minLength', $data ?? [], null);
        $this->setIfExists('maxLength', $data ?? [], null);
        $this->setIfExists('minItems', $data ?? [], null);
        $this->setIfExists('maxItems', $data ?? [], null);
        $this->setIfExists('mainProperty', $data ?? [], null);
        $this->setIfExists('nameProperty', $data ?? [], null);
        $this->setIfExists('unit', $data ?? [], null);
        $this->setIfExists('byteSize', $data ?? [], null);
        $this->setIfExists('allowedEntityTypes', $data ?? [], null);
        $this->setIfExists('regularExpressionFormat', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['machineName']) {
            $invalidProperties[] = "'machineName' can't be null";
        }
        if (null === $this->container['name']) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (null === $this->container['type']) {
            $invalidProperties[] = "'type' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets machineName.
     *
     * @return string
     */
    public function getMachineName()
    {
        return $this->container['machineName'];
    }

    /**
     * Sets machineName.
     *
     * @param string $machineName machineName
     *
     * @return self
     */
    public function setMachineName($machineName)
    {
        if (is_null($machineName)) {
            throw new \InvalidArgumentException('non-nullable machineName cannot be null');
        }
        $this->container['machineName'] = $machineName;

        return $this;
    }

    /**
     * Gets name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name.
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type.
     *
     * @return RemoteEntityTypePropertyType
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type.
     *
     * @param RemoteEntityTypePropertyType $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets description.
     *
     * @return null|string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description.
     *
     * @param null|string $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets required.
     *
     * @return null|bool
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required.
     *
     * @param null|bool $required required
     *
     * @return self
     */
    public function setRequired($required)
    {
        if (is_null($required)) {
            array_push($this->openAPINullablesSetToNull, 'required');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('required', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['required'] = $required;

        return $this;
    }

    /**
     * Gets multiple.
     *
     * @return null|bool
     */
    public function getMultiple()
    {
        return $this->container['multiple'];
    }

    /**
     * Sets multiple.
     *
     * @param null|bool $multiple multiple
     *
     * @return self
     */
    public function setMultiple($multiple)
    {
        if (is_null($multiple)) {
            array_push($this->openAPINullablesSetToNull, 'multiple');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('multiple', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['multiple'] = $multiple;

        return $this;
    }

    /**
     * Gets localized.
     *
     * @return null|bool
     */
    public function getLocalized()
    {
        return $this->container['localized'];
    }

    /**
     * Sets localized.
     *
     * @param null|bool $localized localized
     *
     * @return self
     */
    public function setLocalized($localized)
    {
        if (is_null($localized)) {
            array_push($this->openAPINullablesSetToNull, 'localized');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('localized', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['localized'] = $localized;

        return $this;
    }

    /**
     * Gets shared.
     *
     * @return null|bool
     */
    public function getShared()
    {
        return $this->container['shared'];
    }

    /**
     * Sets shared.
     *
     * @param null|bool $shared shared
     *
     * @return self
     */
    public function setShared($shared)
    {
        if (is_null($shared)) {
            array_push($this->openAPINullablesSetToNull, 'shared');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shared', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shared'] = $shared;

        return $this;
    }

    /**
     * Gets remoteTypeName.
     *
     * @return null|string
     */
    public function getRemoteTypeName()
    {
        return $this->container['remoteTypeName'];
    }

    /**
     * Sets remoteTypeName.
     *
     * @param null|string $remoteTypeName remoteTypeName
     *
     * @return self
     */
    public function setRemoteTypeName($remoteTypeName)
    {
        if (is_null($remoteTypeName)) {
            array_push($this->openAPINullablesSetToNull, 'remoteTypeName');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('remoteTypeName', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['remoteTypeName'] = $remoteTypeName;

        return $this;
    }

    /**
     * Gets properties.
     *
     * @return null|RemoteEntityTypeProperty[]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties.
     *
     * @param null|RemoteEntityTypeProperty[] $properties properties
     *
     * @return self
     */
    public function setProperties($properties)
    {
        if (is_null($properties)) {
            array_push($this->openAPINullablesSetToNull, 'properties');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('properties', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets format.
     *
     * @return null|RemoteEntityTypePropertyFormat
     */
    public function getFormat()
    {
        return $this->container['format'];
    }

    /**
     * Sets format.
     *
     * @param null|RemoteEntityTypePropertyFormat $format format
     *
     * @return self
     */
    public function setFormat($format)
    {
        if (is_null($format)) {
            array_push($this->openAPINullablesSetToNull, 'format');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('format', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['format'] = $format;

        return $this;
    }

    /**
     * Gets encoding.
     *
     * @return null|RemoteEntityTypePropertyEncoding
     */
    public function getEncoding()
    {
        return $this->container['encoding'];
    }

    /**
     * Sets encoding.
     *
     * @param null|RemoteEntityTypePropertyEncoding $encoding encoding
     *
     * @return self
     */
    public function setEncoding($encoding)
    {
        if (is_null($encoding)) {
            array_push($this->openAPINullablesSetToNull, 'encoding');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('encoding', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['encoding'] = $encoding;

        return $this;
    }

    /**
     * Gets allowedValues.
     *
     * @return null|RemoteEntityPropertyDraft[]
     */
    public function getAllowedValues()
    {
        return $this->container['allowedValues'];
    }

    /**
     * Sets allowedValues.
     *
     * @param null|RemoteEntityPropertyDraft[] $allowedValues allowedValues
     *
     * @return self
     */
    public function setAllowedValues($allowedValues)
    {
        if (is_null($allowedValues)) {
            array_push($this->openAPINullablesSetToNull, 'allowedValues');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('allowedValues', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['allowedValues'] = $allowedValues;

        return $this;
    }

    /**
     * Gets minValue.
     *
     * @return null|float
     */
    public function getMinValue()
    {
        return $this->container['minValue'];
    }

    /**
     * Sets minValue.
     *
     * @param null|float $minValue minValue
     *
     * @return self
     */
    public function setMinValue($minValue)
    {
        if (is_null($minValue)) {
            array_push($this->openAPINullablesSetToNull, 'minValue');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minValue', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minValue'] = $minValue;

        return $this;
    }

    /**
     * Gets maxValue.
     *
     * @return null|float
     */
    public function getMaxValue()
    {
        return $this->container['maxValue'];
    }

    /**
     * Sets maxValue.
     *
     * @param null|float $maxValue maxValue
     *
     * @return self
     */
    public function setMaxValue($maxValue)
    {
        if (is_null($maxValue)) {
            array_push($this->openAPINullablesSetToNull, 'maxValue');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxValue', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxValue'] = $maxValue;

        return $this;
    }

    /**
     * Gets minLength.
     *
     * @return null|float
     */
    public function getMinLength()
    {
        return $this->container['minLength'];
    }

    /**
     * Sets minLength.
     *
     * @param null|float $minLength minLength
     *
     * @return self
     */
    public function setMinLength($minLength)
    {
        if (is_null($minLength)) {
            array_push($this->openAPINullablesSetToNull, 'minLength');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minLength', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minLength'] = $minLength;

        return $this;
    }

    /**
     * Gets maxLength.
     *
     * @return null|float
     */
    public function getMaxLength()
    {
        return $this->container['maxLength'];
    }

    /**
     * Sets maxLength.
     *
     * @param null|float $maxLength maxLength
     *
     * @return self
     */
    public function setMaxLength($maxLength)
    {
        if (is_null($maxLength)) {
            array_push($this->openAPINullablesSetToNull, 'maxLength');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxLength', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxLength'] = $maxLength;

        return $this;
    }

    /**
     * Gets minItems.
     *
     * @return null|float
     */
    public function getMinItems()
    {
        return $this->container['minItems'];
    }

    /**
     * Sets minItems.
     *
     * @param null|float $minItems minItems
     *
     * @return self
     */
    public function setMinItems($minItems)
    {
        if (is_null($minItems)) {
            array_push($this->openAPINullablesSetToNull, 'minItems');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minItems', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minItems'] = $minItems;

        return $this;
    }

    /**
     * Gets maxItems.
     *
     * @return null|float
     */
    public function getMaxItems()
    {
        return $this->container['maxItems'];
    }

    /**
     * Sets maxItems.
     *
     * @param null|float $maxItems maxItems
     *
     * @return self
     */
    public function setMaxItems($maxItems)
    {
        if (is_null($maxItems)) {
            array_push($this->openAPINullablesSetToNull, 'maxItems');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxItems', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxItems'] = $maxItems;

        return $this;
    }

    /**
     * Gets mainProperty.
     *
     * @return null|string
     */
    public function getMainProperty()
    {
        return $this->container['mainProperty'];
    }

    /**
     * Sets mainProperty.
     *
     * @param null|string $mainProperty mainProperty
     *
     * @return self
     */
    public function setMainProperty($mainProperty)
    {
        if (is_null($mainProperty)) {
            array_push($this->openAPINullablesSetToNull, 'mainProperty');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mainProperty', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['mainProperty'] = $mainProperty;

        return $this;
    }

    /**
     * Gets nameProperty.
     *
     * @return null|string
     */
    public function getNameProperty()
    {
        return $this->container['nameProperty'];
    }

    /**
     * Sets nameProperty.
     *
     * @param null|string $nameProperty nameProperty
     *
     * @return self
     */
    public function setNameProperty($nameProperty)
    {
        if (is_null($nameProperty)) {
            array_push($this->openAPINullablesSetToNull, 'nameProperty');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('nameProperty', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['nameProperty'] = $nameProperty;

        return $this;
    }

    /**
     * Gets unit.
     *
     * @return null|string
     */
    public function getUnit()
    {
        return $this->container['unit'];
    }

    /**
     * Sets unit.
     *
     * @param null|string $unit unit
     *
     * @return self
     */
    public function setUnit($unit)
    {
        if (is_null($unit)) {
            array_push($this->openAPINullablesSetToNull, 'unit');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('unit', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['unit'] = $unit;

        return $this;
    }

    /**
     * Gets byteSize.
     *
     * @return null|float
     */
    public function getByteSize()
    {
        return $this->container['byteSize'];
    }

    /**
     * Sets byteSize.
     *
     * @param null|float $byteSize byteSize
     *
     * @return self
     */
    public function setByteSize($byteSize)
    {
        if (is_null($byteSize)) {
            array_push($this->openAPINullablesSetToNull, 'byteSize');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('byteSize', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['byteSize'] = $byteSize;

        return $this;
    }

    /**
     * Gets allowedEntityTypes.
     *
     * @return null|RemoteEntityTypeRestriction[]
     */
    public function getAllowedEntityTypes()
    {
        return $this->container['allowedEntityTypes'];
    }

    /**
     * Sets allowedEntityTypes.
     *
     * @param null|RemoteEntityTypeRestriction[] $allowedEntityTypes allowedEntityTypes
     *
     * @return self
     */
    public function setAllowedEntityTypes($allowedEntityTypes)
    {
        if (is_null($allowedEntityTypes)) {
            array_push($this->openAPINullablesSetToNull, 'allowedEntityTypes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('allowedEntityTypes', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['allowedEntityTypes'] = $allowedEntityTypes;

        return $this;
    }

    /**
     * Gets regularExpressionFormat.
     *
     * @return null|RegularExpression
     */
    public function getRegularExpressionFormat()
    {
        return $this->container['regularExpressionFormat'];
    }

    /**
     * Sets regularExpressionFormat.
     *
     * @param null|RegularExpression $regularExpressionFormat regularExpressionFormat
     *
     * @return self
     */
    public function setRegularExpressionFormat($regularExpressionFormat)
    {
        if (is_null($regularExpressionFormat)) {
            array_push($this->openAPINullablesSetToNull, 'regularExpressionFormat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('regularExpressionFormat', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['regularExpressionFormat'] = $regularExpressionFormat;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
