<?php

/**
 * RemoteEntityCloneEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * RemoteEntityCloneEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class RemoteEntityCloneEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'RemoteEntityCloneEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'status' => 'EntityRemoteStatus',
        'viewUrl' => 'string',
        'site' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'translations' => '\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreRemoteEntityCloneEntityReference[]',
        'poolMachineNames' => 'string[]',
        'entityType' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'flow' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'sourceRemoteUuid' => 'string',
        'sourceRemoteUniqueId' => 'string',
        'targetRemoteUuid' => 'string',
        'targetRemoteUniqueId' => 'string',
        'pulledAt' => 'float',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'project' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'pools' => '\EdgeBox\SyncCore\V2\Raw\Model\DynamicReference[]',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'status' => null,
        'viewUrl' => null,
        'site' => null,
        'translations' => null,
        'poolMachineNames' => null,
        'entityType' => null,
        'flow' => null,
        'sourceRemoteUuid' => null,
        'sourceRemoteUniqueId' => null,
        'targetRemoteUuid' => null,
        'targetRemoteUniqueId' => null,
        'pulledAt' => null,
        'customer' => null,
        'project' => null,
        'pools' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'status' => false,
        'viewUrl' => false,
        'site' => false,
        'translations' => false,
        'poolMachineNames' => false,
        'entityType' => false,
        'flow' => false,
        'sourceRemoteUuid' => false,
        'sourceRemoteUniqueId' => true,
        'targetRemoteUuid' => false,
        'targetRemoteUniqueId' => true,
        'pulledAt' => true,
        'customer' => false,
        'project' => false,
        'pools' => false,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'status' => 'status',
        'viewUrl' => 'viewUrl',
        'site' => 'site',
        'translations' => 'translations',
        'poolMachineNames' => 'poolMachineNames',
        'entityType' => 'entityType',
        'flow' => 'flow',
        'sourceRemoteUuid' => 'sourceRemoteUuid',
        'sourceRemoteUniqueId' => 'sourceRemoteUniqueId',
        'targetRemoteUuid' => 'targetRemoteUuid',
        'targetRemoteUniqueId' => 'targetRemoteUniqueId',
        'pulledAt' => 'pulledAt',
        'customer' => 'customer',
        'project' => 'project',
        'pools' => 'pools',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'status' => 'setStatus',
        'viewUrl' => 'setViewUrl',
        'site' => 'setSite',
        'translations' => 'setTranslations',
        'poolMachineNames' => 'setPoolMachineNames',
        'entityType' => 'setEntityType',
        'flow' => 'setFlow',
        'sourceRemoteUuid' => 'setSourceRemoteUuid',
        'sourceRemoteUniqueId' => 'setSourceRemoteUniqueId',
        'targetRemoteUuid' => 'setTargetRemoteUuid',
        'targetRemoteUniqueId' => 'setTargetRemoteUniqueId',
        'pulledAt' => 'setPulledAt',
        'customer' => 'setCustomer',
        'project' => 'setProject',
        'pools' => 'setPools',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'status' => 'getStatus',
        'viewUrl' => 'getViewUrl',
        'site' => 'getSite',
        'translations' => 'getTranslations',
        'poolMachineNames' => 'getPoolMachineNames',
        'entityType' => 'getEntityType',
        'flow' => 'getFlow',
        'sourceRemoteUuid' => 'getSourceRemoteUuid',
        'sourceRemoteUniqueId' => 'getSourceRemoteUniqueId',
        'targetRemoteUuid' => 'getTargetRemoteUuid',
        'targetRemoteUniqueId' => 'getTargetRemoteUniqueId',
        'pulledAt' => 'getPulledAt',
        'customer' => 'getCustomer',
        'project' => 'getProject',
        'pools' => 'getPools',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('viewUrl', $data ?? [], null);
        $this->setIfExists('site', $data ?? [], null);
        $this->setIfExists('translations', $data ?? [], null);
        $this->setIfExists('poolMachineNames', $data ?? [], null);
        $this->setIfExists('entityType', $data ?? [], null);
        $this->setIfExists('flow', $data ?? [], null);
        $this->setIfExists('sourceRemoteUuid', $data ?? [], null);
        $this->setIfExists('sourceRemoteUniqueId', $data ?? [], null);
        $this->setIfExists('targetRemoteUuid', $data ?? [], null);
        $this->setIfExists('targetRemoteUniqueId', $data ?? [], null);
        $this->setIfExists('pulledAt', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('project', $data ?? [], null);
        $this->setIfExists('pools', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }
        if (null === $this->container['viewUrl']) {
            $invalidProperties[] = "'viewUrl' can't be null";
        }
        if (null === $this->container['site']) {
            $invalidProperties[] = "'site' can't be null";
        }
        if (null === $this->container['translations']) {
            $invalidProperties[] = "'translations' can't be null";
        }
        if (null === $this->container['poolMachineNames']) {
            $invalidProperties[] = "'poolMachineNames' can't be null";
        }
        if (null === $this->container['entityType']) {
            $invalidProperties[] = "'entityType' can't be null";
        }
        if (null === $this->container['flow']) {
            $invalidProperties[] = "'flow' can't be null";
        }
        if (null === $this->container['sourceRemoteUuid']) {
            $invalidProperties[] = "'sourceRemoteUuid' can't be null";
        }
        if (null === $this->container['targetRemoteUuid']) {
            $invalidProperties[] = "'targetRemoteUuid' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['project']) {
            $invalidProperties[] = "'project' can't be null";
        }
        if (null === $this->container['pools']) {
            $invalidProperties[] = "'pools' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets status.
     *
     * @return EntityRemoteStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param EntityRemoteStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets viewUrl.
     *
     * @return string
     */
    public function getViewUrl()
    {
        return $this->container['viewUrl'];
    }

    /**
     * Sets viewUrl.
     *
     * @param string $viewUrl viewUrl
     *
     * @return self
     */
    public function setViewUrl($viewUrl)
    {
        if (is_null($viewUrl)) {
            throw new \InvalidArgumentException('non-nullable viewUrl cannot be null');
        }
        $this->container['viewUrl'] = $viewUrl;

        return $this;
    }

    /**
     * Gets site.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $site site
     *
     * @return self
     */
    public function setSite($site)
    {
        if (is_null($site)) {
            throw new \InvalidArgumentException('non-nullable site cannot be null');
        }
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets translations.
     *
     * @return SyncCoreRemoteEntityCloneEntityReference[]
     */
    public function getTranslations()
    {
        return $this->container['translations'];
    }

    /**
     * Sets translations.
     *
     * @param SyncCoreRemoteEntityCloneEntityReference[] $translations translations
     *
     * @return self
     */
    public function setTranslations($translations)
    {
        if (is_null($translations)) {
            throw new \InvalidArgumentException('non-nullable translations cannot be null');
        }
        $this->container['translations'] = $translations;

        return $this;
    }

    /**
     * Gets poolMachineNames.
     *
     * @return string[]
     */
    public function getPoolMachineNames()
    {
        return $this->container['poolMachineNames'];
    }

    /**
     * Sets poolMachineNames.
     *
     * @param string[] $poolMachineNames poolMachineNames
     *
     * @return self
     */
    public function setPoolMachineNames($poolMachineNames)
    {
        if (is_null($poolMachineNames)) {
            throw new \InvalidArgumentException('non-nullable poolMachineNames cannot be null');
        }
        $this->container['poolMachineNames'] = $poolMachineNames;

        return $this;
    }

    /**
     * Gets entityType.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getEntityType()
    {
        return $this->container['entityType'];
    }

    /**
     * Sets entityType.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $entityType entityType
     *
     * @return self
     */
    public function setEntityType($entityType)
    {
        if (is_null($entityType)) {
            throw new \InvalidArgumentException('non-nullable entityType cannot be null');
        }
        $this->container['entityType'] = $entityType;

        return $this;
    }

    /**
     * Gets flow.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $flow flow
     *
     * @return self
     */
    public function setFlow($flow)
    {
        if (is_null($flow)) {
            throw new \InvalidArgumentException('non-nullable flow cannot be null');
        }
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets sourceRemoteUuid.
     *
     * @return string
     */
    public function getSourceRemoteUuid()
    {
        return $this->container['sourceRemoteUuid'];
    }

    /**
     * Sets sourceRemoteUuid.
     *
     * @param string $sourceRemoteUuid sourceRemoteUuid
     *
     * @return self
     */
    public function setSourceRemoteUuid($sourceRemoteUuid)
    {
        if (is_null($sourceRemoteUuid)) {
            throw new \InvalidArgumentException('non-nullable sourceRemoteUuid cannot be null');
        }
        $this->container['sourceRemoteUuid'] = $sourceRemoteUuid;

        return $this;
    }

    /**
     * Gets sourceRemoteUniqueId.
     *
     * @return null|string
     */
    public function getSourceRemoteUniqueId()
    {
        return $this->container['sourceRemoteUniqueId'];
    }

    /**
     * Sets sourceRemoteUniqueId.
     *
     * @param null|string $sourceRemoteUniqueId sourceRemoteUniqueId
     *
     * @return self
     */
    public function setSourceRemoteUniqueId($sourceRemoteUniqueId)
    {
        if (is_null($sourceRemoteUniqueId)) {
            array_push($this->openAPINullablesSetToNull, 'sourceRemoteUniqueId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sourceRemoteUniqueId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sourceRemoteUniqueId'] = $sourceRemoteUniqueId;

        return $this;
    }

    /**
     * Gets targetRemoteUuid.
     *
     * @return string
     */
    public function getTargetRemoteUuid()
    {
        return $this->container['targetRemoteUuid'];
    }

    /**
     * Sets targetRemoteUuid.
     *
     * @param string $targetRemoteUuid targetRemoteUuid
     *
     * @return self
     */
    public function setTargetRemoteUuid($targetRemoteUuid)
    {
        if (is_null($targetRemoteUuid)) {
            throw new \InvalidArgumentException('non-nullable targetRemoteUuid cannot be null');
        }
        $this->container['targetRemoteUuid'] = $targetRemoteUuid;

        return $this;
    }

    /**
     * Gets targetRemoteUniqueId.
     *
     * @return null|string
     */
    public function getTargetRemoteUniqueId()
    {
        return $this->container['targetRemoteUniqueId'];
    }

    /**
     * Sets targetRemoteUniqueId.
     *
     * @param null|string $targetRemoteUniqueId targetRemoteUniqueId
     *
     * @return self
     */
    public function setTargetRemoteUniqueId($targetRemoteUniqueId)
    {
        if (is_null($targetRemoteUniqueId)) {
            array_push($this->openAPINullablesSetToNull, 'targetRemoteUniqueId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('targetRemoteUniqueId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['targetRemoteUniqueId'] = $targetRemoteUniqueId;

        return $this;
    }

    /**
     * Gets pulledAt.
     *
     * @return null|float
     */
    public function getPulledAt()
    {
        return $this->container['pulledAt'];
    }

    /**
     * Sets pulledAt.
     *
     * @param null|float $pulledAt pulledAt
     *
     * @return self
     */
    public function setPulledAt($pulledAt)
    {
        if (is_null($pulledAt)) {
            array_push($this->openAPINullablesSetToNull, 'pulledAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pulledAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pulledAt'] = $pulledAt;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets project.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getProject()
    {
        return $this->container['project'];
    }

    /**
     * Sets project.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $project project
     *
     * @return self
     */
    public function setProject($project)
    {
        if (is_null($project)) {
            throw new \InvalidArgumentException('non-nullable project cannot be null');
        }
        $this->container['project'] = $project;

        return $this;
    }

    /**
     * Gets pools.
     *
     * @return DynamicReference[]
     */
    public function getPools()
    {
        return $this->container['pools'];
    }

    /**
     * Sets pools.
     *
     * @param DynamicReference[] $pools pools
     *
     * @return self
     */
    public function setPools($pools)
    {
        if (is_null($pools)) {
            throw new \InvalidArgumentException('non-nullable pools cannot be null');
        }
        $this->container['pools'] = $pools;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
