<?php

/**
 * ProjectLinkEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * ProjectLinkEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class ProjectLinkEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'ProjectLinkEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'name' => 'string',
        'uuid' => 'string',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'status' => 'ProjectLinkStatus',
        'entityBehavior' => 'EntityMatchType',
        'entityTypeBehavior' => 'EntityMatchType',
        'sourceContract' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'sourceProject' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'sourceAppType' => 'SiteApplicationType',
        'sourcePoolMachineNames' => 'string[]',
        'targetContract' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'targetProject' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'targetAppType' => 'SiteApplicationType',
        'targetPoolMachineName' => 'string',
        'transformerSettings' => 'TransformerSettings',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'name' => null,
        'uuid' => null,
        'customer' => null,
        'status' => null,
        'entityBehavior' => null,
        'entityTypeBehavior' => null,
        'sourceContract' => null,
        'sourceProject' => null,
        'sourceAppType' => null,
        'sourcePoolMachineNames' => null,
        'targetContract' => null,
        'targetProject' => null,
        'targetAppType' => null,
        'targetPoolMachineName' => null,
        'transformerSettings' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'name' => false,
        'uuid' => false,
        'customer' => false,
        'status' => false,
        'entityBehavior' => false,
        'entityTypeBehavior' => false,
        'sourceContract' => false,
        'sourceProject' => false,
        'sourceAppType' => false,
        'sourcePoolMachineNames' => false,
        'targetContract' => false,
        'targetProject' => false,
        'targetAppType' => false,
        'targetPoolMachineName' => false,
        'transformerSettings' => true,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'uuid' => 'uuid',
        'customer' => 'customer',
        'status' => 'status',
        'entityBehavior' => 'entityBehavior',
        'entityTypeBehavior' => 'entityTypeBehavior',
        'sourceContract' => 'sourceContract',
        'sourceProject' => 'sourceProject',
        'sourceAppType' => 'sourceAppType',
        'sourcePoolMachineNames' => 'sourcePoolMachineNames',
        'targetContract' => 'targetContract',
        'targetProject' => 'targetProject',
        'targetAppType' => 'targetAppType',
        'targetPoolMachineName' => 'targetPoolMachineName',
        'transformerSettings' => 'transformerSettings',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'uuid' => 'setUuid',
        'customer' => 'setCustomer',
        'status' => 'setStatus',
        'entityBehavior' => 'setEntityBehavior',
        'entityTypeBehavior' => 'setEntityTypeBehavior',
        'sourceContract' => 'setSourceContract',
        'sourceProject' => 'setSourceProject',
        'sourceAppType' => 'setSourceAppType',
        'sourcePoolMachineNames' => 'setSourcePoolMachineNames',
        'targetContract' => 'setTargetContract',
        'targetProject' => 'setTargetProject',
        'targetAppType' => 'setTargetAppType',
        'targetPoolMachineName' => 'setTargetPoolMachineName',
        'transformerSettings' => 'setTransformerSettings',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'uuid' => 'getUuid',
        'customer' => 'getCustomer',
        'status' => 'getStatus',
        'entityBehavior' => 'getEntityBehavior',
        'entityTypeBehavior' => 'getEntityTypeBehavior',
        'sourceContract' => 'getSourceContract',
        'sourceProject' => 'getSourceProject',
        'sourceAppType' => 'getSourceAppType',
        'sourcePoolMachineNames' => 'getSourcePoolMachineNames',
        'targetContract' => 'getTargetContract',
        'targetProject' => 'getTargetProject',
        'targetAppType' => 'getTargetAppType',
        'targetPoolMachineName' => 'getTargetPoolMachineName',
        'transformerSettings' => 'getTransformerSettings',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('uuid', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('entityBehavior', $data ?? [], null);
        $this->setIfExists('entityTypeBehavior', $data ?? [], null);
        $this->setIfExists('sourceContract', $data ?? [], null);
        $this->setIfExists('sourceProject', $data ?? [], null);
        $this->setIfExists('sourceAppType', $data ?? [], null);
        $this->setIfExists('sourcePoolMachineNames', $data ?? [], null);
        $this->setIfExists('targetContract', $data ?? [], null);
        $this->setIfExists('targetProject', $data ?? [], null);
        $this->setIfExists('targetAppType', $data ?? [], null);
        $this->setIfExists('targetPoolMachineName', $data ?? [], null);
        $this->setIfExists('transformerSettings', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['name']) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (null === $this->container['uuid']) {
            $invalidProperties[] = "'uuid' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }
        if (null === $this->container['entityBehavior']) {
            $invalidProperties[] = "'entityBehavior' can't be null";
        }
        if (null === $this->container['entityTypeBehavior']) {
            $invalidProperties[] = "'entityTypeBehavior' can't be null";
        }
        if (null === $this->container['sourceContract']) {
            $invalidProperties[] = "'sourceContract' can't be null";
        }
        if (null === $this->container['sourceProject']) {
            $invalidProperties[] = "'sourceProject' can't be null";
        }
        if (null === $this->container['sourceAppType']) {
            $invalidProperties[] = "'sourceAppType' can't be null";
        }
        if (null === $this->container['sourcePoolMachineNames']) {
            $invalidProperties[] = "'sourcePoolMachineNames' can't be null";
        }
        if (null === $this->container['targetContract']) {
            $invalidProperties[] = "'targetContract' can't be null";
        }
        if (null === $this->container['targetProject']) {
            $invalidProperties[] = "'targetProject' can't be null";
        }
        if (null === $this->container['targetAppType']) {
            $invalidProperties[] = "'targetAppType' can't be null";
        }
        if (null === $this->container['targetPoolMachineName']) {
            $invalidProperties[] = "'targetPoolMachineName' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name.
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets uuid.
     *
     * @return string
     */
    public function getUuid()
    {
        return $this->container['uuid'];
    }

    /**
     * Sets uuid.
     *
     * @param string $uuid uuid
     *
     * @return self
     */
    public function setUuid($uuid)
    {
        if (is_null($uuid)) {
            throw new \InvalidArgumentException('non-nullable uuid cannot be null');
        }
        $this->container['uuid'] = $uuid;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets status.
     *
     * @return ProjectLinkStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param ProjectLinkStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets entityBehavior.
     *
     * @return EntityMatchType
     */
    public function getEntityBehavior()
    {
        return $this->container['entityBehavior'];
    }

    /**
     * Sets entityBehavior.
     *
     * @param EntityMatchType $entityBehavior entityBehavior
     *
     * @return self
     */
    public function setEntityBehavior($entityBehavior)
    {
        if (is_null($entityBehavior)) {
            throw new \InvalidArgumentException('non-nullable entityBehavior cannot be null');
        }
        $this->container['entityBehavior'] = $entityBehavior;

        return $this;
    }

    /**
     * Gets entityTypeBehavior.
     *
     * @return EntityMatchType
     */
    public function getEntityTypeBehavior()
    {
        return $this->container['entityTypeBehavior'];
    }

    /**
     * Sets entityTypeBehavior.
     *
     * @param EntityMatchType $entityTypeBehavior entityTypeBehavior
     *
     * @return self
     */
    public function setEntityTypeBehavior($entityTypeBehavior)
    {
        if (is_null($entityTypeBehavior)) {
            throw new \InvalidArgumentException('non-nullable entityTypeBehavior cannot be null');
        }
        $this->container['entityTypeBehavior'] = $entityTypeBehavior;

        return $this;
    }

    /**
     * Gets sourceContract.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getSourceContract()
    {
        return $this->container['sourceContract'];
    }

    /**
     * Sets sourceContract.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $sourceContract sourceContract
     *
     * @return self
     */
    public function setSourceContract($sourceContract)
    {
        if (is_null($sourceContract)) {
            throw new \InvalidArgumentException('non-nullable sourceContract cannot be null');
        }
        $this->container['sourceContract'] = $sourceContract;

        return $this;
    }

    /**
     * Gets sourceProject.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getSourceProject()
    {
        return $this->container['sourceProject'];
    }

    /**
     * Sets sourceProject.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $sourceProject sourceProject
     *
     * @return self
     */
    public function setSourceProject($sourceProject)
    {
        if (is_null($sourceProject)) {
            throw new \InvalidArgumentException('non-nullable sourceProject cannot be null');
        }
        $this->container['sourceProject'] = $sourceProject;

        return $this;
    }

    /**
     * Gets sourceAppType.
     *
     * @return SiteApplicationType
     */
    public function getSourceAppType()
    {
        return $this->container['sourceAppType'];
    }

    /**
     * Sets sourceAppType.
     *
     * @param SiteApplicationType $sourceAppType sourceAppType
     *
     * @return self
     */
    public function setSourceAppType($sourceAppType)
    {
        if (is_null($sourceAppType)) {
            throw new \InvalidArgumentException('non-nullable sourceAppType cannot be null');
        }
        $this->container['sourceAppType'] = $sourceAppType;

        return $this;
    }

    /**
     * Gets sourcePoolMachineNames.
     *
     * @return string[]
     */
    public function getSourcePoolMachineNames()
    {
        return $this->container['sourcePoolMachineNames'];
    }

    /**
     * Sets sourcePoolMachineNames.
     *
     * @param string[] $sourcePoolMachineNames sourcePoolMachineNames
     *
     * @return self
     */
    public function setSourcePoolMachineNames($sourcePoolMachineNames)
    {
        if (is_null($sourcePoolMachineNames)) {
            throw new \InvalidArgumentException('non-nullable sourcePoolMachineNames cannot be null');
        }
        $this->container['sourcePoolMachineNames'] = $sourcePoolMachineNames;

        return $this;
    }

    /**
     * Gets targetContract.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getTargetContract()
    {
        return $this->container['targetContract'];
    }

    /**
     * Sets targetContract.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $targetContract targetContract
     *
     * @return self
     */
    public function setTargetContract($targetContract)
    {
        if (is_null($targetContract)) {
            throw new \InvalidArgumentException('non-nullable targetContract cannot be null');
        }
        $this->container['targetContract'] = $targetContract;

        return $this;
    }

    /**
     * Gets targetProject.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getTargetProject()
    {
        return $this->container['targetProject'];
    }

    /**
     * Sets targetProject.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $targetProject targetProject
     *
     * @return self
     */
    public function setTargetProject($targetProject)
    {
        if (is_null($targetProject)) {
            throw new \InvalidArgumentException('non-nullable targetProject cannot be null');
        }
        $this->container['targetProject'] = $targetProject;

        return $this;
    }

    /**
     * Gets targetAppType.
     *
     * @return SiteApplicationType
     */
    public function getTargetAppType()
    {
        return $this->container['targetAppType'];
    }

    /**
     * Sets targetAppType.
     *
     * @param SiteApplicationType $targetAppType targetAppType
     *
     * @return self
     */
    public function setTargetAppType($targetAppType)
    {
        if (is_null($targetAppType)) {
            throw new \InvalidArgumentException('non-nullable targetAppType cannot be null');
        }
        $this->container['targetAppType'] = $targetAppType;

        return $this;
    }

    /**
     * Gets targetPoolMachineName.
     *
     * @return string
     */
    public function getTargetPoolMachineName()
    {
        return $this->container['targetPoolMachineName'];
    }

    /**
     * Sets targetPoolMachineName.
     *
     * @param string $targetPoolMachineName targetPoolMachineName
     *
     * @return self
     */
    public function setTargetPoolMachineName($targetPoolMachineName)
    {
        if (is_null($targetPoolMachineName)) {
            throw new \InvalidArgumentException('non-nullable targetPoolMachineName cannot be null');
        }
        $this->container['targetPoolMachineName'] = $targetPoolMachineName;

        return $this;
    }

    /**
     * Gets transformerSettings.
     *
     * @return null|TransformerSettings
     */
    public function getTransformerSettings()
    {
        return $this->container['transformerSettings'];
    }

    /**
     * Sets transformerSettings.
     *
     * @param null|TransformerSettings $transformerSettings transformerSettings
     *
     * @return self
     */
    public function setTransformerSettings($transformerSettings)
    {
        if (is_null($transformerSettings)) {
            array_push($this->openAPINullablesSetToNull, 'transformerSettings');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transformerSettings', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transformerSettings'] = $transformerSettings;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
