<?php

/**
 * PreviewItem.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * PreviewItem Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class PreviewItem implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'PreviewItem';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'entity' => '\EdgeBox\SyncCore\V2\Raw\Model\PreviewItemEntity',
        'entityTypeVersion' => '\EdgeBox\SyncCore\V2\Raw\Model\PreviewItemEntityTypeVersion',
        'previewHtml' => 'string',
        'localUsage' => 'RemoteEntityUsageEntity',
        'sourceUsage' => '\EdgeBox\SyncCore\V2\Raw\Model\PreviewItemSourceUsage',
        'lastPull' => 'SyndicationEntity',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'entity' => null,
        'entityTypeVersion' => null,
        'previewHtml' => null,
        'localUsage' => null,
        'sourceUsage' => null,
        'lastPull' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'entity' => false,
        'entityTypeVersion' => false,
        'previewHtml' => true,
        'localUsage' => true,
        'sourceUsage' => false,
        'lastPull' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entity' => 'entity',
        'entityTypeVersion' => 'entityTypeVersion',
        'previewHtml' => 'previewHtml',
        'localUsage' => 'localUsage',
        'sourceUsage' => 'sourceUsage',
        'lastPull' => 'lastPull',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'entity' => 'setEntity',
        'entityTypeVersion' => 'setEntityTypeVersion',
        'previewHtml' => 'setPreviewHtml',
        'localUsage' => 'setLocalUsage',
        'sourceUsage' => 'setSourceUsage',
        'lastPull' => 'setLastPull',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'entity' => 'getEntity',
        'entityTypeVersion' => 'getEntityTypeVersion',
        'previewHtml' => 'getPreviewHtml',
        'localUsage' => 'getLocalUsage',
        'sourceUsage' => 'getSourceUsage',
        'lastPull' => 'getLastPull',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('entityTypeVersion', $data ?? [], null);
        $this->setIfExists('previewHtml', $data ?? [], null);
        $this->setIfExists('localUsage', $data ?? [], null);
        $this->setIfExists('sourceUsage', $data ?? [], null);
        $this->setIfExists('lastPull', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['entity']) {
            $invalidProperties[] = "'entity' can't be null";
        }
        if (null === $this->container['entityTypeVersion']) {
            $invalidProperties[] = "'entityTypeVersion' can't be null";
        }
        if (null === $this->container['sourceUsage']) {
            $invalidProperties[] = "'sourceUsage' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets entity.
     *
     * @return PreviewItemEntity
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity.
     *
     * @param PreviewItemEntity $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets entityTypeVersion.
     *
     * @return PreviewItemEntityTypeVersion
     */
    public function getEntityTypeVersion()
    {
        return $this->container['entityTypeVersion'];
    }

    /**
     * Sets entityTypeVersion.
     *
     * @param PreviewItemEntityTypeVersion $entityTypeVersion entityTypeVersion
     *
     * @return self
     */
    public function setEntityTypeVersion($entityTypeVersion)
    {
        if (is_null($entityTypeVersion)) {
            throw new \InvalidArgumentException('non-nullable entityTypeVersion cannot be null');
        }
        $this->container['entityTypeVersion'] = $entityTypeVersion;

        return $this;
    }

    /**
     * Gets previewHtml.
     *
     * @return null|string
     */
    public function getPreviewHtml()
    {
        return $this->container['previewHtml'];
    }

    /**
     * Sets previewHtml.
     *
     * @param null|string $previewHtml previewHtml
     *
     * @return self
     */
    public function setPreviewHtml($previewHtml)
    {
        if (is_null($previewHtml)) {
            array_push($this->openAPINullablesSetToNull, 'previewHtml');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('previewHtml', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['previewHtml'] = $previewHtml;

        return $this;
    }

    /**
     * Gets localUsage.
     *
     * @return null|RemoteEntityUsageEntity
     */
    public function getLocalUsage()
    {
        return $this->container['localUsage'];
    }

    /**
     * Sets localUsage.
     *
     * @param null|RemoteEntityUsageEntity $localUsage localUsage
     *
     * @return self
     */
    public function setLocalUsage($localUsage)
    {
        if (is_null($localUsage)) {
            array_push($this->openAPINullablesSetToNull, 'localUsage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('localUsage', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['localUsage'] = $localUsage;

        return $this;
    }

    /**
     * Gets sourceUsage.
     *
     * @return PreviewItemSourceUsage
     */
    public function getSourceUsage()
    {
        return $this->container['sourceUsage'];
    }

    /**
     * Sets sourceUsage.
     *
     * @param PreviewItemSourceUsage $sourceUsage sourceUsage
     *
     * @return self
     */
    public function setSourceUsage($sourceUsage)
    {
        if (is_null($sourceUsage)) {
            throw new \InvalidArgumentException('non-nullable sourceUsage cannot be null');
        }
        $this->container['sourceUsage'] = $sourceUsage;

        return $this;
    }

    /**
     * Gets lastPull.
     *
     * @return null|SyndicationEntity
     */
    public function getLastPull()
    {
        return $this->container['lastPull'];
    }

    /**
     * Sets lastPull.
     *
     * @param null|SyndicationEntity $lastPull lastPull
     *
     * @return self
     */
    public function setLastPull($lastPull)
    {
        if (is_null($lastPull)) {
            array_push($this->openAPINullablesSetToNull, 'lastPull');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lastPull', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lastPull'] = $lastPull;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
