<?php

/**
 * MigrationEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * MigrationEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class MigrationEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'MigrationEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'type' => 'MigrationType',
        'entityTypeReference' => 'EntityTypeVersionReference',
        'entityReferences' => '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntitySummary[]',
        'previousMigration' => 'DynamicReference',
        'initialSetup' => 'bool',
        'changedAfter' => 'float',
        'dryRun' => 'bool',
        'skipSyndication' => 'bool',
        'skipOptimization' => 'bool',
        'flowMachineName' => 'string',
        'runInOrder' => 'bool',
        'priority' => 'float',
        'entityTypeVersion' => 'DynamicReference',
        'entityType' => 'DynamicReference',
        'entities' => '\EdgeBox\SyncCore\V2\Raw\Model\DynamicReference[]',
        'status' => 'SyndicationStatus',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'site' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'project' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'flow' => 'DynamicReference',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'type' => null,
        'entityTypeReference' => null,
        'entityReferences' => null,
        'previousMigration' => null,
        'initialSetup' => null,
        'changedAfter' => null,
        'dryRun' => null,
        'skipSyndication' => null,
        'skipOptimization' => null,
        'flowMachineName' => null,
        'runInOrder' => null,
        'priority' => null,
        'entityTypeVersion' => null,
        'entityType' => null,
        'entities' => null,
        'status' => null,
        'customer' => null,
        'site' => null,
        'project' => null,
        'flow' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'type' => false,
        'entityTypeReference' => true,
        'entityReferences' => true,
        'previousMigration' => true,
        'initialSetup' => true,
        'changedAfter' => true,
        'dryRun' => true,
        'skipSyndication' => true,
        'skipOptimization' => true,
        'flowMachineName' => true,
        'runInOrder' => true,
        'priority' => true,
        'entityTypeVersion' => true,
        'entityType' => true,
        'entities' => true,
        'status' => false,
        'customer' => false,
        'site' => false,
        'project' => false,
        'flow' => true,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'entityTypeReference' => 'entityTypeReference',
        'entityReferences' => 'entityReferences',
        'previousMigration' => 'previousMigration',
        'initialSetup' => 'initialSetup',
        'changedAfter' => 'changedAfter',
        'dryRun' => 'dryRun',
        'skipSyndication' => 'skipSyndication',
        'skipOptimization' => 'skipOptimization',
        'flowMachineName' => 'flowMachineName',
        'runInOrder' => 'runInOrder',
        'priority' => 'priority',
        'entityTypeVersion' => 'entityTypeVersion',
        'entityType' => 'entityType',
        'entities' => 'entities',
        'status' => 'status',
        'customer' => 'customer',
        'site' => 'site',
        'project' => 'project',
        'flow' => 'flow',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'entityTypeReference' => 'setEntityTypeReference',
        'entityReferences' => 'setEntityReferences',
        'previousMigration' => 'setPreviousMigration',
        'initialSetup' => 'setInitialSetup',
        'changedAfter' => 'setChangedAfter',
        'dryRun' => 'setDryRun',
        'skipSyndication' => 'setSkipSyndication',
        'skipOptimization' => 'setSkipOptimization',
        'flowMachineName' => 'setFlowMachineName',
        'runInOrder' => 'setRunInOrder',
        'priority' => 'setPriority',
        'entityTypeVersion' => 'setEntityTypeVersion',
        'entityType' => 'setEntityType',
        'entities' => 'setEntities',
        'status' => 'setStatus',
        'customer' => 'setCustomer',
        'site' => 'setSite',
        'project' => 'setProject',
        'flow' => 'setFlow',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'entityTypeReference' => 'getEntityTypeReference',
        'entityReferences' => 'getEntityReferences',
        'previousMigration' => 'getPreviousMigration',
        'initialSetup' => 'getInitialSetup',
        'changedAfter' => 'getChangedAfter',
        'dryRun' => 'getDryRun',
        'skipSyndication' => 'getSkipSyndication',
        'skipOptimization' => 'getSkipOptimization',
        'flowMachineName' => 'getFlowMachineName',
        'runInOrder' => 'getRunInOrder',
        'priority' => 'getPriority',
        'entityTypeVersion' => 'getEntityTypeVersion',
        'entityType' => 'getEntityType',
        'entities' => 'getEntities',
        'status' => 'getStatus',
        'customer' => 'getCustomer',
        'site' => 'getSite',
        'project' => 'getProject',
        'flow' => 'getFlow',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('entityTypeReference', $data ?? [], null);
        $this->setIfExists('entityReferences', $data ?? [], null);
        $this->setIfExists('previousMigration', $data ?? [], null);
        $this->setIfExists('initialSetup', $data ?? [], null);
        $this->setIfExists('changedAfter', $data ?? [], null);
        $this->setIfExists('dryRun', $data ?? [], null);
        $this->setIfExists('skipSyndication', $data ?? [], null);
        $this->setIfExists('skipOptimization', $data ?? [], null);
        $this->setIfExists('flowMachineName', $data ?? [], null);
        $this->setIfExists('runInOrder', $data ?? [], null);
        $this->setIfExists('priority', $data ?? [], null);
        $this->setIfExists('entityTypeVersion', $data ?? [], null);
        $this->setIfExists('entityType', $data ?? [], null);
        $this->setIfExists('entities', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('site', $data ?? [], null);
        $this->setIfExists('project', $data ?? [], null);
        $this->setIfExists('flow', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['type']) {
            $invalidProperties[] = "'type' can't be null";
        }
        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['site']) {
            $invalidProperties[] = "'site' can't be null";
        }
        if (null === $this->container['project']) {
            $invalidProperties[] = "'project' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets type.
     *
     * @return MigrationType
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type.
     *
     * @param MigrationType $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets entityTypeReference.
     *
     * @return null|EntityTypeVersionReference
     */
    public function getEntityTypeReference()
    {
        return $this->container['entityTypeReference'];
    }

    /**
     * Sets entityTypeReference.
     *
     * @param null|EntityTypeVersionReference $entityTypeReference entityTypeReference
     *
     * @return self
     */
    public function setEntityTypeReference($entityTypeReference)
    {
        if (is_null($entityTypeReference)) {
            array_push($this->openAPINullablesSetToNull, 'entityTypeReference');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityTypeReference', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityTypeReference'] = $entityTypeReference;

        return $this;
    }

    /**
     * Gets entityReferences.
     *
     * @return null|RemoteEntitySummary[]
     */
    public function getEntityReferences()
    {
        return $this->container['entityReferences'];
    }

    /**
     * Sets entityReferences.
     *
     * @param null|RemoteEntitySummary[] $entityReferences entityReferences
     *
     * @return self
     */
    public function setEntityReferences($entityReferences)
    {
        if (is_null($entityReferences)) {
            array_push($this->openAPINullablesSetToNull, 'entityReferences');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityReferences', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityReferences'] = $entityReferences;

        return $this;
    }

    /**
     * Gets previousMigration.
     *
     * @return null|DynamicReference
     */
    public function getPreviousMigration()
    {
        return $this->container['previousMigration'];
    }

    /**
     * Sets previousMigration.
     *
     * @param null|DynamicReference $previousMigration previousMigration
     *
     * @return self
     */
    public function setPreviousMigration($previousMigration)
    {
        if (is_null($previousMigration)) {
            array_push($this->openAPINullablesSetToNull, 'previousMigration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('previousMigration', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['previousMigration'] = $previousMigration;

        return $this;
    }

    /**
     * Gets initialSetup.
     *
     * @return null|bool
     */
    public function getInitialSetup()
    {
        return $this->container['initialSetup'];
    }

    /**
     * Sets initialSetup.
     *
     * @param null|bool $initialSetup initialSetup
     *
     * @return self
     */
    public function setInitialSetup($initialSetup)
    {
        if (is_null($initialSetup)) {
            array_push($this->openAPINullablesSetToNull, 'initialSetup');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('initialSetup', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['initialSetup'] = $initialSetup;

        return $this;
    }

    /**
     * Gets changedAfter.
     *
     * @return null|float
     */
    public function getChangedAfter()
    {
        return $this->container['changedAfter'];
    }

    /**
     * Sets changedAfter.
     *
     * @param null|float $changedAfter changedAfter
     *
     * @return self
     */
    public function setChangedAfter($changedAfter)
    {
        if (is_null($changedAfter)) {
            array_push($this->openAPINullablesSetToNull, 'changedAfter');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('changedAfter', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['changedAfter'] = $changedAfter;

        return $this;
    }

    /**
     * Gets dryRun.
     *
     * @return null|bool
     */
    public function getDryRun()
    {
        return $this->container['dryRun'];
    }

    /**
     * Sets dryRun.
     *
     * @param null|bool $dryRun dryRun
     *
     * @return self
     */
    public function setDryRun($dryRun)
    {
        if (is_null($dryRun)) {
            array_push($this->openAPINullablesSetToNull, 'dryRun');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dryRun', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dryRun'] = $dryRun;

        return $this;
    }

    /**
     * Gets skipSyndication.
     *
     * @return null|bool
     */
    public function getSkipSyndication()
    {
        return $this->container['skipSyndication'];
    }

    /**
     * Sets skipSyndication.
     *
     * @param null|bool $skipSyndication skipSyndication
     *
     * @return self
     */
    public function setSkipSyndication($skipSyndication)
    {
        if (is_null($skipSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'skipSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipSyndication'] = $skipSyndication;

        return $this;
    }

    /**
     * Gets skipOptimization.
     *
     * @return null|bool
     */
    public function getSkipOptimization()
    {
        return $this->container['skipOptimization'];
    }

    /**
     * Sets skipOptimization.
     *
     * @param null|bool $skipOptimization skipOptimization
     *
     * @return self
     */
    public function setSkipOptimization($skipOptimization)
    {
        if (is_null($skipOptimization)) {
            array_push($this->openAPINullablesSetToNull, 'skipOptimization');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipOptimization', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipOptimization'] = $skipOptimization;

        return $this;
    }

    /**
     * Gets flowMachineName.
     *
     * @return null|string
     */
    public function getFlowMachineName()
    {
        return $this->container['flowMachineName'];
    }

    /**
     * Sets flowMachineName.
     *
     * @param null|string $flowMachineName flowMachineName
     *
     * @return self
     */
    public function setFlowMachineName($flowMachineName)
    {
        if (is_null($flowMachineName)) {
            array_push($this->openAPINullablesSetToNull, 'flowMachineName');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flowMachineName', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flowMachineName'] = $flowMachineName;

        return $this;
    }

    /**
     * Gets runInOrder.
     *
     * @return null|bool
     */
    public function getRunInOrder()
    {
        return $this->container['runInOrder'];
    }

    /**
     * Sets runInOrder.
     *
     * @param null|bool $runInOrder runInOrder
     *
     * @return self
     */
    public function setRunInOrder($runInOrder)
    {
        if (is_null($runInOrder)) {
            array_push($this->openAPINullablesSetToNull, 'runInOrder');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('runInOrder', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['runInOrder'] = $runInOrder;

        return $this;
    }

    /**
     * Gets priority.
     *
     * @return null|float
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority.
     *
     * @param null|float $priority priority
     *
     * @return self
     */
    public function setPriority($priority)
    {
        if (is_null($priority)) {
            array_push($this->openAPINullablesSetToNull, 'priority');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('priority', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets entityTypeVersion.
     *
     * @return null|DynamicReference
     */
    public function getEntityTypeVersion()
    {
        return $this->container['entityTypeVersion'];
    }

    /**
     * Sets entityTypeVersion.
     *
     * @param null|DynamicReference $entityTypeVersion entityTypeVersion
     *
     * @return self
     */
    public function setEntityTypeVersion($entityTypeVersion)
    {
        if (is_null($entityTypeVersion)) {
            array_push($this->openAPINullablesSetToNull, 'entityTypeVersion');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityTypeVersion', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityTypeVersion'] = $entityTypeVersion;

        return $this;
    }

    /**
     * Gets entityType.
     *
     * @return null|DynamicReference
     */
    public function getEntityType()
    {
        return $this->container['entityType'];
    }

    /**
     * Sets entityType.
     *
     * @param null|DynamicReference $entityType entityType
     *
     * @return self
     */
    public function setEntityType($entityType)
    {
        if (is_null($entityType)) {
            array_push($this->openAPINullablesSetToNull, 'entityType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityType'] = $entityType;

        return $this;
    }

    /**
     * Gets entities.
     *
     * @return null|DynamicReference[]
     */
    public function getEntities()
    {
        return $this->container['entities'];
    }

    /**
     * Sets entities.
     *
     * @param null|DynamicReference[] $entities entities
     *
     * @return self
     */
    public function setEntities($entities)
    {
        if (is_null($entities)) {
            array_push($this->openAPINullablesSetToNull, 'entities');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entities', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entities'] = $entities;

        return $this;
    }

    /**
     * Gets status.
     *
     * @return SyndicationStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param SyndicationStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets site.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $site site
     *
     * @return self
     */
    public function setSite($site)
    {
        if (is_null($site)) {
            throw new \InvalidArgumentException('non-nullable site cannot be null');
        }
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets project.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getProject()
    {
        return $this->container['project'];
    }

    /**
     * Sets project.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $project project
     *
     * @return self
     */
    public function setProject($project)
    {
        if (is_null($project)) {
            throw new \InvalidArgumentException('non-nullable project cannot be null');
        }
        $this->container['project'] = $project;

        return $this;
    }

    /**
     * Gets flow.
     *
     * @return null|DynamicReference
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow.
     *
     * @param null|DynamicReference $flow flow
     *
     * @return self
     */
    public function setFlow($flow)
    {
        if (is_null($flow)) {
            array_push($this->openAPINullablesSetToNull, 'flow');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flow', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
