<?php

/**
 * LoggingIdsRequest.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * LoggingIdsRequest Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class LoggingIdsRequest implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'LoggingIdsRequest';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'customerUuid' => 'string',
        'contractUuid' => 'string',
        'contractRevisionUuid' => 'string',
        'projectUuid' => 'string',
        'siteUuid' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'customerUuid' => null,
        'contractUuid' => null,
        'contractRevisionUuid' => null,
        'projectUuid' => null,
        'siteUuid' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'customerUuid' => true,
        'contractUuid' => true,
        'contractRevisionUuid' => true,
        'projectUuid' => true,
        'siteUuid' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customerUuid' => 'customerUuid',
        'contractUuid' => 'contractUuid',
        'contractRevisionUuid' => 'contractRevisionUuid',
        'projectUuid' => 'projectUuid',
        'siteUuid' => 'siteUuid',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'customerUuid' => 'setCustomerUuid',
        'contractUuid' => 'setContractUuid',
        'contractRevisionUuid' => 'setContractRevisionUuid',
        'projectUuid' => 'setProjectUuid',
        'siteUuid' => 'setSiteUuid',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'customerUuid' => 'getCustomerUuid',
        'contractUuid' => 'getContractUuid',
        'contractRevisionUuid' => 'getContractRevisionUuid',
        'projectUuid' => 'getProjectUuid',
        'siteUuid' => 'getSiteUuid',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customerUuid', $data ?? [], null);
        $this->setIfExists('contractUuid', $data ?? [], null);
        $this->setIfExists('contractRevisionUuid', $data ?? [], null);
        $this->setIfExists('projectUuid', $data ?? [], null);
        $this->setIfExists('siteUuid', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        return [];
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets customerUuid.
     *
     * @return null|string
     */
    public function getCustomerUuid()
    {
        return $this->container['customerUuid'];
    }

    /**
     * Sets customerUuid.
     *
     * @param null|string $customerUuid customerUuid
     *
     * @return self
     */
    public function setCustomerUuid($customerUuid)
    {
        if (is_null($customerUuid)) {
            array_push($this->openAPINullablesSetToNull, 'customerUuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customerUuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customerUuid'] = $customerUuid;

        return $this;
    }

    /**
     * Gets contractUuid.
     *
     * @return null|string
     */
    public function getContractUuid()
    {
        return $this->container['contractUuid'];
    }

    /**
     * Sets contractUuid.
     *
     * @param null|string $contractUuid contractUuid
     *
     * @return self
     */
    public function setContractUuid($contractUuid)
    {
        if (is_null($contractUuid)) {
            array_push($this->openAPINullablesSetToNull, 'contractUuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('contractUuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['contractUuid'] = $contractUuid;

        return $this;
    }

    /**
     * Gets contractRevisionUuid.
     *
     * @return null|string
     */
    public function getContractRevisionUuid()
    {
        return $this->container['contractRevisionUuid'];
    }

    /**
     * Sets contractRevisionUuid.
     *
     * @param null|string $contractRevisionUuid contractRevisionUuid
     *
     * @return self
     */
    public function setContractRevisionUuid($contractRevisionUuid)
    {
        if (is_null($contractRevisionUuid)) {
            array_push($this->openAPINullablesSetToNull, 'contractRevisionUuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('contractRevisionUuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['contractRevisionUuid'] = $contractRevisionUuid;

        return $this;
    }

    /**
     * Gets projectUuid.
     *
     * @return null|string
     */
    public function getProjectUuid()
    {
        return $this->container['projectUuid'];
    }

    /**
     * Sets projectUuid.
     *
     * @param null|string $projectUuid projectUuid
     *
     * @return self
     */
    public function setProjectUuid($projectUuid)
    {
        if (is_null($projectUuid)) {
            array_push($this->openAPINullablesSetToNull, 'projectUuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('projectUuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['projectUuid'] = $projectUuid;

        return $this;
    }

    /**
     * Gets siteUuid.
     *
     * @return null|string
     */
    public function getSiteUuid()
    {
        return $this->container['siteUuid'];
    }

    /**
     * Sets siteUuid.
     *
     * @param null|string $siteUuid siteUuid
     *
     * @return self
     */
    public function setSiteUuid($siteUuid)
    {
        if (is_null($siteUuid)) {
            array_push($this->openAPINullablesSetToNull, 'siteUuid');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('siteUuid', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['siteUuid'] = $siteUuid;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
