<?php

/**
 * FileEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * FileEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class FileEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'FileEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'type' => 'FileType',
        'fileName' => 'string',
        'remoteFilePath' => 'string',
        'remoteDownloadUrl' => 'string',
        'hash' => 'string',
        'uploadUrl' => 'string',
        'downloadUrl' => 'string',
        'mimeType' => 'string',
        'fileSize' => 'float',
        'maxFileSize' => 'float',
        'status' => 'FileStatus',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'site' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'project' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'entity' => 'DynamicReference',
        'flow' => 'DynamicReference',
        'syndication' => 'DynamicReference',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
        'requestId' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'type' => null,
        'fileName' => null,
        'remoteFilePath' => null,
        'remoteDownloadUrl' => null,
        'hash' => null,
        'uploadUrl' => null,
        'downloadUrl' => null,
        'mimeType' => null,
        'fileSize' => null,
        'maxFileSize' => null,
        'status' => null,
        'customer' => null,
        'site' => null,
        'project' => null,
        'entity' => null,
        'flow' => null,
        'syndication' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
        'requestId' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'type' => false,
        'fileName' => false,
        'remoteFilePath' => true,
        'remoteDownloadUrl' => true,
        'hash' => true,
        'uploadUrl' => true,
        'downloadUrl' => true,
        'mimeType' => false,
        'fileSize' => false,
        'maxFileSize' => true,
        'status' => false,
        'customer' => false,
        'site' => false,
        'project' => false,
        'entity' => true,
        'flow' => true,
        'syndication' => true,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
        'requestId' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'fileName' => 'fileName',
        'remoteFilePath' => 'remoteFilePath',
        'remoteDownloadUrl' => 'remoteDownloadUrl',
        'hash' => 'hash',
        'uploadUrl' => 'uploadUrl',
        'downloadUrl' => 'downloadUrl',
        'mimeType' => 'mimeType',
        'fileSize' => 'fileSize',
        'maxFileSize' => 'maxFileSize',
        'status' => 'status',
        'customer' => 'customer',
        'site' => 'site',
        'project' => 'project',
        'entity' => 'entity',
        'flow' => 'flow',
        'syndication' => 'syndication',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
        'requestId' => 'requestId',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'fileName' => 'setFileName',
        'remoteFilePath' => 'setRemoteFilePath',
        'remoteDownloadUrl' => 'setRemoteDownloadUrl',
        'hash' => 'setHash',
        'uploadUrl' => 'setUploadUrl',
        'downloadUrl' => 'setDownloadUrl',
        'mimeType' => 'setMimeType',
        'fileSize' => 'setFileSize',
        'maxFileSize' => 'setMaxFileSize',
        'status' => 'setStatus',
        'customer' => 'setCustomer',
        'site' => 'setSite',
        'project' => 'setProject',
        'entity' => 'setEntity',
        'flow' => 'setFlow',
        'syndication' => 'setSyndication',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
        'requestId' => 'setRequestId',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'fileName' => 'getFileName',
        'remoteFilePath' => 'getRemoteFilePath',
        'remoteDownloadUrl' => 'getRemoteDownloadUrl',
        'hash' => 'getHash',
        'uploadUrl' => 'getUploadUrl',
        'downloadUrl' => 'getDownloadUrl',
        'mimeType' => 'getMimeType',
        'fileSize' => 'getFileSize',
        'maxFileSize' => 'getMaxFileSize',
        'status' => 'getStatus',
        'customer' => 'getCustomer',
        'site' => 'getSite',
        'project' => 'getProject',
        'entity' => 'getEntity',
        'flow' => 'getFlow',
        'syndication' => 'getSyndication',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
        'requestId' => 'getRequestId',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('fileName', $data ?? [], null);
        $this->setIfExists('remoteFilePath', $data ?? [], null);
        $this->setIfExists('remoteDownloadUrl', $data ?? [], null);
        $this->setIfExists('hash', $data ?? [], null);
        $this->setIfExists('uploadUrl', $data ?? [], null);
        $this->setIfExists('downloadUrl', $data ?? [], null);
        $this->setIfExists('mimeType', $data ?? [], null);
        $this->setIfExists('fileSize', $data ?? [], null);
        $this->setIfExists('maxFileSize', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('site', $data ?? [], null);
        $this->setIfExists('project', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('flow', $data ?? [], null);
        $this->setIfExists('syndication', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
        $this->setIfExists('requestId', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['type']) {
            $invalidProperties[] = "'type' can't be null";
        }
        if (null === $this->container['fileName']) {
            $invalidProperties[] = "'fileName' can't be null";
        }
        if (null === $this->container['mimeType']) {
            $invalidProperties[] = "'mimeType' can't be null";
        }
        if (null === $this->container['fileSize']) {
            $invalidProperties[] = "'fileSize' can't be null";
        }
        if (null === $this->container['status']) {
            $invalidProperties[] = "'status' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['site']) {
            $invalidProperties[] = "'site' can't be null";
        }
        if (null === $this->container['project']) {
            $invalidProperties[] = "'project' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets type.
     *
     * @return FileType
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type.
     *
     * @param FileType $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets fileName.
     *
     * @return string
     */
    public function getFileName()
    {
        return $this->container['fileName'];
    }

    /**
     * Sets fileName.
     *
     * @param string $fileName fileName
     *
     * @return self
     */
    public function setFileName($fileName)
    {
        if (is_null($fileName)) {
            throw new \InvalidArgumentException('non-nullable fileName cannot be null');
        }
        $this->container['fileName'] = $fileName;

        return $this;
    }

    /**
     * Gets remoteFilePath.
     *
     * @return null|string
     */
    public function getRemoteFilePath()
    {
        return $this->container['remoteFilePath'];
    }

    /**
     * Sets remoteFilePath.
     *
     * @param null|string $remoteFilePath remoteFilePath
     *
     * @return self
     */
    public function setRemoteFilePath($remoteFilePath)
    {
        if (is_null($remoteFilePath)) {
            array_push($this->openAPINullablesSetToNull, 'remoteFilePath');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('remoteFilePath', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['remoteFilePath'] = $remoteFilePath;

        return $this;
    }

    /**
     * Gets remoteDownloadUrl.
     *
     * @return null|string
     */
    public function getRemoteDownloadUrl()
    {
        return $this->container['remoteDownloadUrl'];
    }

    /**
     * Sets remoteDownloadUrl.
     *
     * @param null|string $remoteDownloadUrl remoteDownloadUrl
     *
     * @return self
     */
    public function setRemoteDownloadUrl($remoteDownloadUrl)
    {
        if (is_null($remoteDownloadUrl)) {
            array_push($this->openAPINullablesSetToNull, 'remoteDownloadUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('remoteDownloadUrl', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['remoteDownloadUrl'] = $remoteDownloadUrl;

        return $this;
    }

    /**
     * Gets hash.
     *
     * @return null|string
     */
    public function getHash()
    {
        return $this->container['hash'];
    }

    /**
     * Sets hash.
     *
     * @param null|string $hash hash
     *
     * @return self
     */
    public function setHash($hash)
    {
        if (is_null($hash)) {
            array_push($this->openAPINullablesSetToNull, 'hash');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('hash', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['hash'] = $hash;

        return $this;
    }

    /**
     * Gets uploadUrl.
     *
     * @return null|string
     */
    public function getUploadUrl()
    {
        return $this->container['uploadUrl'];
    }

    /**
     * Sets uploadUrl.
     *
     * @param null|string $uploadUrl uploadUrl
     *
     * @return self
     */
    public function setUploadUrl($uploadUrl)
    {
        if (is_null($uploadUrl)) {
            array_push($this->openAPINullablesSetToNull, 'uploadUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('uploadUrl', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['uploadUrl'] = $uploadUrl;

        return $this;
    }

    /**
     * Gets downloadUrl.
     *
     * @return null|string
     */
    public function getDownloadUrl()
    {
        return $this->container['downloadUrl'];
    }

    /**
     * Sets downloadUrl.
     *
     * @param null|string $downloadUrl downloadUrl
     *
     * @return self
     */
    public function setDownloadUrl($downloadUrl)
    {
        if (is_null($downloadUrl)) {
            array_push($this->openAPINullablesSetToNull, 'downloadUrl');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('downloadUrl', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['downloadUrl'] = $downloadUrl;

        return $this;
    }

    /**
     * Gets mimeType.
     *
     * @return string
     */
    public function getMimeType()
    {
        return $this->container['mimeType'];
    }

    /**
     * Sets mimeType.
     *
     * @param string $mimeType mimeType
     *
     * @return self
     */
    public function setMimeType($mimeType)
    {
        if (is_null($mimeType)) {
            throw new \InvalidArgumentException('non-nullable mimeType cannot be null');
        }
        $this->container['mimeType'] = $mimeType;

        return $this;
    }

    /**
     * Gets fileSize.
     *
     * @return float
     */
    public function getFileSize()
    {
        return $this->container['fileSize'];
    }

    /**
     * Sets fileSize.
     *
     * @param float $fileSize fileSize
     *
     * @return self
     */
    public function setFileSize($fileSize)
    {
        if (is_null($fileSize)) {
            throw new \InvalidArgumentException('non-nullable fileSize cannot be null');
        }
        $this->container['fileSize'] = $fileSize;

        return $this;
    }

    /**
     * Gets maxFileSize.
     *
     * @return null|float
     */
    public function getMaxFileSize()
    {
        return $this->container['maxFileSize'];
    }

    /**
     * Sets maxFileSize.
     *
     * @param null|float $maxFileSize maxFileSize
     *
     * @return self
     */
    public function setMaxFileSize($maxFileSize)
    {
        if (is_null($maxFileSize)) {
            array_push($this->openAPINullablesSetToNull, 'maxFileSize');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxFileSize', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxFileSize'] = $maxFileSize;

        return $this;
    }

    /**
     * Gets status.
     *
     * @return FileStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status.
     *
     * @param FileStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets site.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $site site
     *
     * @return self
     */
    public function setSite($site)
    {
        if (is_null($site)) {
            throw new \InvalidArgumentException('non-nullable site cannot be null');
        }
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets project.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getProject()
    {
        return $this->container['project'];
    }

    /**
     * Sets project.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $project project
     *
     * @return self
     */
    public function setProject($project)
    {
        if (is_null($project)) {
            throw new \InvalidArgumentException('non-nullable project cannot be null');
        }
        $this->container['project'] = $project;

        return $this;
    }

    /**
     * Gets entity.
     *
     * @return null|DynamicReference
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity.
     *
     * @param null|DynamicReference $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            array_push($this->openAPINullablesSetToNull, 'entity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entity', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets flow.
     *
     * @return null|DynamicReference
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow.
     *
     * @param null|DynamicReference $flow flow
     *
     * @return self
     */
    public function setFlow($flow)
    {
        if (is_null($flow)) {
            array_push($this->openAPINullablesSetToNull, 'flow');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flow', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets syndication.
     *
     * @return null|DynamicReference
     */
    public function getSyndication()
    {
        return $this->container['syndication'];
    }

    /**
     * Sets syndication.
     *
     * @param null|DynamicReference $syndication syndication
     *
     * @return self
     */
    public function setSyndication($syndication)
    {
        if (is_null($syndication)) {
            array_push($this->openAPINullablesSetToNull, 'syndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('syndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['syndication'] = $syndication;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Gets requestId.
     *
     * @return null|string
     */
    public function getRequestId()
    {
        return $this->container['requestId'];
    }

    /**
     * Sets requestId.
     *
     * @param null|string $requestId requestId
     *
     * @return self
     */
    public function setRequestId($requestId)
    {
        if (is_null($requestId)) {
            array_push($this->openAPINullablesSetToNull, 'requestId');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('requestId', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['requestId'] = $requestId;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
