<?php

/**
 * CreateMigrationDto.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * CreateMigrationDto Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class CreateMigrationDto implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'CreateMigrationDto';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'type' => 'MigrationType',
        'entityTypeReference' => 'EntityTypeVersionReference',
        'entityReferences' => '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntitySummary[]',
        'previousMigration' => 'DynamicReference',
        'initialSetup' => 'bool',
        'changedAfter' => 'float',
        'dryRun' => 'bool',
        'skipSyndication' => 'bool',
        'skipOptimization' => 'bool',
        'flowMachineName' => 'string',
        'runInOrder' => 'bool',
        'priority' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'type' => null,
        'entityTypeReference' => null,
        'entityReferences' => null,
        'previousMigration' => null,
        'initialSetup' => null,
        'changedAfter' => null,
        'dryRun' => null,
        'skipSyndication' => null,
        'skipOptimization' => null,
        'flowMachineName' => null,
        'runInOrder' => null,
        'priority' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'type' => false,
        'entityTypeReference' => true,
        'entityReferences' => true,
        'previousMigration' => true,
        'initialSetup' => true,
        'changedAfter' => true,
        'dryRun' => true,
        'skipSyndication' => true,
        'skipOptimization' => true,
        'flowMachineName' => true,
        'runInOrder' => true,
        'priority' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'entityTypeReference' => 'entityTypeReference',
        'entityReferences' => 'entityReferences',
        'previousMigration' => 'previousMigration',
        'initialSetup' => 'initialSetup',
        'changedAfter' => 'changedAfter',
        'dryRun' => 'dryRun',
        'skipSyndication' => 'skipSyndication',
        'skipOptimization' => 'skipOptimization',
        'flowMachineName' => 'flowMachineName',
        'runInOrder' => 'runInOrder',
        'priority' => 'priority',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'entityTypeReference' => 'setEntityTypeReference',
        'entityReferences' => 'setEntityReferences',
        'previousMigration' => 'setPreviousMigration',
        'initialSetup' => 'setInitialSetup',
        'changedAfter' => 'setChangedAfter',
        'dryRun' => 'setDryRun',
        'skipSyndication' => 'setSkipSyndication',
        'skipOptimization' => 'setSkipOptimization',
        'flowMachineName' => 'setFlowMachineName',
        'runInOrder' => 'setRunInOrder',
        'priority' => 'setPriority',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'entityTypeReference' => 'getEntityTypeReference',
        'entityReferences' => 'getEntityReferences',
        'previousMigration' => 'getPreviousMigration',
        'initialSetup' => 'getInitialSetup',
        'changedAfter' => 'getChangedAfter',
        'dryRun' => 'getDryRun',
        'skipSyndication' => 'getSkipSyndication',
        'skipOptimization' => 'getSkipOptimization',
        'flowMachineName' => 'getFlowMachineName',
        'runInOrder' => 'getRunInOrder',
        'priority' => 'getPriority',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('entityTypeReference', $data ?? [], null);
        $this->setIfExists('entityReferences', $data ?? [], null);
        $this->setIfExists('previousMigration', $data ?? [], null);
        $this->setIfExists('initialSetup', $data ?? [], null);
        $this->setIfExists('changedAfter', $data ?? [], null);
        $this->setIfExists('dryRun', $data ?? [], null);
        $this->setIfExists('skipSyndication', $data ?? [], null);
        $this->setIfExists('skipOptimization', $data ?? [], null);
        $this->setIfExists('flowMachineName', $data ?? [], null);
        $this->setIfExists('runInOrder', $data ?? [], null);
        $this->setIfExists('priority', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['type']) {
            $invalidProperties[] = "'type' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets type.
     *
     * @return MigrationType
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type.
     *
     * @param MigrationType $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets entityTypeReference.
     *
     * @return null|EntityTypeVersionReference
     */
    public function getEntityTypeReference()
    {
        return $this->container['entityTypeReference'];
    }

    /**
     * Sets entityTypeReference.
     *
     * @param null|EntityTypeVersionReference $entityTypeReference entityTypeReference
     *
     * @return self
     */
    public function setEntityTypeReference($entityTypeReference)
    {
        if (is_null($entityTypeReference)) {
            array_push($this->openAPINullablesSetToNull, 'entityTypeReference');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityTypeReference', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityTypeReference'] = $entityTypeReference;

        return $this;
    }

    /**
     * Gets entityReferences.
     *
     * @return null|RemoteEntitySummary[]
     */
    public function getEntityReferences()
    {
        return $this->container['entityReferences'];
    }

    /**
     * Sets entityReferences.
     *
     * @param null|RemoteEntitySummary[] $entityReferences entityReferences
     *
     * @return self
     */
    public function setEntityReferences($entityReferences)
    {
        if (is_null($entityReferences)) {
            array_push($this->openAPINullablesSetToNull, 'entityReferences');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('entityReferences', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['entityReferences'] = $entityReferences;

        return $this;
    }

    /**
     * Gets previousMigration.
     *
     * @return null|DynamicReference
     */
    public function getPreviousMigration()
    {
        return $this->container['previousMigration'];
    }

    /**
     * Sets previousMigration.
     *
     * @param null|DynamicReference $previousMigration previousMigration
     *
     * @return self
     */
    public function setPreviousMigration($previousMigration)
    {
        if (is_null($previousMigration)) {
            array_push($this->openAPINullablesSetToNull, 'previousMigration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('previousMigration', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['previousMigration'] = $previousMigration;

        return $this;
    }

    /**
     * Gets initialSetup.
     *
     * @return null|bool
     */
    public function getInitialSetup()
    {
        return $this->container['initialSetup'];
    }

    /**
     * Sets initialSetup.
     *
     * @param null|bool $initialSetup initialSetup
     *
     * @return self
     */
    public function setInitialSetup($initialSetup)
    {
        if (is_null($initialSetup)) {
            array_push($this->openAPINullablesSetToNull, 'initialSetup');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('initialSetup', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['initialSetup'] = $initialSetup;

        return $this;
    }

    /**
     * Gets changedAfter.
     *
     * @return null|float
     */
    public function getChangedAfter()
    {
        return $this->container['changedAfter'];
    }

    /**
     * Sets changedAfter.
     *
     * @param null|float $changedAfter changedAfter
     *
     * @return self
     */
    public function setChangedAfter($changedAfter)
    {
        if (is_null($changedAfter)) {
            array_push($this->openAPINullablesSetToNull, 'changedAfter');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('changedAfter', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['changedAfter'] = $changedAfter;

        return $this;
    }

    /**
     * Gets dryRun.
     *
     * @return null|bool
     */
    public function getDryRun()
    {
        return $this->container['dryRun'];
    }

    /**
     * Sets dryRun.
     *
     * @param null|bool $dryRun dryRun
     *
     * @return self
     */
    public function setDryRun($dryRun)
    {
        if (is_null($dryRun)) {
            array_push($this->openAPINullablesSetToNull, 'dryRun');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dryRun', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dryRun'] = $dryRun;

        return $this;
    }

    /**
     * Gets skipSyndication.
     *
     * @return null|bool
     */
    public function getSkipSyndication()
    {
        return $this->container['skipSyndication'];
    }

    /**
     * Sets skipSyndication.
     *
     * @param null|bool $skipSyndication skipSyndication
     *
     * @return self
     */
    public function setSkipSyndication($skipSyndication)
    {
        if (is_null($skipSyndication)) {
            array_push($this->openAPINullablesSetToNull, 'skipSyndication');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipSyndication', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipSyndication'] = $skipSyndication;

        return $this;
    }

    /**
     * Gets skipOptimization.
     *
     * @return null|bool
     */
    public function getSkipOptimization()
    {
        return $this->container['skipOptimization'];
    }

    /**
     * Sets skipOptimization.
     *
     * @param null|bool $skipOptimization skipOptimization
     *
     * @return self
     */
    public function setSkipOptimization($skipOptimization)
    {
        if (is_null($skipOptimization)) {
            array_push($this->openAPINullablesSetToNull, 'skipOptimization');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('skipOptimization', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['skipOptimization'] = $skipOptimization;

        return $this;
    }

    /**
     * Gets flowMachineName.
     *
     * @return null|string
     */
    public function getFlowMachineName()
    {
        return $this->container['flowMachineName'];
    }

    /**
     * Sets flowMachineName.
     *
     * @param null|string $flowMachineName flowMachineName
     *
     * @return self
     */
    public function setFlowMachineName($flowMachineName)
    {
        if (is_null($flowMachineName)) {
            array_push($this->openAPINullablesSetToNull, 'flowMachineName');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('flowMachineName', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['flowMachineName'] = $flowMachineName;

        return $this;
    }

    /**
     * Gets runInOrder.
     *
     * @return null|bool
     */
    public function getRunInOrder()
    {
        return $this->container['runInOrder'];
    }

    /**
     * Sets runInOrder.
     *
     * @param null|bool $runInOrder runInOrder
     *
     * @return self
     */
    public function setRunInOrder($runInOrder)
    {
        if (is_null($runInOrder)) {
            array_push($this->openAPINullablesSetToNull, 'runInOrder');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('runInOrder', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['runInOrder'] = $runInOrder;

        return $this;
    }

    /**
     * Gets priority.
     *
     * @return null|float
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority.
     *
     * @param null|float $priority priority
     *
     * @return self
     */
    public function setPriority($priority)
    {
        if (is_null($priority)) {
            array_push($this->openAPINullablesSetToNull, 'priority');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('priority', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
