<?php

/**
 * ContractRevisionEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * ContractRevisionEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class ContractRevisionEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'ContractRevisionEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'hostingType' => 'ContractType',
        'product' => 'Product',
        'packageType' => 'Package',
        'revisionTransition' => 'ContractRevisionTransition',
        'maxUpdatesPerMonth' => 'float',
        'maxUpdatesDuringThisRevision' => 'float',
        'startDate' => 'float',
        'endDate' => 'float',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'contract' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'previousContractRevision' => 'DynamicReference',
        'uuid' => 'string',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'hostingType' => null,
        'product' => null,
        'packageType' => null,
        'revisionTransition' => null,
        'maxUpdatesPerMonth' => null,
        'maxUpdatesDuringThisRevision' => null,
        'startDate' => null,
        'endDate' => null,
        'customer' => null,
        'contract' => null,
        'previousContractRevision' => null,
        'uuid' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'hostingType' => false,
        'product' => false,
        'packageType' => false,
        'revisionTransition' => false,
        'maxUpdatesPerMonth' => true,
        'maxUpdatesDuringThisRevision' => true,
        'startDate' => false,
        'endDate' => false,
        'customer' => false,
        'contract' => false,
        'previousContractRevision' => true,
        'uuid' => false,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'hostingType' => 'hostingType',
        'product' => 'product',
        'packageType' => 'packageType',
        'revisionTransition' => 'revisionTransition',
        'maxUpdatesPerMonth' => 'maxUpdatesPerMonth',
        'maxUpdatesDuringThisRevision' => 'maxUpdatesDuringThisRevision',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'customer' => 'customer',
        'contract' => 'contract',
        'previousContractRevision' => 'previousContractRevision',
        'uuid' => 'uuid',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'hostingType' => 'setHostingType',
        'product' => 'setProduct',
        'packageType' => 'setPackageType',
        'revisionTransition' => 'setRevisionTransition',
        'maxUpdatesPerMonth' => 'setMaxUpdatesPerMonth',
        'maxUpdatesDuringThisRevision' => 'setMaxUpdatesDuringThisRevision',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'customer' => 'setCustomer',
        'contract' => 'setContract',
        'previousContractRevision' => 'setPreviousContractRevision',
        'uuid' => 'setUuid',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'hostingType' => 'getHostingType',
        'product' => 'getProduct',
        'packageType' => 'getPackageType',
        'revisionTransition' => 'getRevisionTransition',
        'maxUpdatesPerMonth' => 'getMaxUpdatesPerMonth',
        'maxUpdatesDuringThisRevision' => 'getMaxUpdatesDuringThisRevision',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'customer' => 'getCustomer',
        'contract' => 'getContract',
        'previousContractRevision' => 'getPreviousContractRevision',
        'uuid' => 'getUuid',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('hostingType', $data ?? [], null);
        $this->setIfExists('product', $data ?? [], null);
        $this->setIfExists('packageType', $data ?? [], null);
        $this->setIfExists('revisionTransition', $data ?? [], null);
        $this->setIfExists('maxUpdatesPerMonth', $data ?? [], null);
        $this->setIfExists('maxUpdatesDuringThisRevision', $data ?? [], null);
        $this->setIfExists('startDate', $data ?? [], null);
        $this->setIfExists('endDate', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('contract', $data ?? [], null);
        $this->setIfExists('previousContractRevision', $data ?? [], null);
        $this->setIfExists('uuid', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['hostingType']) {
            $invalidProperties[] = "'hostingType' can't be null";
        }
        if (null === $this->container['product']) {
            $invalidProperties[] = "'product' can't be null";
        }
        if (null === $this->container['packageType']) {
            $invalidProperties[] = "'packageType' can't be null";
        }
        if (null === $this->container['revisionTransition']) {
            $invalidProperties[] = "'revisionTransition' can't be null";
        }
        if (null === $this->container['startDate']) {
            $invalidProperties[] = "'startDate' can't be null";
        }
        if (null === $this->container['endDate']) {
            $invalidProperties[] = "'endDate' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['contract']) {
            $invalidProperties[] = "'contract' can't be null";
        }
        if (null === $this->container['uuid']) {
            $invalidProperties[] = "'uuid' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets hostingType.
     *
     * @return ContractType
     */
    public function getHostingType()
    {
        return $this->container['hostingType'];
    }

    /**
     * Sets hostingType.
     *
     * @param ContractType $hostingType hostingType
     *
     * @return self
     */
    public function setHostingType($hostingType)
    {
        if (is_null($hostingType)) {
            throw new \InvalidArgumentException('non-nullable hostingType cannot be null');
        }
        $this->container['hostingType'] = $hostingType;

        return $this;
    }

    /**
     * Gets product.
     *
     * @return Product
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product.
     *
     * @param Product $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        if (is_null($product)) {
            throw new \InvalidArgumentException('non-nullable product cannot be null');
        }
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets packageType.
     *
     * @return Package
     */
    public function getPackageType()
    {
        return $this->container['packageType'];
    }

    /**
     * Sets packageType.
     *
     * @param Package $packageType packageType
     *
     * @return self
     */
    public function setPackageType($packageType)
    {
        if (is_null($packageType)) {
            throw new \InvalidArgumentException('non-nullable packageType cannot be null');
        }
        $this->container['packageType'] = $packageType;

        return $this;
    }

    /**
     * Gets revisionTransition.
     *
     * @return ContractRevisionTransition
     */
    public function getRevisionTransition()
    {
        return $this->container['revisionTransition'];
    }

    /**
     * Sets revisionTransition.
     *
     * @param ContractRevisionTransition $revisionTransition revisionTransition
     *
     * @return self
     */
    public function setRevisionTransition($revisionTransition)
    {
        if (is_null($revisionTransition)) {
            throw new \InvalidArgumentException('non-nullable revisionTransition cannot be null');
        }
        $this->container['revisionTransition'] = $revisionTransition;

        return $this;
    }

    /**
     * Gets maxUpdatesPerMonth.
     *
     * @return null|float
     */
    public function getMaxUpdatesPerMonth()
    {
        return $this->container['maxUpdatesPerMonth'];
    }

    /**
     * Sets maxUpdatesPerMonth.
     *
     * @param null|float $maxUpdatesPerMonth maxUpdatesPerMonth
     *
     * @return self
     */
    public function setMaxUpdatesPerMonth($maxUpdatesPerMonth)
    {
        if (is_null($maxUpdatesPerMonth)) {
            array_push($this->openAPINullablesSetToNull, 'maxUpdatesPerMonth');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxUpdatesPerMonth', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxUpdatesPerMonth'] = $maxUpdatesPerMonth;

        return $this;
    }

    /**
     * Gets maxUpdatesDuringThisRevision.
     *
     * @return null|float
     */
    public function getMaxUpdatesDuringThisRevision()
    {
        return $this->container['maxUpdatesDuringThisRevision'];
    }

    /**
     * Sets maxUpdatesDuringThisRevision.
     *
     * @param null|float $maxUpdatesDuringThisRevision maxUpdatesDuringThisRevision
     *
     * @return self
     */
    public function setMaxUpdatesDuringThisRevision($maxUpdatesDuringThisRevision)
    {
        if (is_null($maxUpdatesDuringThisRevision)) {
            array_push($this->openAPINullablesSetToNull, 'maxUpdatesDuringThisRevision');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxUpdatesDuringThisRevision', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxUpdatesDuringThisRevision'] = $maxUpdatesDuringThisRevision;

        return $this;
    }

    /**
     * Gets startDate.
     *
     * @return float
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate.
     *
     * @param float $startDate startDate
     *
     * @return self
     */
    public function setStartDate($startDate)
    {
        if (is_null($startDate)) {
            throw new \InvalidArgumentException('non-nullable startDate cannot be null');
        }
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate.
     *
     * @return float
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate.
     *
     * @param float $endDate endDate
     *
     * @return self
     */
    public function setEndDate($endDate)
    {
        if (is_null($endDate)) {
            throw new \InvalidArgumentException('non-nullable endDate cannot be null');
        }
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets contract.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getContract()
    {
        return $this->container['contract'];
    }

    /**
     * Sets contract.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $contract contract
     *
     * @return self
     */
    public function setContract($contract)
    {
        if (is_null($contract)) {
            throw new \InvalidArgumentException('non-nullable contract cannot be null');
        }
        $this->container['contract'] = $contract;

        return $this;
    }

    /**
     * Gets previousContractRevision.
     *
     * @return null|DynamicReference
     */
    public function getPreviousContractRevision()
    {
        return $this->container['previousContractRevision'];
    }

    /**
     * Sets previousContractRevision.
     *
     * @param null|DynamicReference $previousContractRevision previousContractRevision
     *
     * @return self
     */
    public function setPreviousContractRevision($previousContractRevision)
    {
        if (is_null($previousContractRevision)) {
            array_push($this->openAPINullablesSetToNull, 'previousContractRevision');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('previousContractRevision', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['previousContractRevision'] = $previousContractRevision;

        return $this;
    }

    /**
     * Gets uuid.
     *
     * @return string
     */
    public function getUuid()
    {
        return $this->container['uuid'];
    }

    /**
     * Sets uuid.
     *
     * @param string $uuid uuid
     *
     * @return self
     */
    public function setUuid($uuid)
    {
        if (is_null($uuid)) {
            throw new \InvalidArgumentException('non-nullable uuid cannot be null');
        }
        $this->container['uuid'] = $uuid;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
