<?php

/**
 * ContractEntity.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Model;

use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;

/**
 * ContractEntity Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 *
 * @implements \ArrayAccess<string, mixed>
 */
class ContractEntity implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'ContractEntity';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'minProdSites' => 'float',
        'maxProdSites' => 'float',
        'licensedSites' => 'float',
        'currentProductionSites' => 'float',
        'currentStagingSites' => 'float',
        'currentTestingSites' => 'float',
        'autoScaleLicenses' => 'bool',
        'appType' => 'SiteApplicationType',
        'region' => 'SalesRegion',
        'currentProductionSiteDomains' => 'string[]',
        'licensedProductionSiteDomains' => 'string[]',
        'startDate' => 'float',
        'endDate' => 'float',
        'archived' => 'bool',
        'customer' => '\EdgeBox\SyncCore\V2\Raw\Model\RuntimeRemoteEntityDependencyWithDependenciesEntity',
        'uuid' => 'string',
        'id' => 'string',
        'createdAt' => 'float',
        'updatedAt' => 'float',
        'deletedAt' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static $openAPIFormats = [
        'minProdSites' => null,
        'maxProdSites' => null,
        'licensedSites' => null,
        'currentProductionSites' => null,
        'currentStagingSites' => null,
        'currentTestingSites' => null,
        'autoScaleLicenses' => null,
        'appType' => null,
        'region' => null,
        'currentProductionSiteDomains' => null,
        'licensedProductionSiteDomains' => null,
        'startDate' => null,
        'endDate' => null,
        'archived' => null,
        'customer' => null,
        'uuid' => null,
        'id' => null,
        'createdAt' => null,
        'updatedAt' => null,
        'deletedAt' => null,
    ];

    /**
     * Array of nullable properties. Used for (de)serialization.
     *
     * @var bool[]
     */
    protected static array $openAPINullables = [
        'minProdSites' => true,
        'maxProdSites' => true,
        'licensedSites' => false,
        'currentProductionSites' => false,
        'currentStagingSites' => false,
        'currentTestingSites' => false,
        'autoScaleLicenses' => false,
        'appType' => true,
        'region' => false,
        'currentProductionSiteDomains' => true,
        'licensedProductionSiteDomains' => true,
        'startDate' => false,
        'endDate' => true,
        'archived' => true,
        'customer' => false,
        'uuid' => false,
        'id' => false,
        'createdAt' => false,
        'updatedAt' => false,
        'deletedAt' => true,
    ];

    /**
     * If a nullable field gets set to null, insert it here.
     *
     * @var bool[]
     */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'minProdSites' => 'minProdSites',
        'maxProdSites' => 'maxProdSites',
        'licensedSites' => 'licensedSites',
        'currentProductionSites' => 'currentProductionSites',
        'currentStagingSites' => 'currentStagingSites',
        'currentTestingSites' => 'currentTestingSites',
        'autoScaleLicenses' => 'autoScaleLicenses',
        'appType' => 'appType',
        'region' => 'region',
        'currentProductionSiteDomains' => 'currentProductionSiteDomains',
        'licensedProductionSiteDomains' => 'licensedProductionSiteDomains',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'archived' => 'archived',
        'customer' => 'customer',
        'uuid' => 'uuid',
        'id' => 'id',
        'createdAt' => 'createdAt',
        'updatedAt' => 'updatedAt',
        'deletedAt' => 'deletedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'minProdSites' => 'setMinProdSites',
        'maxProdSites' => 'setMaxProdSites',
        'licensedSites' => 'setLicensedSites',
        'currentProductionSites' => 'setCurrentProductionSites',
        'currentStagingSites' => 'setCurrentStagingSites',
        'currentTestingSites' => 'setCurrentTestingSites',
        'autoScaleLicenses' => 'setAutoScaleLicenses',
        'appType' => 'setAppType',
        'region' => 'setRegion',
        'currentProductionSiteDomains' => 'setCurrentProductionSiteDomains',
        'licensedProductionSiteDomains' => 'setLicensedProductionSiteDomains',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'archived' => 'setArchived',
        'customer' => 'setCustomer',
        'uuid' => 'setUuid',
        'id' => 'setId',
        'createdAt' => 'setCreatedAt',
        'updatedAt' => 'setUpdatedAt',
        'deletedAt' => 'setDeletedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'minProdSites' => 'getMinProdSites',
        'maxProdSites' => 'getMaxProdSites',
        'licensedSites' => 'getLicensedSites',
        'currentProductionSites' => 'getCurrentProductionSites',
        'currentStagingSites' => 'getCurrentStagingSites',
        'currentTestingSites' => 'getCurrentTestingSites',
        'autoScaleLicenses' => 'getAutoScaleLicenses',
        'appType' => 'getAppType',
        'region' => 'getRegion',
        'currentProductionSiteDomains' => 'getCurrentProductionSiteDomains',
        'licensedProductionSiteDomains' => 'getLicensedProductionSiteDomains',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'archived' => 'getArchived',
        'customer' => 'getCustomer',
        'uuid' => 'getUuid',
        'id' => 'getId',
        'createdAt' => 'getCreatedAt',
        'updatedAt' => 'getUpdatedAt',
        'deletedAt' => 'getDeletedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('minProdSites', $data ?? [], null);
        $this->setIfExists('maxProdSites', $data ?? [], null);
        $this->setIfExists('licensedSites', $data ?? [], null);
        $this->setIfExists('currentProductionSites', $data ?? [], null);
        $this->setIfExists('currentStagingSites', $data ?? [], null);
        $this->setIfExists('currentTestingSites', $data ?? [], null);
        $this->setIfExists('autoScaleLicenses', $data ?? [], null);
        $this->setIfExists('appType', $data ?? [], null);
        $this->setIfExists('region', $data ?? [], null);
        $this->setIfExists('currentProductionSiteDomains', $data ?? [], null);
        $this->setIfExists('licensedProductionSiteDomains', $data ?? [], null);
        $this->setIfExists('startDate', $data ?? [], null);
        $this->setIfExists('endDate', $data ?? [], null);
        $this->setIfExists('archived', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('uuid', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('createdAt', $data ?? [], null);
        $this->setIfExists('updatedAt', $data ?? [], null);
        $this->setIfExists('deletedAt', $data ?? [], null);
    }

    /**
     * Gets the string presentation of the object.
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Checks if a property is nullable.
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (null === $this->container['licensedSites']) {
            $invalidProperties[] = "'licensedSites' can't be null";
        }
        if (null === $this->container['currentProductionSites']) {
            $invalidProperties[] = "'currentProductionSites' can't be null";
        }
        if (null === $this->container['currentStagingSites']) {
            $invalidProperties[] = "'currentStagingSites' can't be null";
        }
        if (null === $this->container['currentTestingSites']) {
            $invalidProperties[] = "'currentTestingSites' can't be null";
        }
        if (null === $this->container['autoScaleLicenses']) {
            $invalidProperties[] = "'autoScaleLicenses' can't be null";
        }
        if (null === $this->container['region']) {
            $invalidProperties[] = "'region' can't be null";
        }
        if (null === $this->container['startDate']) {
            $invalidProperties[] = "'startDate' can't be null";
        }
        if (null === $this->container['customer']) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if (null === $this->container['uuid']) {
            $invalidProperties[] = "'uuid' can't be null";
        }
        if (null === $this->container['id']) {
            $invalidProperties[] = "'id' can't be null";
        }
        if (null === $this->container['createdAt']) {
            $invalidProperties[] = "'createdAt' can't be null";
        }
        if (null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets minProdSites.
     *
     * @return null|float
     */
    public function getMinProdSites()
    {
        return $this->container['minProdSites'];
    }

    /**
     * Sets minProdSites.
     *
     * @param null|float $minProdSites minProdSites
     *
     * @return self
     */
    public function setMinProdSites($minProdSites)
    {
        if (is_null($minProdSites)) {
            array_push($this->openAPINullablesSetToNull, 'minProdSites');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minProdSites', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minProdSites'] = $minProdSites;

        return $this;
    }

    /**
     * Gets maxProdSites.
     *
     * @return null|float
     */
    public function getMaxProdSites()
    {
        return $this->container['maxProdSites'];
    }

    /**
     * Sets maxProdSites.
     *
     * @param null|float $maxProdSites maxProdSites
     *
     * @return self
     */
    public function setMaxProdSites($maxProdSites)
    {
        if (is_null($maxProdSites)) {
            array_push($this->openAPINullablesSetToNull, 'maxProdSites');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('maxProdSites', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['maxProdSites'] = $maxProdSites;

        return $this;
    }

    /**
     * Gets licensedSites.
     *
     * @return float
     */
    public function getLicensedSites()
    {
        return $this->container['licensedSites'];
    }

    /**
     * Sets licensedSites.
     *
     * @param float $licensedSites licensedSites
     *
     * @return self
     */
    public function setLicensedSites($licensedSites)
    {
        if (is_null($licensedSites)) {
            throw new \InvalidArgumentException('non-nullable licensedSites cannot be null');
        }
        $this->container['licensedSites'] = $licensedSites;

        return $this;
    }

    /**
     * Gets currentProductionSites.
     *
     * @return float
     */
    public function getCurrentProductionSites()
    {
        return $this->container['currentProductionSites'];
    }

    /**
     * Sets currentProductionSites.
     *
     * @param float $currentProductionSites currentProductionSites
     *
     * @return self
     */
    public function setCurrentProductionSites($currentProductionSites)
    {
        if (is_null($currentProductionSites)) {
            throw new \InvalidArgumentException('non-nullable currentProductionSites cannot be null');
        }
        $this->container['currentProductionSites'] = $currentProductionSites;

        return $this;
    }

    /**
     * Gets currentStagingSites.
     *
     * @return float
     */
    public function getCurrentStagingSites()
    {
        return $this->container['currentStagingSites'];
    }

    /**
     * Sets currentStagingSites.
     *
     * @param float $currentStagingSites currentStagingSites
     *
     * @return self
     */
    public function setCurrentStagingSites($currentStagingSites)
    {
        if (is_null($currentStagingSites)) {
            throw new \InvalidArgumentException('non-nullable currentStagingSites cannot be null');
        }
        $this->container['currentStagingSites'] = $currentStagingSites;

        return $this;
    }

    /**
     * Gets currentTestingSites.
     *
     * @return float
     */
    public function getCurrentTestingSites()
    {
        return $this->container['currentTestingSites'];
    }

    /**
     * Sets currentTestingSites.
     *
     * @param float $currentTestingSites currentTestingSites
     *
     * @return self
     */
    public function setCurrentTestingSites($currentTestingSites)
    {
        if (is_null($currentTestingSites)) {
            throw new \InvalidArgumentException('non-nullable currentTestingSites cannot be null');
        }
        $this->container['currentTestingSites'] = $currentTestingSites;

        return $this;
    }

    /**
     * Gets autoScaleLicenses.
     *
     * @return bool
     */
    public function getAutoScaleLicenses()
    {
        return $this->container['autoScaleLicenses'];
    }

    /**
     * Sets autoScaleLicenses.
     *
     * @param bool $autoScaleLicenses autoScaleLicenses
     *
     * @return self
     */
    public function setAutoScaleLicenses($autoScaleLicenses)
    {
        if (is_null($autoScaleLicenses)) {
            throw new \InvalidArgumentException('non-nullable autoScaleLicenses cannot be null');
        }
        $this->container['autoScaleLicenses'] = $autoScaleLicenses;

        return $this;
    }

    /**
     * Gets appType.
     *
     * @return null|SiteApplicationType
     */
    public function getAppType()
    {
        return $this->container['appType'];
    }

    /**
     * Sets appType.
     *
     * @param null|SiteApplicationType $appType appType
     *
     * @return self
     */
    public function setAppType($appType)
    {
        if (is_null($appType)) {
            array_push($this->openAPINullablesSetToNull, 'appType');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('appType', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['appType'] = $appType;

        return $this;
    }

    /**
     * Gets region.
     *
     * @return SalesRegion
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region.
     *
     * @param SalesRegion $region region
     *
     * @return self
     */
    public function setRegion($region)
    {
        if (is_null($region)) {
            throw new \InvalidArgumentException('non-nullable region cannot be null');
        }
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets currentProductionSiteDomains.
     *
     * @return null|string[]
     */
    public function getCurrentProductionSiteDomains()
    {
        return $this->container['currentProductionSiteDomains'];
    }

    /**
     * Sets currentProductionSiteDomains.
     *
     * @param null|string[] $currentProductionSiteDomains currentProductionSiteDomains
     *
     * @return self
     */
    public function setCurrentProductionSiteDomains($currentProductionSiteDomains)
    {
        if (is_null($currentProductionSiteDomains)) {
            array_push($this->openAPINullablesSetToNull, 'currentProductionSiteDomains');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('currentProductionSiteDomains', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['currentProductionSiteDomains'] = $currentProductionSiteDomains;

        return $this;
    }

    /**
     * Gets licensedProductionSiteDomains.
     *
     * @return null|string[]
     */
    public function getLicensedProductionSiteDomains()
    {
        return $this->container['licensedProductionSiteDomains'];
    }

    /**
     * Sets licensedProductionSiteDomains.
     *
     * @param null|string[] $licensedProductionSiteDomains licensedProductionSiteDomains
     *
     * @return self
     */
    public function setLicensedProductionSiteDomains($licensedProductionSiteDomains)
    {
        if (is_null($licensedProductionSiteDomains)) {
            array_push($this->openAPINullablesSetToNull, 'licensedProductionSiteDomains');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('licensedProductionSiteDomains', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['licensedProductionSiteDomains'] = $licensedProductionSiteDomains;

        return $this;
    }

    /**
     * Gets startDate.
     *
     * @return float
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate.
     *
     * @param float $startDate startDate
     *
     * @return self
     */
    public function setStartDate($startDate)
    {
        if (is_null($startDate)) {
            throw new \InvalidArgumentException('non-nullable startDate cannot be null');
        }
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate.
     *
     * @return null|float
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate.
     *
     * @param null|float $endDate endDate
     *
     * @return self
     */
    public function setEndDate($endDate)
    {
        if (is_null($endDate)) {
            array_push($this->openAPINullablesSetToNull, 'endDate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('endDate', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets archived.
     *
     * @return null|bool
     */
    public function getArchived()
    {
        return $this->container['archived'];
    }

    /**
     * Sets archived.
     *
     * @param null|bool $archived archived
     *
     * @return self
     */
    public function setArchived($archived)
    {
        if (is_null($archived)) {
            array_push($this->openAPINullablesSetToNull, 'archived');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('archived', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['archived'] = $archived;

        return $this;
    }

    /**
     * Gets customer.
     *
     * @return RuntimeRemoteEntityDependencyWithDependenciesEntity
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer.
     *
     * @param RuntimeRemoteEntityDependencyWithDependenciesEntity $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets uuid.
     *
     * @return string
     */
    public function getUuid()
    {
        return $this->container['uuid'];
    }

    /**
     * Sets uuid.
     *
     * @param string $uuid uuid
     *
     * @return self
     */
    public function setUuid($uuid)
    {
        if (is_null($uuid)) {
            throw new \InvalidArgumentException('non-nullable uuid cannot be null');
        }
        $this->container['uuid'] = $uuid;

        return $this;
    }

    /**
     * Gets id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id.
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets createdAt.
     *
     * @return float
     */
    public function getCreatedAt()
    {
        return $this->container['createdAt'];
    }

    /**
     * Sets createdAt.
     *
     * @param float $createdAt createdAt
     *
     * @return self
     */
    public function setCreatedAt($createdAt)
    {
        if (is_null($createdAt)) {
            throw new \InvalidArgumentException('non-nullable createdAt cannot be null');
        }
        $this->container['createdAt'] = $createdAt;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return float
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'];
    }

    /**
     * Sets updatedAt.
     *
     * @param float $updatedAt updatedAt
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        if (is_null($updatedAt)) {
            throw new \InvalidArgumentException('non-nullable updatedAt cannot be null');
        }
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets deletedAt.
     *
     * @return null|float
     */
    public function getDeletedAt()
    {
        return $this->container['deletedAt'];
    }

    /**
     * Sets deletedAt.
     *
     * @param null|float $deletedAt deletedAt
     *
     * @return self
     */
    public function setDeletedAt($deletedAt)
    {
        if (is_null($deletedAt)) {
            array_push($this->openAPINullablesSetToNull, 'deletedAt');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('deletedAt', $nullablesSetToNull);
            if (false !== $index) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['deletedAt'] = $deletedAt;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @see https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets a header-safe presentation of the object.
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }

    /**
     * Array of nullable properties.
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null.
     *
     * @return bool[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null.
     *
     * @param bool[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
     * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
     * $this->openAPINullablesSetToNull array.
     *
     * @param mixed  $defaultValue
     */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }
}
