<?php

/**
 * DefaultApi
 * PHP version 7.4.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */

/**
 * Sync Core.
 *
 * The Sync Core that sends and receives content from all connected sites and services for Content Sync.
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EdgeBox\SyncCore\V2\Raw\Api;

use EdgeBox\SyncCore\V2\Raw\ApiException;
use EdgeBox\SyncCore\V2\Raw\Configuration;
use EdgeBox\SyncCore\V2\Raw\HeaderSelector;
use EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration;
use EdgeBox\SyncCore\V2\Raw\Model\ContractEntity;
use EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity;
use EdgeBox\SyncCore\V2\Raw\Model\CreateAuthenticationDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateFileDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateFlowDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateMigrationDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreatePoolDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateRemoteEntityRevisionDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateRemoteEntityTypeVersionDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateSiteDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateSyndicationDto;
use EdgeBox\SyncCore\V2\Raw\Model\CreateWebhookDto;
use EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity;
use EdgeBox\SyncCore\V2\Raw\Model\DeleteRemoteEntityRevisionDto;
use EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage;
use EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary;
use EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll;
use EdgeBox\SyncCore\V2\Raw\Model\FileEntity;
use EdgeBox\SyncCore\V2\Raw\Model\FlowDeleteRequest;
use EdgeBox\SyncCore\V2\Raw\Model\FlowEntity;
use EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto;
use EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto;
use EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response;
use EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response;
use EdgeBox\SyncCore\V2\Raw\Model\JwtResponse;
use EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsRequest;
use EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse;
use EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity;
use EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary;
use EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions;
use EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse;
use EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse;
use EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList;
use EdgeBox\SyncCore\V2\Raw\Model\PagedWebhookList;
use EdgeBox\SyncCore\V2\Raw\Model\PoolEntity;
use EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse;
use EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity;
use EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity;
use EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration;
use EdgeBox\SyncCore\V2\Raw\Model\RegisterNewSiteDto;
use EdgeBox\SyncCore\V2\Raw\Model\RegisterSiteDto;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity;
use EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity;
use EdgeBox\SyncCore\V2\Raw\Model\RequestResponseDto;
use EdgeBox\SyncCore\V2\Raw\Model\SetBasicAuthDto;
use EdgeBox\SyncCore\V2\Raw\Model\SetFeatureFlagDto;
use EdgeBox\SyncCore\V2\Raw\Model\SetThrottlingDto;
use EdgeBox\SyncCore\V2\Raw\Model\SiteConfigUpdateRequestDto;
use EdgeBox\SyncCore\V2\Raw\Model\SiteEntity;
use EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto;
use EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails;
use EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse;
use EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationDeleteRequest;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationRetryRequest;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationTraceRequest;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationUsageSummary;
use EdgeBox\SyncCore\V2\Raw\Model\SyndicationUsageSummaryListResponse;
use EdgeBox\SyncCore\V2\Raw\Model\UsageStats;
use EdgeBox\SyncCore\V2\Raw\Model\UsageSummary;
use EdgeBox\SyncCore\V2\Raw\Model\WebhookDeleteRequest;
use EdgeBox\SyncCore\V2\Raw\Model\WebhookEntity;
use EdgeBox\SyncCore\V2\Raw\Model\WebhookResendVerificationEmail;
use EdgeBox\SyncCore\V2\Raw\ObjectSerializer;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Promise\PromiseInterface;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;

/**
 * DefaultApi Class Doc Comment.
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @see     https://openapi-generator.tech
 */
class DefaultApi
{
    /** @var string[] */
    public const contentTypes = [
        'authenticationControllerCreate' => [
            'application/json',
        ],
        'authenticationControllerGetBasicAuth' => [
            'application/json',
        ],
        'authenticationControllerSetBasicAuth' => [
            'application/json',
        ],
        'backendControllerExchangeToken' => [
            'application/json',
        ],
        'backendControllerRefreshContract' => [
            'application/json',
        ],
        'configurationControllerContract' => [
            'application/json',
        ],
        'configurationControllerInfo' => [
            'application/json',
        ],
        'configurationControllerPullDashboard' => [
            'application/json',
        ],
        'contractControllerItem' => [
            'application/json',
        ],
        'contractControllerItemByUuid' => [
            'application/json',
        ],
        'contractRevisionControllerItem' => [
            'application/json',
        ],
        'contractRevisionControllerMostRecentForContract' => [
            'application/json',
        ],
        'customerControllerItem' => [
            'application/json',
        ],
        'customerControllerItemByUuid' => [
            'application/json',
        ],
        'featuresControllerSummary' => [
            'application/json',
        ],
        'featuresControllerSummaryAll' => [
            'application/json',
        ],
        'featuresControllerUpdate' => [
            'application/json',
        ],
        'fileControllerCreate' => [
            'application/json',
        ],
        'fileControllerDownload' => [
            'application/json',
        ],
        'fileControllerFileUploaded' => [
            'application/json',
        ],
        'fileControllerItem' => [
            'application/json',
        ],
        'fileControllerPreview' => [
            'application/json',
        ],
        'flowControllerCreate' => [
            'application/json',
        ],
        'flowControllerDelete' => [
            'application/json',
        ],
        'flowControllerItem' => [
            'application/json',
        ],
        'flowControllerList' => [
            'application/json',
        ],
        'healthControllerLive' => [
            'application/json',
        ],
        'healthControllerReady' => [
            'application/json',
        ],
        'localFileControllerDownload' => [
            'application/json',
        ],
        'localFileControllerUpload' => [
            'multipart/form-data',
        ],
        'loggingControllerList' => [
            'application/json',
        ],
        'migrationControllerCreate' => [
            'application/json',
        ],
        'migrationControllerDelete' => [
            'application/json',
        ],
        'migrationControllerItem' => [
            'application/json',
        ],
        'migrationControllerList' => [
            'application/json',
        ],
        'migrationControllerSummary' => [
            'application/json',
        ],
        'poolControllerCreate' => [
            'application/json',
        ],
        'poolControllerItem' => [
            'application/json',
        ],
        'poolControllerList' => [
            'application/json',
        ],
        'previewsControllerList' => [
            'application/json',
        ],
        'previewsControllerListForFlow' => [
            'application/json',
        ],
        'projectControllerGetLanguages' => [
            'application/json',
        ],
        'projectControllerItem' => [
            'application/json',
        ],
        'projectControllerItemByUuid' => [
            'application/json',
        ],
        'projectLinkControllerImport' => [
            'application/json',
        ],
        'projectLinkControllerItem' => [
            'application/json',
        ],
        'projectLinkControllerItemByUuid' => [
            'application/json',
        ],
        'remoteEntityCloneControllerItem' => [
            'application/json',
        ],
        'remoteEntityCloneControllerItemByTargetUuid' => [
            'application/json',
        ],
        'remoteEntityCloneControllerList' => [
            'application/json',
        ],
        'remoteEntityCloneControllerListBySourceUuid' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerCreate' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerDelete' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerGetTranslationLanguages' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerItem' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerList' => [
            'application/json',
        ],
        'remoteEntityRevisionControllerSerialize' => [
            'application/json',
        ],
        'remoteEntityTypeControllerByMachineName' => [
            'application/json',
        ],
        'remoteEntityTypeControllerItem' => [
            'application/json',
        ],
        'remoteEntityTypeControllerList' => [
            'application/json',
        ],
        'remoteEntityTypeVersionControllerCreate' => [
            'application/json',
        ],
        'remoteEntityTypeVersionControllerGetVersionUsage' => [
            'application/json',
        ],
        'remoteEntityTypeVersionControllerItem' => [
            'application/json',
        ],
        'remoteEntityTypeVersionControllerItemByMachineName' => [
            'application/json',
        ],
        'remoteEntityUsageControllerItem' => [
            'application/json',
        ],
        'remoteEntityUsageControllerList' => [
            'application/json',
        ],
        'siteControllerGetRequests' => [
            'application/json',
        ],
        'siteControllerGetThrottling' => [
            'application/json',
        ],
        'siteControllerItem' => [
            'application/json',
        ],
        'siteControllerItemByUuid' => [
            'application/json',
        ],
        'siteControllerRegister' => [
            'application/json',
        ],
        'siteControllerRegisterNew' => [
            'application/json',
        ],
        'siteControllerRespondToRequest' => [
            'application/json',
        ],
        'siteControllerSearch' => [
            'application/json',
        ],
        'siteControllerSelf' => [
            'application/json',
        ],
        'siteControllerSetThrottling' => [
            'application/json',
        ],
        'siteControllerUpdate' => [
            'application/json',
        ],
        'siteControllerUpdateConfig' => [
            'application/json',
        ],
        'syndicationControllerCreate' => [
            'application/json',
        ],
        'syndicationControllerDelete' => [
            'application/json',
        ],
        'syndicationControllerGetErrors' => [
            'application/json',
        ],
        'syndicationControllerItem' => [
            'application/json',
        ],
        'syndicationControllerList' => [
            'application/json',
        ],
        'syndicationControllerRestart' => [
            'application/json',
        ],
        'syndicationControllerTrace' => [
            'application/json',
        ],
        'syndicationControllerUsageSummary' => [
            'application/json',
        ],
        'syndicationControllerUsageSummaryForSite' => [
            'application/json',
        ],
        'usageStatsControllerGetForPeriod' => [
            'application/json',
        ],
        'usageStatsControllerGetForType' => [
            'application/json',
        ],
        'usageStatsControllerSummary' => [
            'application/json',
        ],
        'webhookControllerCreate' => [
            'application/json',
        ],
        'webhookControllerDelete' => [
            'application/json',
        ],
        'webhookControllerItem' => [
            'application/json',
        ],
        'webhookControllerList' => [
            'application/json',
        ],
        'webhookControllerSendVerificationEmail' => [
            'application/json',
        ],
        'webhookControllerUpdate' => [
            'application/json',
        ],
        'webhookControllerVerifyEmail' => [
            'application/json',
        ],
    ];

    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index.
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index.
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation authenticationControllerCreate.
     *
     * @param  CreateAuthenticationDto $createAuthenticationDto createAuthenticationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerCreate'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerCreate($createAuthenticationDto, string $contentType = self::contentTypes['authenticationControllerCreate'][0])
    {
        [$response] = $this->authenticationControllerCreateWithHttpInfo($createAuthenticationDto, $contentType);

        return $response;
    }

    /**
     * Operation authenticationControllerCreateWithHttpInfo.
     *
     * @param  CreateAuthenticationDto $createAuthenticationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerCreateWithHttpInfo($createAuthenticationDto, string $contentType = self::contentTypes['authenticationControllerCreate'][0])
    {
        $request = $this->authenticationControllerCreateRequest($createAuthenticationDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation authenticationControllerCreateAsync.
     *
     * @param  CreateAuthenticationDto $createAuthenticationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerCreateAsync($createAuthenticationDto, string $contentType = self::contentTypes['authenticationControllerCreate'][0])
    {
        return $this->authenticationControllerCreateAsyncWithHttpInfo($createAuthenticationDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation authenticationControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateAuthenticationDto $createAuthenticationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerCreateAsyncWithHttpInfo($createAuthenticationDto, string $contentType = self::contentTypes['authenticationControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->authenticationControllerCreateRequest($createAuthenticationDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'authenticationControllerCreate'.
     *
     * @param  CreateAuthenticationDto $createAuthenticationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerCreateRequest($createAuthenticationDto, string $contentType = self::contentTypes['authenticationControllerCreate'][0])
    {
        // verify the required parameter 'createAuthenticationDto' is set
        if (null === $createAuthenticationDto || (is_array($createAuthenticationDto) && 0 === count($createAuthenticationDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createAuthenticationDto when calling authenticationControllerCreate'
            );
        }

        $resourcePath = '/sync-core/authentication';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createAuthenticationDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createAuthenticationDto));
            } else {
                $httpBody = $createAuthenticationDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation authenticationControllerGetBasicAuth.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerGetBasicAuth'] to see the possible values for this operation
     *
     * @return GetBasicAuthDto
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerGetBasicAuth(string $contentType = self::contentTypes['authenticationControllerGetBasicAuth'][0])
    {
        [$response] = $this->authenticationControllerGetBasicAuthWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation authenticationControllerGetBasicAuthWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerGetBasicAuth'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerGetBasicAuthWithHttpInfo(string $contentType = self::contentTypes['authenticationControllerGetBasicAuth'][0])
    {
        $request = $this->authenticationControllerGetBasicAuthRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation authenticationControllerGetBasicAuthAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerGetBasicAuth'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerGetBasicAuthAsync(string $contentType = self::contentTypes['authenticationControllerGetBasicAuth'][0])
    {
        return $this->authenticationControllerGetBasicAuthAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation authenticationControllerGetBasicAuthAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerGetBasicAuth'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerGetBasicAuthAsyncWithHttpInfo(string $contentType = self::contentTypes['authenticationControllerGetBasicAuth'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetBasicAuthDto';
        $request = $this->authenticationControllerGetBasicAuthRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'authenticationControllerGetBasicAuth'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerGetBasicAuth'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerGetBasicAuthRequest(string $contentType = self::contentTypes['authenticationControllerGetBasicAuth'][0])
    {
        $resourcePath = '/sync-core/authentication/basic-auth';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation authenticationControllerSetBasicAuth.
     *
     * @param  SetBasicAuthDto $setBasicAuthDto setBasicAuthDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerSetBasicAuth'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerSetBasicAuth($setBasicAuthDto, string $contentType = self::contentTypes['authenticationControllerSetBasicAuth'][0])
    {
        [$response] = $this->authenticationControllerSetBasicAuthWithHttpInfo($setBasicAuthDto, $contentType);

        return $response;
    }

    /**
     * Operation authenticationControllerSetBasicAuthWithHttpInfo.
     *
     * @param  SetBasicAuthDto $setBasicAuthDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerSetBasicAuth'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerSetBasicAuthWithHttpInfo($setBasicAuthDto, string $contentType = self::contentTypes['authenticationControllerSetBasicAuth'][0])
    {
        $request = $this->authenticationControllerSetBasicAuthRequest($setBasicAuthDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation authenticationControllerSetBasicAuthAsync.
     *
     * @param  SetBasicAuthDto $setBasicAuthDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerSetBasicAuth'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerSetBasicAuthAsync($setBasicAuthDto, string $contentType = self::contentTypes['authenticationControllerSetBasicAuth'][0])
    {
        return $this->authenticationControllerSetBasicAuthAsyncWithHttpInfo($setBasicAuthDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation authenticationControllerSetBasicAuthAsyncWithHttpInfo.
     *
     * @param  SetBasicAuthDto $setBasicAuthDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerSetBasicAuth'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerSetBasicAuthAsyncWithHttpInfo($setBasicAuthDto, string $contentType = self::contentTypes['authenticationControllerSetBasicAuth'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->authenticationControllerSetBasicAuthRequest($setBasicAuthDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'authenticationControllerSetBasicAuth'.
     *
     * @param  SetBasicAuthDto $setBasicAuthDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authenticationControllerSetBasicAuth'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function authenticationControllerSetBasicAuthRequest($setBasicAuthDto, string $contentType = self::contentTypes['authenticationControllerSetBasicAuth'][0])
    {
        // verify the required parameter 'setBasicAuthDto' is set
        if (null === $setBasicAuthDto || (is_array($setBasicAuthDto) && 0 === count($setBasicAuthDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setBasicAuthDto when calling authenticationControllerSetBasicAuth'
            );
        }

        $resourcePath = '/sync-core/authentication/basic-auth';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setBasicAuthDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($setBasicAuthDto));
            } else {
                $httpBody = $setBasicAuthDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation backendControllerExchangeToken.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerExchangeToken'] to see the possible values for this operation
     *
     * @return JwtResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function backendControllerExchangeToken($uuid, string $contentType = self::contentTypes['backendControllerExchangeToken'][0])
    {
        [$response] = $this->backendControllerExchangeTokenWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation backendControllerExchangeTokenWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerExchangeToken'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\JwtResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function backendControllerExchangeTokenWithHttpInfo($uuid, string $contentType = self::contentTypes['backendControllerExchangeToken'][0])
    {
        $request = $this->backendControllerExchangeTokenRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation backendControllerExchangeTokenAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerExchangeToken'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerExchangeTokenAsync($uuid, string $contentType = self::contentTypes['backendControllerExchangeToken'][0])
    {
        return $this->backendControllerExchangeTokenAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation backendControllerExchangeTokenAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerExchangeToken'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerExchangeTokenAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['backendControllerExchangeToken'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\JwtResponse';
        $request = $this->backendControllerExchangeTokenRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'backendControllerExchangeToken'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerExchangeToken'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerExchangeTokenRequest($uuid, string $contentType = self::contentTypes['backendControllerExchangeToken'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling backendControllerExchangeToken'
            );
        }

        $resourcePath = '/sync-core/backend/exchange-token/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation backendControllerRefreshContract.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerRefreshContract'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function backendControllerRefreshContract($id, string $contentType = self::contentTypes['backendControllerRefreshContract'][0])
    {
        [$response] = $this->backendControllerRefreshContractWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation backendControllerRefreshContractWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerRefreshContract'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function backendControllerRefreshContractWithHttpInfo($id, string $contentType = self::contentTypes['backendControllerRefreshContract'][0])
    {
        $request = $this->backendControllerRefreshContractRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation backendControllerRefreshContractAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerRefreshContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerRefreshContractAsync($id, string $contentType = self::contentTypes['backendControllerRefreshContract'][0])
    {
        return $this->backendControllerRefreshContractAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation backendControllerRefreshContractAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerRefreshContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerRefreshContractAsyncWithHttpInfo($id, string $contentType = self::contentTypes['backendControllerRefreshContract'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->backendControllerRefreshContractRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'backendControllerRefreshContract'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backendControllerRefreshContract'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function backendControllerRefreshContractRequest($id, string $contentType = self::contentTypes['backendControllerRefreshContract'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling backendControllerRefreshContract'
            );
        }

        $resourcePath = '/sync-core/backend/contract/{id}/refresh';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation configurationControllerContract.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerContract'] to see the possible values for this operation
     *
     * @return ContractConfiguration
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerContract(string $contentType = self::contentTypes['configurationControllerContract'][0])
    {
        [$response] = $this->configurationControllerContractWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation configurationControllerContractWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerContract'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerContractWithHttpInfo(string $contentType = self::contentTypes['configurationControllerContract'][0])
    {
        $request = $this->configurationControllerContractRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation configurationControllerContractAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerContractAsync(string $contentType = self::contentTypes['configurationControllerContract'][0])
    {
        return $this->configurationControllerContractAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation configurationControllerContractAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerContractAsyncWithHttpInfo(string $contentType = self::contentTypes['configurationControllerContract'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractConfiguration';
        $request = $this->configurationControllerContractRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'configurationControllerContract'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerContract'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerContractRequest(string $contentType = self::contentTypes['configurationControllerContract'][0])
    {
        $resourcePath = '/sync-core/configuration/contract';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation configurationControllerInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerInfo'] to see the possible values for this operation
     *
     * @return SyncCoreInfo
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerInfo(string $contentType = self::contentTypes['configurationControllerInfo'][0])
    {
        [$response] = $this->configurationControllerInfoWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation configurationControllerInfoWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerInfo'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerInfoWithHttpInfo(string $contentType = self::contentTypes['configurationControllerInfo'][0])
    {
        $request = $this->configurationControllerInfoRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation configurationControllerInfoAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerInfo'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerInfoAsync(string $contentType = self::contentTypes['configurationControllerInfo'][0])
    {
        return $this->configurationControllerInfoAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation configurationControllerInfoAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerInfo'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerInfoAsyncWithHttpInfo(string $contentType = self::contentTypes['configurationControllerInfo'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyncCoreInfo';
        $request = $this->configurationControllerInfoRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'configurationControllerInfo'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerInfo'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerInfoRequest(string $contentType = self::contentTypes['configurationControllerInfo'][0])
    {
        $resourcePath = '/sync-core/configuration/info';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation configurationControllerPullDashboard.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerPullDashboard'] to see the possible values for this operation
     *
     * @return PullDashboardConfiguration
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerPullDashboard(string $contentType = self::contentTypes['configurationControllerPullDashboard'][0])
    {
        [$response] = $this->configurationControllerPullDashboardWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation configurationControllerPullDashboardWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerPullDashboard'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function configurationControllerPullDashboardWithHttpInfo(string $contentType = self::contentTypes['configurationControllerPullDashboard'][0])
    {
        $request = $this->configurationControllerPullDashboardRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation configurationControllerPullDashboardAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerPullDashboard'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerPullDashboardAsync(string $contentType = self::contentTypes['configurationControllerPullDashboard'][0])
    {
        return $this->configurationControllerPullDashboardAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation configurationControllerPullDashboardAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerPullDashboard'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerPullDashboardAsyncWithHttpInfo(string $contentType = self::contentTypes['configurationControllerPullDashboard'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PullDashboardConfiguration';
        $request = $this->configurationControllerPullDashboardRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'configurationControllerPullDashboard'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['configurationControllerPullDashboard'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function configurationControllerPullDashboardRequest(string $contentType = self::contentTypes['configurationControllerPullDashboard'][0])
    {
        $resourcePath = '/sync-core/configuration/pull-dashboard';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation contractControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItem'] to see the possible values for this operation
     *
     * @return ContractEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractControllerItem($id, string $contentType = self::contentTypes['contractControllerItem'][0])
    {
        [$response] = $this->contractControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation contractControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ContractEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['contractControllerItem'][0])
    {
        $request = $this->contractControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation contractControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemAsync($id, string $contentType = self::contentTypes['contractControllerItem'][0])
    {
        return $this->contractControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation contractControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['contractControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity';
        $request = $this->contractControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'contractControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemRequest($id, string $contentType = self::contentTypes['contractControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling contractControllerItem'
            );
        }

        $resourcePath = '/sync-core/contract/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation contractControllerItemByUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItemByUuid'] to see the possible values for this operation
     *
     * @return ContractEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemByUuid($uuid, string $contentType = self::contentTypes['contractControllerItemByUuid'][0])
    {
        [$response] = $this->contractControllerItemByUuidWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation contractControllerItemByUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItemByUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ContractEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemByUuidWithHttpInfo($uuid, string $contentType = self::contentTypes['contractControllerItemByUuid'][0])
    {
        $request = $this->contractControllerItemByUuidRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation contractControllerItemByUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemByUuidAsync($uuid, string $contentType = self::contentTypes['contractControllerItemByUuid'][0])
    {
        return $this->contractControllerItemByUuidAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation contractControllerItemByUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemByUuidAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['contractControllerItemByUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractEntity';
        $request = $this->contractControllerItemByUuidRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'contractControllerItemByUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractControllerItemByUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function contractControllerItemByUuidRequest($uuid, string $contentType = self::contentTypes['contractControllerItemByUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling contractControllerItemByUuid'
            );
        }

        $resourcePath = '/sync-core/contract/by-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation contractRevisionControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerItem'] to see the possible values for this operation
     *
     * @return ContractRevisionEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerItem($id, string $contentType = self::contentTypes['contractRevisionControllerItem'][0])
    {
        [$response] = $this->contractRevisionControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation contractRevisionControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['contractRevisionControllerItem'][0])
    {
        $request = $this->contractRevisionControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation contractRevisionControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerItemAsync($id, string $contentType = self::contentTypes['contractRevisionControllerItem'][0])
    {
        return $this->contractRevisionControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation contractRevisionControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['contractRevisionControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ContractRevisionEntity';
        $request = $this->contractRevisionControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'contractRevisionControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerItemRequest($id, string $contentType = self::contentTypes['contractRevisionControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling contractRevisionControllerItem'
            );
        }

        $resourcePath = '/sync-core/contract-revision/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation contractRevisionControllerMostRecentForContract.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerMostRecentForContract'] to see the possible values for this operation
     *
     * @return MostRecentContractRevisions
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerMostRecentForContract($id, string $contentType = self::contentTypes['contractRevisionControllerMostRecentForContract'][0])
    {
        [$response] = $this->contractRevisionControllerMostRecentForContractWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation contractRevisionControllerMostRecentForContractWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerMostRecentForContract'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerMostRecentForContractWithHttpInfo($id, string $contentType = self::contentTypes['contractRevisionControllerMostRecentForContract'][0])
    {
        $request = $this->contractRevisionControllerMostRecentForContractRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation contractRevisionControllerMostRecentForContractAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerMostRecentForContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerMostRecentForContractAsync($id, string $contentType = self::contentTypes['contractRevisionControllerMostRecentForContract'][0])
    {
        return $this->contractRevisionControllerMostRecentForContractAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation contractRevisionControllerMostRecentForContractAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerMostRecentForContract'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerMostRecentForContractAsyncWithHttpInfo($id, string $contentType = self::contentTypes['contractRevisionControllerMostRecentForContract'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MostRecentContractRevisions';
        $request = $this->contractRevisionControllerMostRecentForContractRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'contractRevisionControllerMostRecentForContract'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['contractRevisionControllerMostRecentForContract'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function contractRevisionControllerMostRecentForContractRequest($id, string $contentType = self::contentTypes['contractRevisionControllerMostRecentForContract'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling contractRevisionControllerMostRecentForContract'
            );
        }

        $resourcePath = '/sync-core/contract-revision/most-recent-for-contract/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customerControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItem'] to see the possible values for this operation
     *
     * @return CustomerEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function customerControllerItem($id, string $contentType = self::contentTypes['customerControllerItem'][0])
    {
        [$response] = $this->customerControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation customerControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['customerControllerItem'][0])
    {
        $request = $this->customerControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation customerControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemAsync($id, string $contentType = self::contentTypes['customerControllerItem'][0])
    {
        return $this->customerControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation customerControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['customerControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity';
        $request = $this->customerControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'customerControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemRequest($id, string $contentType = self::contentTypes['customerControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling customerControllerItem'
            );
        }

        $resourcePath = '/sync-core/customer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customerControllerItemByUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItemByUuid'] to see the possible values for this operation
     *
     * @return CustomerEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemByUuid($uuid, string $contentType = self::contentTypes['customerControllerItemByUuid'][0])
    {
        [$response] = $this->customerControllerItemByUuidWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation customerControllerItemByUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItemByUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemByUuidWithHttpInfo($uuid, string $contentType = self::contentTypes['customerControllerItemByUuid'][0])
    {
        $request = $this->customerControllerItemByUuidRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation customerControllerItemByUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemByUuidAsync($uuid, string $contentType = self::contentTypes['customerControllerItemByUuid'][0])
    {
        return $this->customerControllerItemByUuidAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation customerControllerItemByUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemByUuidAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['customerControllerItemByUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\CustomerEntity';
        $request = $this->customerControllerItemByUuidRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'customerControllerItemByUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerControllerItemByUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function customerControllerItemByUuidRequest($uuid, string $contentType = self::contentTypes['customerControllerItemByUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling customerControllerItemByUuid'
            );
        }

        $resourcePath = '/sync-core/customer/by-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation featuresControllerSummary.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummary'] to see the possible values for this operation
     *
     * @return FeatureFlagSummary
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummary(string $contentType = self::contentTypes['featuresControllerSummary'][0])
    {
        [$response] = $this->featuresControllerSummaryWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation featuresControllerSummaryWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummary'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryWithHttpInfo(string $contentType = self::contentTypes['featuresControllerSummary'][0])
    {
        $request = $this->featuresControllerSummaryRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation featuresControllerSummaryAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummary'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAsync(string $contentType = self::contentTypes['featuresControllerSummary'][0])
    {
        return $this->featuresControllerSummaryAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation featuresControllerSummaryAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummary'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAsyncWithHttpInfo(string $contentType = self::contentTypes['featuresControllerSummary'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary';
        $request = $this->featuresControllerSummaryRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'featuresControllerSummary'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummary'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryRequest(string $contentType = self::contentTypes['featuresControllerSummary'][0])
    {
        $resourcePath = '/sync-core/features/summary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation featuresControllerSummaryAll.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummaryAll'] to see the possible values for this operation
     *
     * @return FeatureFlagSummaryAll
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAll(string $contentType = self::contentTypes['featuresControllerSummaryAll'][0])
    {
        [$response] = $this->featuresControllerSummaryAllWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation featuresControllerSummaryAllWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummaryAll'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAllWithHttpInfo(string $contentType = self::contentTypes['featuresControllerSummaryAll'][0])
    {
        $request = $this->featuresControllerSummaryAllRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation featuresControllerSummaryAllAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummaryAll'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAllAsync(string $contentType = self::contentTypes['featuresControllerSummaryAll'][0])
    {
        return $this->featuresControllerSummaryAllAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation featuresControllerSummaryAllAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummaryAll'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAllAsyncWithHttpInfo(string $contentType = self::contentTypes['featuresControllerSummaryAll'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummaryAll';
        $request = $this->featuresControllerSummaryAllRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'featuresControllerSummaryAll'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerSummaryAll'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerSummaryAllRequest(string $contentType = self::contentTypes['featuresControllerSummaryAll'][0])
    {
        $resourcePath = '/sync-core/features/summary/all';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation featuresControllerUpdate.
     *
     * @param  FeatureFlagTargetType $targetType targetType (required)
     * @param  string $featureName featureName (required)
     * @param  SetFeatureFlagDto $setFeatureFlagDto setFeatureFlagDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerUpdate'] to see the possible values for this operation
     *
     * @return FeatureFlagSummary
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerUpdate($targetType, $featureName, $setFeatureFlagDto, string $contentType = self::contentTypes['featuresControllerUpdate'][0])
    {
        [$response] = $this->featuresControllerUpdateWithHttpInfo($targetType, $featureName, $setFeatureFlagDto, $contentType);

        return $response;
    }

    /**
     * Operation featuresControllerUpdateWithHttpInfo.
     *
     * @param  FeatureFlagTargetType $targetType (required)
     * @param  string $featureName (required)
     * @param  SetFeatureFlagDto $setFeatureFlagDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerUpdate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function featuresControllerUpdateWithHttpInfo($targetType, $featureName, $setFeatureFlagDto, string $contentType = self::contentTypes['featuresControllerUpdate'][0])
    {
        $request = $this->featuresControllerUpdateRequest($targetType, $featureName, $setFeatureFlagDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation featuresControllerUpdateAsync.
     *
     * @param  FeatureFlagTargetType $targetType (required)
     * @param  string $featureName (required)
     * @param  SetFeatureFlagDto $setFeatureFlagDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerUpdate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerUpdateAsync($targetType, $featureName, $setFeatureFlagDto, string $contentType = self::contentTypes['featuresControllerUpdate'][0])
    {
        return $this->featuresControllerUpdateAsyncWithHttpInfo($targetType, $featureName, $setFeatureFlagDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation featuresControllerUpdateAsyncWithHttpInfo.
     *
     * @param  FeatureFlagTargetType $targetType (required)
     * @param  string $featureName (required)
     * @param  SetFeatureFlagDto $setFeatureFlagDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerUpdate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerUpdateAsyncWithHttpInfo($targetType, $featureName, $setFeatureFlagDto, string $contentType = self::contentTypes['featuresControllerUpdate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FeatureFlagSummary';
        $request = $this->featuresControllerUpdateRequest($targetType, $featureName, $setFeatureFlagDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'featuresControllerUpdate'.
     *
     * @param  FeatureFlagTargetType $targetType (required)
     * @param  string $featureName (required)
     * @param  SetFeatureFlagDto $setFeatureFlagDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['featuresControllerUpdate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function featuresControllerUpdateRequest($targetType, $featureName, $setFeatureFlagDto, string $contentType = self::contentTypes['featuresControllerUpdate'][0])
    {
        // verify the required parameter 'targetType' is set
        if (null === $targetType || (is_array($targetType) && 0 === count($targetType))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $targetType when calling featuresControllerUpdate'
            );
        }

        // verify the required parameter 'featureName' is set
        if (null === $featureName || (is_array($featureName) && 0 === count($featureName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $featureName when calling featuresControllerUpdate'
            );
        }

        // verify the required parameter 'setFeatureFlagDto' is set
        if (null === $setFeatureFlagDto || (is_array($setFeatureFlagDto) && 0 === count($setFeatureFlagDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setFeatureFlagDto when calling featuresControllerUpdate'
            );
        }

        $resourcePath = '/sync-core/features/{targetType}/{featureName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $targetType) {
            $resourcePath = str_replace(
                '{targetType}',
                ObjectSerializer::toPathValue($targetType),
                $resourcePath
            );
        }
        // path params
        if (null !== $featureName) {
            $resourcePath = str_replace(
                '{featureName}',
                ObjectSerializer::toPathValue($featureName),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setFeatureFlagDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($setFeatureFlagDto));
            } else {
                $httpBody = $setFeatureFlagDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fileControllerCreate.
     *
     * @param  CreateFileDto $createFileDto createFileDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerCreate'] to see the possible values for this operation
     *
     * @return FileEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerCreate($createFileDto, string $contentType = self::contentTypes['fileControllerCreate'][0])
    {
        [$response] = $this->fileControllerCreateWithHttpInfo($createFileDto, $contentType);

        return $response;
    }

    /**
     * Operation fileControllerCreateWithHttpInfo.
     *
     * @param  CreateFileDto $createFileDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FileEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerCreateWithHttpInfo($createFileDto, string $contentType = self::contentTypes['fileControllerCreate'][0])
    {
        $request = $this->fileControllerCreateRequest($createFileDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation fileControllerCreateAsync.
     *
     * @param  CreateFileDto $createFileDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerCreateAsync($createFileDto, string $contentType = self::contentTypes['fileControllerCreate'][0])
    {
        return $this->fileControllerCreateAsyncWithHttpInfo($createFileDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation fileControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateFileDto $createFileDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerCreateAsyncWithHttpInfo($createFileDto, string $contentType = self::contentTypes['fileControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
        $request = $this->fileControllerCreateRequest($createFileDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'fileControllerCreate'.
     *
     * @param  CreateFileDto $createFileDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerCreateRequest($createFileDto, string $contentType = self::contentTypes['fileControllerCreate'][0])
    {
        // verify the required parameter 'createFileDto' is set
        if (null === $createFileDto || (is_array($createFileDto) && 0 === count($createFileDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createFileDto when calling fileControllerCreate'
            );
        }

        $resourcePath = '/sync-core/file';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createFileDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createFileDto));
            } else {
                $httpBody = $createFileDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fileControllerDownload.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerDownload'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerDownload($id, string $contentType = self::contentTypes['fileControllerDownload'][0])
    {
        [$response] = $this->fileControllerDownloadWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation fileControllerDownloadWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerDownload'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerDownloadWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerDownload'][0])
    {
        $request = $this->fileControllerDownloadRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation fileControllerDownloadAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerDownload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerDownloadAsync($id, string $contentType = self::contentTypes['fileControllerDownload'][0])
    {
        return $this->fileControllerDownloadAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation fileControllerDownloadAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerDownload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerDownloadAsyncWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerDownload'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->fileControllerDownloadRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'fileControllerDownload'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerDownload'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerDownloadRequest($id, string $contentType = self::contentTypes['fileControllerDownload'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling fileControllerDownload'
            );
        }

        $resourcePath = '/sync-core/file/{id}/download';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fileControllerFileUploaded.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerFileUploaded'] to see the possible values for this operation
     *
     * @return FileEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerFileUploaded($id, string $contentType = self::contentTypes['fileControllerFileUploaded'][0])
    {
        [$response] = $this->fileControllerFileUploadedWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation fileControllerFileUploadedWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerFileUploaded'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FileEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerFileUploadedWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerFileUploaded'][0])
    {
        $request = $this->fileControllerFileUploadedRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation fileControllerFileUploadedAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerFileUploaded'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerFileUploadedAsync($id, string $contentType = self::contentTypes['fileControllerFileUploaded'][0])
    {
        return $this->fileControllerFileUploadedAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation fileControllerFileUploadedAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerFileUploaded'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerFileUploadedAsyncWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerFileUploaded'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
        $request = $this->fileControllerFileUploadedRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'fileControllerFileUploaded'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerFileUploaded'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerFileUploadedRequest($id, string $contentType = self::contentTypes['fileControllerFileUploaded'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling fileControllerFileUploaded'
            );
        }

        $resourcePath = '/sync-core/file/{id}/uploaded';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'PUT',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fileControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerItem'] to see the possible values for this operation
     *
     * @return FileEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerItem($id, string $contentType = self::contentTypes['fileControllerItem'][0])
    {
        [$response] = $this->fileControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation fileControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FileEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerItem'][0])
    {
        $request = $this->fileControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FileEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation fileControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerItemAsync($id, string $contentType = self::contentTypes['fileControllerItem'][0])
    {
        return $this->fileControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation fileControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FileEntity';
        $request = $this->fileControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'fileControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerItemRequest($id, string $contentType = self::contentTypes['fileControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling fileControllerItem'
            );
        }

        $resourcePath = '/sync-core/file/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation fileControllerPreview.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerPreview'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerPreview($id, string $contentType = self::contentTypes['fileControllerPreview'][0])
    {
        [$response] = $this->fileControllerPreviewWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation fileControllerPreviewWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerPreview'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function fileControllerPreviewWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerPreview'][0])
    {
        $request = $this->fileControllerPreviewRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation fileControllerPreviewAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerPreview'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerPreviewAsync($id, string $contentType = self::contentTypes['fileControllerPreview'][0])
    {
        return $this->fileControllerPreviewAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation fileControllerPreviewAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerPreview'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerPreviewAsyncWithHttpInfo($id, string $contentType = self::contentTypes['fileControllerPreview'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->fileControllerPreviewRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'fileControllerPreview'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['fileControllerPreview'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function fileControllerPreviewRequest($id, string $contentType = self::contentTypes['fileControllerPreview'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling fileControllerPreview'
            );
        }

        $resourcePath = '/sync-core/file/{id}/preview';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation flowControllerCreate.
     *
     * @param  CreateFlowDto $createFlowDto createFlowDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerCreate'] to see the possible values for this operation
     *
     * @return FlowEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerCreate($createFlowDto, string $contentType = self::contentTypes['flowControllerCreate'][0])
    {
        [$response] = $this->flowControllerCreateWithHttpInfo($createFlowDto, $contentType);

        return $response;
    }

    /**
     * Operation flowControllerCreateWithHttpInfo.
     *
     * @param  CreateFlowDto $createFlowDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FlowEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerCreateWithHttpInfo($createFlowDto, string $contentType = self::contentTypes['flowControllerCreate'][0])
    {
        $request = $this->flowControllerCreateRequest($createFlowDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation flowControllerCreateAsync.
     *
     * @param  CreateFlowDto $createFlowDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerCreateAsync($createFlowDto, string $contentType = self::contentTypes['flowControllerCreate'][0])
    {
        return $this->flowControllerCreateAsyncWithHttpInfo($createFlowDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation flowControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateFlowDto $createFlowDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerCreateAsyncWithHttpInfo($createFlowDto, string $contentType = self::contentTypes['flowControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity';
        $request = $this->flowControllerCreateRequest($createFlowDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'flowControllerCreate'.
     *
     * @param  CreateFlowDto $createFlowDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerCreateRequest($createFlowDto, string $contentType = self::contentTypes['flowControllerCreate'][0])
    {
        // verify the required parameter 'createFlowDto' is set
        if (null === $createFlowDto || (is_array($createFlowDto) && 0 === count($createFlowDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createFlowDto when calling flowControllerCreate'
            );
        }

        $resourcePath = '/sync-core/flow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createFlowDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createFlowDto));
            } else {
                $httpBody = $createFlowDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation flowControllerDelete.
     *
     * @param  FlowDeleteRequest $flowDeleteRequest flowDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerDelete'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerDelete($flowDeleteRequest, string $contentType = self::contentTypes['flowControllerDelete'][0])
    {
        [$response] = $this->flowControllerDeleteWithHttpInfo($flowDeleteRequest, $contentType);

        return $response;
    }

    /**
     * Operation flowControllerDeleteWithHttpInfo.
     *
     * @param  FlowDeleteRequest $flowDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerDelete'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerDeleteWithHttpInfo($flowDeleteRequest, string $contentType = self::contentTypes['flowControllerDelete'][0])
    {
        $request = $this->flowControllerDeleteRequest($flowDeleteRequest, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation flowControllerDeleteAsync.
     *
     * @param  FlowDeleteRequest $flowDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerDeleteAsync($flowDeleteRequest, string $contentType = self::contentTypes['flowControllerDelete'][0])
    {
        return $this->flowControllerDeleteAsyncWithHttpInfo($flowDeleteRequest, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation flowControllerDeleteAsyncWithHttpInfo.
     *
     * @param  FlowDeleteRequest $flowDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerDeleteAsyncWithHttpInfo($flowDeleteRequest, string $contentType = self::contentTypes['flowControllerDelete'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->flowControllerDeleteRequest($flowDeleteRequest, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'flowControllerDelete'.
     *
     * @param  FlowDeleteRequest $flowDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerDelete'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerDeleteRequest($flowDeleteRequest, string $contentType = self::contentTypes['flowControllerDelete'][0])
    {
        // verify the required parameter 'flowDeleteRequest' is set
        if (null === $flowDeleteRequest || (is_array($flowDeleteRequest) && 0 === count($flowDeleteRequest))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $flowDeleteRequest when calling flowControllerDelete'
            );
        }

        $resourcePath = '/sync-core/flow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($flowDeleteRequest)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($flowDeleteRequest));
            } else {
                $httpBody = $flowDeleteRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'DELETE',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation flowControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerItem'] to see the possible values for this operation
     *
     * @return FlowEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerItem($id, string $contentType = self::contentTypes['flowControllerItem'][0])
    {
        [$response] = $this->flowControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation flowControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\FlowEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['flowControllerItem'][0])
    {
        $request = $this->flowControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation flowControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerItemAsync($id, string $contentType = self::contentTypes['flowControllerItem'][0])
    {
        return $this->flowControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation flowControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['flowControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\FlowEntity';
        $request = $this->flowControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'flowControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerItemRequest($id, string $contentType = self::contentTypes['flowControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling flowControllerItem'
            );
        }

        $resourcePath = '/sync-core/flow/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation flowControllerList.
     *
     * @param  string $type type (optional)
     * @param  string $poolMachineNames poolMachineNames (optional)
     * @param  string $siteId siteId (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerList'] to see the possible values for this operation
     *
     * @return PagedFlowList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerList($type = null, $poolMachineNames = null, $siteId = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['flowControllerList'][0])
    {
        [$response] = $this->flowControllerListWithHttpInfo($type, $poolMachineNames, $siteId, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation flowControllerListWithHttpInfo.
     *
     * @param  string $type (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $siteId (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function flowControllerListWithHttpInfo($type = null, $poolMachineNames = null, $siteId = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['flowControllerList'][0])
    {
        $request = $this->flowControllerListRequest($type, $poolMachineNames, $siteId, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation flowControllerListAsync.
     *
     * @param  string $type (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $siteId (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerListAsync($type = null, $poolMachineNames = null, $siteId = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['flowControllerList'][0])
    {
        return $this->flowControllerListAsyncWithHttpInfo($type, $poolMachineNames, $siteId, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation flowControllerListAsyncWithHttpInfo.
     *
     * @param  string $type (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $siteId (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerListAsyncWithHttpInfo($type = null, $poolMachineNames = null, $siteId = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['flowControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedFlowList';
        $request = $this->flowControllerListRequest($type, $poolMachineNames, $siteId, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'flowControllerList'.
     *
     * @param  string $type (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $siteId (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['flowControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function flowControllerListRequest($type = null, $poolMachineNames = null, $siteId = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['flowControllerList'][0])
    {
        $resourcePath = '/sync-core/flow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $poolMachineNames,
            'poolMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $siteId,
            'siteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation healthControllerLive.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerLive'] to see the possible values for this operation
     *
     * @return HealthControllerReady200Response|HealthControllerReady503Response
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function healthControllerLive(string $contentType = self::contentTypes['healthControllerLive'][0])
    {
        [$response] = $this->healthControllerLiveWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation healthControllerLiveWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerLive'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response|\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function healthControllerLiveWithHttpInfo(string $contentType = self::contentTypes['healthControllerLive'][0])
    {
        $request = $this->healthControllerLiveRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];

                case 503:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;

                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation healthControllerLiveAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerLive'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerLiveAsync(string $contentType = self::contentTypes['healthControllerLive'][0])
    {
        return $this->healthControllerLiveAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation healthControllerLiveAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerLive'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerLiveAsyncWithHttpInfo(string $contentType = self::contentTypes['healthControllerLive'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response';
        $request = $this->healthControllerLiveRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'healthControllerLive'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerLive'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerLiveRequest(string $contentType = self::contentTypes['healthControllerLive'][0])
    {
        $resourcePath = '/sync-core/healthz/live';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation healthControllerReady.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerReady'] to see the possible values for this operation
     *
     * @return HealthControllerReady200Response|HealthControllerReady503Response
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function healthControllerReady(string $contentType = self::contentTypes['healthControllerReady'][0])
    {
        [$response] = $this->healthControllerReadyWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation healthControllerReadyWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerReady'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response|\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function healthControllerReadyWithHttpInfo(string $contentType = self::contentTypes['healthControllerReady'][0])
    {
        $request = $this->healthControllerReadyRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];

                case 503:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;

                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady503Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation healthControllerReadyAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerReady'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerReadyAsync(string $contentType = self::contentTypes['healthControllerReady'][0])
    {
        return $this->healthControllerReadyAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation healthControllerReadyAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerReady'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerReadyAsyncWithHttpInfo(string $contentType = self::contentTypes['healthControllerReady'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\HealthControllerReady200Response';
        $request = $this->healthControllerReadyRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'healthControllerReady'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['healthControllerReady'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function healthControllerReadyRequest(string $contentType = self::contentTypes['healthControllerReady'][0])
    {
        $resourcePath = '/sync-core/healthz/ready';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation localFileControllerDownload.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerDownload'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function localFileControllerDownload($id, string $contentType = self::contentTypes['localFileControllerDownload'][0])
    {
        [$response] = $this->localFileControllerDownloadWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation localFileControllerDownloadWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerDownload'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function localFileControllerDownloadWithHttpInfo($id, string $contentType = self::contentTypes['localFileControllerDownload'][0])
    {
        $request = $this->localFileControllerDownloadRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation localFileControllerDownloadAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerDownload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerDownloadAsync($id, string $contentType = self::contentTypes['localFileControllerDownload'][0])
    {
        return $this->localFileControllerDownloadAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation localFileControllerDownloadAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerDownload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerDownloadAsyncWithHttpInfo($id, string $contentType = self::contentTypes['localFileControllerDownload'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->localFileControllerDownloadRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'localFileControllerDownload'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerDownload'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerDownloadRequest($id, string $contentType = self::contentTypes['localFileControllerDownload'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling localFileControllerDownload'
            );
        }

        $resourcePath = '/sync-core/file/local/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation localFileControllerUpload.
     *
     * @param  string $id id (required)
     * @param  \SplFileObject $file file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerUpload'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function localFileControllerUpload($id, $file = null, string $contentType = self::contentTypes['localFileControllerUpload'][0])
    {
        [$response] = $this->localFileControllerUploadWithHttpInfo($id, $file, $contentType);

        return $response;
    }

    /**
     * Operation localFileControllerUploadWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerUpload'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function localFileControllerUploadWithHttpInfo($id, $file = null, string $contentType = self::contentTypes['localFileControllerUpload'][0])
    {
        $request = $this->localFileControllerUploadRequest($id, $file, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation localFileControllerUploadAsync.
     *
     * @param  string $id (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerUpload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerUploadAsync($id, $file = null, string $contentType = self::contentTypes['localFileControllerUpload'][0])
    {
        return $this->localFileControllerUploadAsyncWithHttpInfo($id, $file, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation localFileControllerUploadAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerUpload'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerUploadAsyncWithHttpInfo($id, $file = null, string $contentType = self::contentTypes['localFileControllerUpload'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->localFileControllerUploadRequest($id, $file, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'localFileControllerUpload'.
     *
     * @param  string $id (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['localFileControllerUpload'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function localFileControllerUploadRequest($id, $file = null, string $contentType = self::contentTypes['localFileControllerUpload'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling localFileControllerUpload'
            );
        }

        $resourcePath = '/sync-core/file/local/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // form params
        if (null !== $file) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'PUT',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation loggingControllerList.
     *
     * @param  LoggingIdsRequest $loggingIdsRequest loggingIdsRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['loggingControllerList'] to see the possible values for this operation
     *
     * @return LoggingIdsResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function loggingControllerList($loggingIdsRequest, string $contentType = self::contentTypes['loggingControllerList'][0])
    {
        [$response] = $this->loggingControllerListWithHttpInfo($loggingIdsRequest, $contentType);

        return $response;
    }

    /**
     * Operation loggingControllerListWithHttpInfo.
     *
     * @param  LoggingIdsRequest $loggingIdsRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['loggingControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function loggingControllerListWithHttpInfo($loggingIdsRequest, string $contentType = self::contentTypes['loggingControllerList'][0])
    {
        $request = $this->loggingControllerListRequest($loggingIdsRequest, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation loggingControllerListAsync.
     *
     * @param  LoggingIdsRequest $loggingIdsRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['loggingControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function loggingControllerListAsync($loggingIdsRequest, string $contentType = self::contentTypes['loggingControllerList'][0])
    {
        return $this->loggingControllerListAsyncWithHttpInfo($loggingIdsRequest, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation loggingControllerListAsyncWithHttpInfo.
     *
     * @param  LoggingIdsRequest $loggingIdsRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['loggingControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function loggingControllerListAsyncWithHttpInfo($loggingIdsRequest, string $contentType = self::contentTypes['loggingControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\LoggingIdsResponse';
        $request = $this->loggingControllerListRequest($loggingIdsRequest, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'loggingControllerList'.
     *
     * @param  LoggingIdsRequest $loggingIdsRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['loggingControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function loggingControllerListRequest($loggingIdsRequest, string $contentType = self::contentTypes['loggingControllerList'][0])
    {
        // verify the required parameter 'loggingIdsRequest' is set
        if (null === $loggingIdsRequest || (is_array($loggingIdsRequest) && 0 === count($loggingIdsRequest))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $loggingIdsRequest when calling loggingControllerList'
            );
        }

        $resourcePath = '/sync-core/logging/map-ids';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($loggingIdsRequest)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($loggingIdsRequest));
            } else {
                $httpBody = $loggingIdsRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation migrationControllerCreate.
     *
     * @param  CreateMigrationDto $createMigrationDto createMigrationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerCreate'] to see the possible values for this operation
     *
     * @return MigrationEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerCreate($createMigrationDto, string $contentType = self::contentTypes['migrationControllerCreate'][0])
    {
        [$response] = $this->migrationControllerCreateWithHttpInfo($createMigrationDto, $contentType);

        return $response;
    }

    /**
     * Operation migrationControllerCreateWithHttpInfo.
     *
     * @param  CreateMigrationDto $createMigrationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerCreateWithHttpInfo($createMigrationDto, string $contentType = self::contentTypes['migrationControllerCreate'][0])
    {
        $request = $this->migrationControllerCreateRequest($createMigrationDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation migrationControllerCreateAsync.
     *
     * @param  CreateMigrationDto $createMigrationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerCreateAsync($createMigrationDto, string $contentType = self::contentTypes['migrationControllerCreate'][0])
    {
        return $this->migrationControllerCreateAsyncWithHttpInfo($createMigrationDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation migrationControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateMigrationDto $createMigrationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerCreateAsyncWithHttpInfo($createMigrationDto, string $contentType = self::contentTypes['migrationControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
        $request = $this->migrationControllerCreateRequest($createMigrationDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'migrationControllerCreate'.
     *
     * @param  CreateMigrationDto $createMigrationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerCreateRequest($createMigrationDto, string $contentType = self::contentTypes['migrationControllerCreate'][0])
    {
        // verify the required parameter 'createMigrationDto' is set
        if (null === $createMigrationDto || (is_array($createMigrationDto) && 0 === count($createMigrationDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createMigrationDto when calling migrationControllerCreate'
            );
        }

        $resourcePath = '/sync-core/migration';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createMigrationDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createMigrationDto));
            } else {
                $httpBody = $createMigrationDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation migrationControllerDelete.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerDelete'] to see the possible values for this operation
     *
     * @return MigrationEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerDelete($id, string $contentType = self::contentTypes['migrationControllerDelete'][0])
    {
        [$response] = $this->migrationControllerDeleteWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation migrationControllerDeleteWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerDelete'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerDeleteWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerDelete'][0])
    {
        $request = $this->migrationControllerDeleteRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation migrationControllerDeleteAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerDeleteAsync($id, string $contentType = self::contentTypes['migrationControllerDelete'][0])
    {
        return $this->migrationControllerDeleteAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation migrationControllerDeleteAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerDeleteAsyncWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerDelete'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
        $request = $this->migrationControllerDeleteRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'migrationControllerDelete'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerDelete'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerDeleteRequest($id, string $contentType = self::contentTypes['migrationControllerDelete'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling migrationControllerDelete'
            );
        }

        $resourcePath = '/sync-core/migration/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'DELETE',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation migrationControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerItem'] to see the possible values for this operation
     *
     * @return MigrationEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerItem($id, string $contentType = self::contentTypes['migrationControllerItem'][0])
    {
        [$response] = $this->migrationControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation migrationControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerItem'][0])
    {
        $request = $this->migrationControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation migrationControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerItemAsync($id, string $contentType = self::contentTypes['migrationControllerItem'][0])
    {
        return $this->migrationControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation migrationControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationEntity';
        $request = $this->migrationControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'migrationControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerItemRequest($id, string $contentType = self::contentTypes['migrationControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling migrationControllerItem'
            );
        }

        $resourcePath = '/sync-core/migration/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation migrationControllerList.
     *
     * @param  string $groupByEntityTypeAndFlowAndSite groupByEntityTypeAndFlowAndSite (optional)
     * @param  string $entityTypeMachineName entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName entityTypeNamespaceMachineName (optional)
     * @param  string $flowMachineName flowMachineName (optional)
     * @param  string $statuses statuses (optional)
     * @param  string $types types (optional)
     * @param  string $siteUuid siteUuid (optional)
     * @param  string $siteId siteId (optional)
     * @param  string $initialSetup initialSetup (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerList'] to see the possible values for this operation
     *
     * @return PagedMigrationList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerList($groupByEntityTypeAndFlowAndSite = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $flowMachineName = null, $statuses = null, $types = null, $siteUuid = null, $siteId = null, $initialSetup = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['migrationControllerList'][0])
    {
        [$response] = $this->migrationControllerListWithHttpInfo($groupByEntityTypeAndFlowAndSite, $entityTypeMachineName, $entityTypeNamespaceMachineName, $flowMachineName, $statuses, $types, $siteUuid, $siteId, $initialSetup, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation migrationControllerListWithHttpInfo.
     *
     * @param  string $groupByEntityTypeAndFlowAndSite (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $flowMachineName (optional)
     * @param  string $statuses (optional)
     * @param  string $types (optional)
     * @param  string $siteUuid (optional)
     * @param  string $siteId (optional)
     * @param  string $initialSetup (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerListWithHttpInfo($groupByEntityTypeAndFlowAndSite = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $flowMachineName = null, $statuses = null, $types = null, $siteUuid = null, $siteId = null, $initialSetup = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['migrationControllerList'][0])
    {
        $request = $this->migrationControllerListRequest($groupByEntityTypeAndFlowAndSite, $entityTypeMachineName, $entityTypeNamespaceMachineName, $flowMachineName, $statuses, $types, $siteUuid, $siteId, $initialSetup, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation migrationControllerListAsync.
     *
     * @param  string $groupByEntityTypeAndFlowAndSite (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $flowMachineName (optional)
     * @param  string $statuses (optional)
     * @param  string $types (optional)
     * @param  string $siteUuid (optional)
     * @param  string $siteId (optional)
     * @param  string $initialSetup (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerListAsync($groupByEntityTypeAndFlowAndSite = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $flowMachineName = null, $statuses = null, $types = null, $siteUuid = null, $siteId = null, $initialSetup = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['migrationControllerList'][0])
    {
        return $this->migrationControllerListAsyncWithHttpInfo($groupByEntityTypeAndFlowAndSite, $entityTypeMachineName, $entityTypeNamespaceMachineName, $flowMachineName, $statuses, $types, $siteUuid, $siteId, $initialSetup, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation migrationControllerListAsyncWithHttpInfo.
     *
     * @param  string $groupByEntityTypeAndFlowAndSite (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $flowMachineName (optional)
     * @param  string $statuses (optional)
     * @param  string $types (optional)
     * @param  string $siteUuid (optional)
     * @param  string $siteId (optional)
     * @param  string $initialSetup (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerListAsyncWithHttpInfo($groupByEntityTypeAndFlowAndSite = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $flowMachineName = null, $statuses = null, $types = null, $siteUuid = null, $siteId = null, $initialSetup = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['migrationControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedMigrationList';
        $request = $this->migrationControllerListRequest($groupByEntityTypeAndFlowAndSite, $entityTypeMachineName, $entityTypeNamespaceMachineName, $flowMachineName, $statuses, $types, $siteUuid, $siteId, $initialSetup, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'migrationControllerList'.
     *
     * @param  string $groupByEntityTypeAndFlowAndSite (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $flowMachineName (optional)
     * @param  string $statuses (optional)
     * @param  string $types (optional)
     * @param  string $siteUuid (optional)
     * @param  string $siteId (optional)
     * @param  string $initialSetup (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerListRequest($groupByEntityTypeAndFlowAndSite = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $flowMachineName = null, $statuses = null, $types = null, $siteUuid = null, $siteId = null, $initialSetup = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['migrationControllerList'][0])
    {
        $resourcePath = '/sync-core/migration';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $groupByEntityTypeAndFlowAndSite,
            'groupByEntityTypeAndFlowAndSite', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeMachineName,
            'entityTypeMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeNamespaceMachineName,
            'entityTypeNamespaceMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $flowMachineName,
            'flowMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $statuses,
            'statuses', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $types,
            'types', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $siteUuid,
            'siteUuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $siteId,
            'siteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $initialSetup,
            'initialSetup', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation migrationControllerSummary.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerSummary'] to see the possible values for this operation
     *
     * @return MigrationSummary
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerSummary($id, string $contentType = self::contentTypes['migrationControllerSummary'][0])
    {
        [$response] = $this->migrationControllerSummaryWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation migrationControllerSummaryWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerSummary'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function migrationControllerSummaryWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerSummary'][0])
    {
        $request = $this->migrationControllerSummaryRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation migrationControllerSummaryAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerSummary'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerSummaryAsync($id, string $contentType = self::contentTypes['migrationControllerSummary'][0])
    {
        return $this->migrationControllerSummaryAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation migrationControllerSummaryAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerSummary'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerSummaryAsyncWithHttpInfo($id, string $contentType = self::contentTypes['migrationControllerSummary'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\MigrationSummary';
        $request = $this->migrationControllerSummaryRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'migrationControllerSummary'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['migrationControllerSummary'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function migrationControllerSummaryRequest($id, string $contentType = self::contentTypes['migrationControllerSummary'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling migrationControllerSummary'
            );
        }

        $resourcePath = '/sync-core/migration/{id}/summary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation poolControllerCreate.
     *
     * @param  CreatePoolDto $createPoolDto createPoolDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerCreate'] to see the possible values for this operation
     *
     * @return PoolEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerCreate($createPoolDto, string $contentType = self::contentTypes['poolControllerCreate'][0])
    {
        [$response] = $this->poolControllerCreateWithHttpInfo($createPoolDto, $contentType);

        return $response;
    }

    /**
     * Operation poolControllerCreateWithHttpInfo.
     *
     * @param  CreatePoolDto $createPoolDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PoolEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerCreateWithHttpInfo($createPoolDto, string $contentType = self::contentTypes['poolControllerCreate'][0])
    {
        $request = $this->poolControllerCreateRequest($createPoolDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation poolControllerCreateAsync.
     *
     * @param  CreatePoolDto $createPoolDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerCreateAsync($createPoolDto, string $contentType = self::contentTypes['poolControllerCreate'][0])
    {
        return $this->poolControllerCreateAsyncWithHttpInfo($createPoolDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation poolControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreatePoolDto $createPoolDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerCreateAsyncWithHttpInfo($createPoolDto, string $contentType = self::contentTypes['poolControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity';
        $request = $this->poolControllerCreateRequest($createPoolDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'poolControllerCreate'.
     *
     * @param  CreatePoolDto $createPoolDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerCreateRequest($createPoolDto, string $contentType = self::contentTypes['poolControllerCreate'][0])
    {
        // verify the required parameter 'createPoolDto' is set
        if (null === $createPoolDto || (is_array($createPoolDto) && 0 === count($createPoolDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createPoolDto when calling poolControllerCreate'
            );
        }

        $resourcePath = '/sync-core/pool';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createPoolDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createPoolDto));
            } else {
                $httpBody = $createPoolDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation poolControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerItem'] to see the possible values for this operation
     *
     * @return PoolEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerItem($id, string $contentType = self::contentTypes['poolControllerItem'][0])
    {
        [$response] = $this->poolControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation poolControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PoolEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['poolControllerItem'][0])
    {
        $request = $this->poolControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation poolControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerItemAsync($id, string $contentType = self::contentTypes['poolControllerItem'][0])
    {
        return $this->poolControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation poolControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['poolControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity';
        $request = $this->poolControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'poolControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerItemRequest($id, string $contentType = self::contentTypes['poolControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling poolControllerItem'
            );
        }

        $resourcePath = '/sync-core/pool/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation poolControllerList.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerList'] to see the possible values for this operation
     *
     * @return PoolEntity[]
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerList(string $contentType = self::contentTypes['poolControllerList'][0])
    {
        [$response] = $this->poolControllerListWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation poolControllerListWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[], HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function poolControllerListWithHttpInfo(string $contentType = self::contentTypes['poolControllerList'][0])
    {
        $request = $this->poolControllerListRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation poolControllerListAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerListAsync(string $contentType = self::contentTypes['poolControllerList'][0])
    {
        return $this->poolControllerListAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation poolControllerListAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerListAsyncWithHttpInfo(string $contentType = self::contentTypes['poolControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PoolEntity[]';
        $request = $this->poolControllerListRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'poolControllerList'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['poolControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function poolControllerListRequest(string $contentType = self::contentTypes['poolControllerList'][0])
    {
        $resourcePath = '/sync-core/pool';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation previewsControllerList.
     *
     * @param  string $existsLocally existsLocally (optional)
     * @param  string $deletedLocally deletedLocally (optional)
     * @param  string $deleted deleted (optional)
     * @param  string $sourceSiteId sourceSiteId (optional)
     * @param  string $entityTypeMachineNames entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest publishedLatest (optional)
     * @param  string $publishedEarliest publishedEarliest (optional)
     * @param  string $poolMachineNames poolMachineNames (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $page page (optional)
     * @param  string $search search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerList'] to see the possible values for this operation
     *
     * @return PreviewsListResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function previewsControllerList($existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerList'][0])
    {
        [$response] = $this->previewsControllerListWithHttpInfo($existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        return $response;
    }

    /**
     * Operation previewsControllerListWithHttpInfo.
     *
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListWithHttpInfo($existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerList'][0])
    {
        $request = $this->previewsControllerListRequest($existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation previewsControllerListAsync.
     *
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListAsync($existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerList'][0])
    {
        return $this->previewsControllerListAsyncWithHttpInfo($existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation previewsControllerListAsyncWithHttpInfo.
     *
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListAsyncWithHttpInfo($existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse';
        $request = $this->previewsControllerListRequest($existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'previewsControllerList'.
     *
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListRequest($existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerList'][0])
    {
        $resourcePath = '/sync-core/previews';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $existsLocally,
            'existsLocally', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deletedLocally,
            'deletedLocally', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deleted,
            'deleted', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sourceSiteId,
            'sourceSiteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeMachineNames,
            'entityTypeMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeNamespaceMachineNames,
            'entityTypeNamespaceMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $publishedLatest,
            'publishedLatest', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $publishedEarliest,
            'publishedEarliest', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $poolMachineNames,
            'poolMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation previewsControllerListForFlow.
     *
     * @param  string $flowMachineName flowMachineName (required)
     * @param  string $existsLocally existsLocally (optional)
     * @param  string $deletedLocally deletedLocally (optional)
     * @param  string $deleted deleted (optional)
     * @param  string $sourceSiteId sourceSiteId (optional)
     * @param  string $entityTypeMachineNames entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest publishedLatest (optional)
     * @param  string $publishedEarliest publishedEarliest (optional)
     * @param  string $poolMachineNames poolMachineNames (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $page page (optional)
     * @param  string $search search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerListForFlow'] to see the possible values for this operation
     *
     * @return PreviewsListResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListForFlow($flowMachineName, $existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerListForFlow'][0])
    {
        [$response] = $this->previewsControllerListForFlowWithHttpInfo($flowMachineName, $existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        return $response;
    }

    /**
     * Operation previewsControllerListForFlowWithHttpInfo.
     *
     * @param  string $flowMachineName (required)
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerListForFlow'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListForFlowWithHttpInfo($flowMachineName, $existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerListForFlow'][0])
    {
        $request = $this->previewsControllerListForFlowRequest($flowMachineName, $existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation previewsControllerListForFlowAsync.
     *
     * @param  string $flowMachineName (required)
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerListForFlow'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListForFlowAsync($flowMachineName, $existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerListForFlow'][0])
    {
        return $this->previewsControllerListForFlowAsyncWithHttpInfo($flowMachineName, $existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation previewsControllerListForFlowAsyncWithHttpInfo.
     *
     * @param  string $flowMachineName (required)
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerListForFlow'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListForFlowAsyncWithHttpInfo($flowMachineName, $existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerListForFlow'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PreviewsListResponse';
        $request = $this->previewsControllerListForFlowRequest($flowMachineName, $existsLocally, $deletedLocally, $deleted, $sourceSiteId, $entityTypeMachineNames, $entityTypeNamespaceMachineNames, $publishedLatest, $publishedEarliest, $poolMachineNames, $itemsPerPage, $page, $search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'previewsControllerListForFlow'.
     *
     * @param  string $flowMachineName (required)
     * @param  string $existsLocally (optional)
     * @param  string $deletedLocally (optional)
     * @param  string $deleted (optional)
     * @param  string $sourceSiteId (optional)
     * @param  string $entityTypeMachineNames (optional)
     * @param  string $entityTypeNamespaceMachineNames (optional)
     * @param  string $publishedLatest (optional)
     * @param  string $publishedEarliest (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['previewsControllerListForFlow'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function previewsControllerListForFlowRequest($flowMachineName, $existsLocally = null, $deletedLocally = null, $deleted = null, $sourceSiteId = null, $entityTypeMachineNames = null, $entityTypeNamespaceMachineNames = null, $publishedLatest = null, $publishedEarliest = null, $poolMachineNames = null, $itemsPerPage = null, $page = null, $search = null, string $contentType = self::contentTypes['previewsControllerListForFlow'][0])
    {
        // verify the required parameter 'flowMachineName' is set
        if (null === $flowMachineName || (is_array($flowMachineName) && 0 === count($flowMachineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $flowMachineName when calling previewsControllerListForFlow'
            );
        }

        $resourcePath = '/sync-core/previews/{flowMachineName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $existsLocally,
            'existsLocally', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deletedLocally,
            'deletedLocally', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deleted,
            'deleted', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sourceSiteId,
            'sourceSiteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeMachineNames,
            'entityTypeMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeNamespaceMachineNames,
            'entityTypeNamespaceMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $publishedLatest,
            'publishedLatest', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $publishedEarliest,
            'publishedEarliest', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $poolMachineNames,
            'poolMachineNames', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // path params
        if (null !== $flowMachineName) {
            $resourcePath = str_replace(
                '{flowMachineName}',
                ObjectSerializer::toPathValue($flowMachineName),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectControllerGetLanguages.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerGetLanguages'] to see the possible values for this operation
     *
     * @return PagedLanguageDefinitionList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerGetLanguages($id, string $contentType = self::contentTypes['projectControllerGetLanguages'][0])
    {
        [$response] = $this->projectControllerGetLanguagesWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation projectControllerGetLanguagesWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerGetLanguages'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerGetLanguagesWithHttpInfo($id, string $contentType = self::contentTypes['projectControllerGetLanguages'][0])
    {
        $request = $this->projectControllerGetLanguagesRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectControllerGetLanguagesAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerGetLanguages'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerGetLanguagesAsync($id, string $contentType = self::contentTypes['projectControllerGetLanguages'][0])
    {
        return $this->projectControllerGetLanguagesAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectControllerGetLanguagesAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerGetLanguages'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerGetLanguagesAsyncWithHttpInfo($id, string $contentType = self::contentTypes['projectControllerGetLanguages'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedLanguageDefinitionList';
        $request = $this->projectControllerGetLanguagesRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectControllerGetLanguages'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerGetLanguages'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerGetLanguagesRequest($id, string $contentType = self::contentTypes['projectControllerGetLanguages'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling projectControllerGetLanguages'
            );
        }

        $resourcePath = '/sync-core/project/{id}/languages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItem'] to see the possible values for this operation
     *
     * @return ProjectEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerItem($id, string $contentType = self::contentTypes['projectControllerItem'][0])
    {
        [$response] = $this->projectControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation projectControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['projectControllerItem'][0])
    {
        $request = $this->projectControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemAsync($id, string $contentType = self::contentTypes['projectControllerItem'][0])
    {
        return $this->projectControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['projectControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity';
        $request = $this->projectControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemRequest($id, string $contentType = self::contentTypes['projectControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling projectControllerItem'
            );
        }

        $resourcePath = '/sync-core/project/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectControllerItemByUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItemByUuid'] to see the possible values for this operation
     *
     * @return ProjectEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemByUuid($uuid, string $contentType = self::contentTypes['projectControllerItemByUuid'][0])
    {
        [$response] = $this->projectControllerItemByUuidWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation projectControllerItemByUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItemByUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemByUuidWithHttpInfo($uuid, string $contentType = self::contentTypes['projectControllerItemByUuid'][0])
    {
        $request = $this->projectControllerItemByUuidRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectControllerItemByUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemByUuidAsync($uuid, string $contentType = self::contentTypes['projectControllerItemByUuid'][0])
    {
        return $this->projectControllerItemByUuidAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectControllerItemByUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemByUuidAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['projectControllerItemByUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectEntity';
        $request = $this->projectControllerItemByUuidRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectControllerItemByUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectControllerItemByUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectControllerItemByUuidRequest($uuid, string $contentType = self::contentTypes['projectControllerItemByUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling projectControllerItemByUuid'
            );
        }

        $resourcePath = '/sync-core/project/by-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectLinkControllerImport.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerImport'] to see the possible values for this operation
     *
     * @return ProjectLinkEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerImport($uuid, string $contentType = self::contentTypes['projectLinkControllerImport'][0])
    {
        [$response] = $this->projectLinkControllerImportWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation projectLinkControllerImportWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerImport'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerImportWithHttpInfo($uuid, string $contentType = self::contentTypes['projectLinkControllerImport'][0])
    {
        $request = $this->projectLinkControllerImportRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectLinkControllerImportAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerImport'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerImportAsync($uuid, string $contentType = self::contentTypes['projectLinkControllerImport'][0])
    {
        return $this->projectLinkControllerImportAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectLinkControllerImportAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerImport'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerImportAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['projectLinkControllerImport'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
        $request = $this->projectLinkControllerImportRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectLinkControllerImport'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerImport'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerImportRequest($uuid, string $contentType = self::contentTypes['projectLinkControllerImport'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling projectLinkControllerImport'
            );
        }

        $resourcePath = '/sync-core/project-link/import/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectLinkControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItem'] to see the possible values for this operation
     *
     * @return ProjectLinkEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItem($id, string $contentType = self::contentTypes['projectLinkControllerItem'][0])
    {
        [$response] = $this->projectLinkControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation projectLinkControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['projectLinkControllerItem'][0])
    {
        $request = $this->projectLinkControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectLinkControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemAsync($id, string $contentType = self::contentTypes['projectLinkControllerItem'][0])
    {
        return $this->projectLinkControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectLinkControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['projectLinkControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
        $request = $this->projectLinkControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectLinkControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemRequest($id, string $contentType = self::contentTypes['projectLinkControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling projectLinkControllerItem'
            );
        }

        $resourcePath = '/sync-core/project-link/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation projectLinkControllerItemByUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItemByUuid'] to see the possible values for this operation
     *
     * @return ProjectLinkEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemByUuid($uuid, string $contentType = self::contentTypes['projectLinkControllerItemByUuid'][0])
    {
        [$response] = $this->projectLinkControllerItemByUuidWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation projectLinkControllerItemByUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItemByUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemByUuidWithHttpInfo($uuid, string $contentType = self::contentTypes['projectLinkControllerItemByUuid'][0])
    {
        $request = $this->projectLinkControllerItemByUuidRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation projectLinkControllerItemByUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemByUuidAsync($uuid, string $contentType = self::contentTypes['projectLinkControllerItemByUuid'][0])
    {
        return $this->projectLinkControllerItemByUuidAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation projectLinkControllerItemByUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemByUuidAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['projectLinkControllerItemByUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\ProjectLinkEntity';
        $request = $this->projectLinkControllerItemByUuidRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'projectLinkControllerItemByUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['projectLinkControllerItemByUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function projectLinkControllerItemByUuidRequest($uuid, string $contentType = self::contentTypes['projectLinkControllerItemByUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling projectLinkControllerItemByUuid'
            );
        }

        $resourcePath = '/sync-core/project-link/by-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityCloneControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItem'] to see the possible values for this operation
     *
     * @return RemoteEntityCloneEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItem($id, string $contentType = self::contentTypes['remoteEntityCloneControllerItem'][0])
    {
        [$response] = $this->remoteEntityCloneControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityCloneControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityCloneControllerItem'][0])
    {
        $request = $this->remoteEntityCloneControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityCloneControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemAsync($id, string $contentType = self::contentTypes['remoteEntityCloneControllerItem'][0])
    {
        return $this->remoteEntityCloneControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityCloneControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityCloneControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity';
        $request = $this->remoteEntityCloneControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityCloneControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemRequest($id, string $contentType = self::contentTypes['remoteEntityCloneControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityCloneControllerItem'
            );
        }

        $resourcePath = '/sync-core/remote-entity-clone/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityCloneControllerItemByTargetUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $siteId siteId (required)
     * @param  string $entityTypeId entityTypeId (optional)
     * @param  string $flowId flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'] to see the possible values for this operation
     *
     * @return RemoteEntityCloneEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemByTargetUuid($uuid, $siteId, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'][0])
    {
        [$response] = $this->remoteEntityCloneControllerItemByTargetUuidWithHttpInfo($uuid, $siteId, $entityTypeId, $flowId, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityCloneControllerItemByTargetUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemByTargetUuidWithHttpInfo($uuid, $siteId, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'][0])
    {
        $request = $this->remoteEntityCloneControllerItemByTargetUuidRequest($uuid, $siteId, $entityTypeId, $flowId, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityCloneControllerItemByTargetUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemByTargetUuidAsync($uuid, $siteId, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'][0])
    {
        return $this->remoteEntityCloneControllerItemByTargetUuidAsyncWithHttpInfo($uuid, $siteId, $entityTypeId, $flowId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityCloneControllerItemByTargetUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemByTargetUuidAsyncWithHttpInfo($uuid, $siteId, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityCloneEntity';
        $request = $this->remoteEntityCloneControllerItemByTargetUuidRequest($uuid, $siteId, $entityTypeId, $flowId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityCloneControllerItemByTargetUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerItemByTargetUuidRequest($uuid, $siteId, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerItemByTargetUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling remoteEntityCloneControllerItemByTargetUuid'
            );
        }

        // verify the required parameter 'siteId' is set
        if (null === $siteId || (is_array($siteId) && 0 === count($siteId))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $siteId when calling remoteEntityCloneControllerItemByTargetUuid'
            );
        }

        $resourcePath = '/sync-core/remote-entity-clone/site/{siteId}/by-target-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeId,
            'entityTypeId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $flowId,
            'flowId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }
        // path params
        if (null !== $siteId) {
            $resourcePath = str_replace(
                '{siteId}',
                ObjectSerializer::toPathValue($siteId),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityCloneControllerList.
     *
     * @param  string $entityTypeId entityTypeId (optional)
     * @param  string $flowId flowId (optional)
     * @param  string $siteId siteId (optional)
     * @param  string $targetRemoteUniqueId targetRemoteUniqueId (optional)
     * @param  string $sourceRemoteUniqueId sourceRemoteUniqueId (optional)
     * @param  string $targetRemoteUuid targetRemoteUuid (optional)
     * @param  string $sourceRemoteUuid sourceRemoteUuid (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerList'] to see the possible values for this operation
     *
     * @return PagedRemoteEntityCloneListResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerList($entityTypeId = null, $flowId = null, $siteId = null, $targetRemoteUniqueId = null, $sourceRemoteUniqueId = null, $targetRemoteUuid = null, $sourceRemoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityCloneControllerList'][0])
    {
        [$response] = $this->remoteEntityCloneControllerListWithHttpInfo($entityTypeId, $flowId, $siteId, $targetRemoteUniqueId, $sourceRemoteUniqueId, $targetRemoteUuid, $sourceRemoteUuid, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityCloneControllerListWithHttpInfo.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $siteId (optional)
     * @param  string $targetRemoteUniqueId (optional)
     * @param  string $sourceRemoteUniqueId (optional)
     * @param  string $targetRemoteUuid (optional)
     * @param  string $sourceRemoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListWithHttpInfo($entityTypeId = null, $flowId = null, $siteId = null, $targetRemoteUniqueId = null, $sourceRemoteUniqueId = null, $targetRemoteUuid = null, $sourceRemoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityCloneControllerList'][0])
    {
        $request = $this->remoteEntityCloneControllerListRequest($entityTypeId, $flowId, $siteId, $targetRemoteUniqueId, $sourceRemoteUniqueId, $targetRemoteUuid, $sourceRemoteUuid, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityCloneControllerListAsync.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $siteId (optional)
     * @param  string $targetRemoteUniqueId (optional)
     * @param  string $sourceRemoteUniqueId (optional)
     * @param  string $targetRemoteUuid (optional)
     * @param  string $sourceRemoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListAsync($entityTypeId = null, $flowId = null, $siteId = null, $targetRemoteUniqueId = null, $sourceRemoteUniqueId = null, $targetRemoteUuid = null, $sourceRemoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityCloneControllerList'][0])
    {
        return $this->remoteEntityCloneControllerListAsyncWithHttpInfo($entityTypeId, $flowId, $siteId, $targetRemoteUniqueId, $sourceRemoteUniqueId, $targetRemoteUuid, $sourceRemoteUuid, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityCloneControllerListAsyncWithHttpInfo.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $siteId (optional)
     * @param  string $targetRemoteUniqueId (optional)
     * @param  string $sourceRemoteUniqueId (optional)
     * @param  string $targetRemoteUuid (optional)
     * @param  string $sourceRemoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListAsyncWithHttpInfo($entityTypeId = null, $flowId = null, $siteId = null, $targetRemoteUniqueId = null, $sourceRemoteUniqueId = null, $targetRemoteUuid = null, $sourceRemoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityCloneControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse';
        $request = $this->remoteEntityCloneControllerListRequest($entityTypeId, $flowId, $siteId, $targetRemoteUniqueId, $sourceRemoteUniqueId, $targetRemoteUuid, $sourceRemoteUuid, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityCloneControllerList'.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $siteId (optional)
     * @param  string $targetRemoteUniqueId (optional)
     * @param  string $sourceRemoteUniqueId (optional)
     * @param  string $targetRemoteUuid (optional)
     * @param  string $sourceRemoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListRequest($entityTypeId = null, $flowId = null, $siteId = null, $targetRemoteUniqueId = null, $sourceRemoteUniqueId = null, $targetRemoteUuid = null, $sourceRemoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityCloneControllerList'][0])
    {
        $resourcePath = '/sync-core/remote-entity-clone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeId,
            'entityTypeId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $flowId,
            'flowId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $siteId,
            'siteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $targetRemoteUniqueId,
            'targetRemoteUniqueId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sourceRemoteUniqueId,
            'sourceRemoteUniqueId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $targetRemoteUuid,
            'targetRemoteUuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sourceRemoteUuid,
            'sourceRemoteUuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityCloneControllerListBySourceUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $siteId siteId (required)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $page page (optional)
     * @param  string $entityTypeId entityTypeId (optional)
     * @param  string $flowId flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerListBySourceUuid'] to see the possible values for this operation
     *
     * @return PagedRemoteEntityCloneListResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListBySourceUuid($uuid, $siteId, $itemsPerPage = null, $page = null, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerListBySourceUuid'][0])
    {
        [$response] = $this->remoteEntityCloneControllerListBySourceUuidWithHttpInfo($uuid, $siteId, $itemsPerPage, $page, $entityTypeId, $flowId, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityCloneControllerListBySourceUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerListBySourceUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListBySourceUuidWithHttpInfo($uuid, $siteId, $itemsPerPage = null, $page = null, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerListBySourceUuid'][0])
    {
        $request = $this->remoteEntityCloneControllerListBySourceUuidRequest($uuid, $siteId, $itemsPerPage, $page, $entityTypeId, $flowId, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityCloneControllerListBySourceUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerListBySourceUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListBySourceUuidAsync($uuid, $siteId, $itemsPerPage = null, $page = null, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerListBySourceUuid'][0])
    {
        return $this->remoteEntityCloneControllerListBySourceUuidAsyncWithHttpInfo($uuid, $siteId, $itemsPerPage, $page, $entityTypeId, $flowId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityCloneControllerListBySourceUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerListBySourceUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListBySourceUuidAsyncWithHttpInfo($uuid, $siteId, $itemsPerPage = null, $page = null, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerListBySourceUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityCloneListResponse';
        $request = $this->remoteEntityCloneControllerListBySourceUuidRequest($uuid, $siteId, $itemsPerPage, $page, $entityTypeId, $flowId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityCloneControllerListBySourceUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $siteId (required)
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $entityTypeId (optional)
     * @param  string $flowId (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityCloneControllerListBySourceUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityCloneControllerListBySourceUuidRequest($uuid, $siteId, $itemsPerPage = null, $page = null, $entityTypeId = null, $flowId = null, string $contentType = self::contentTypes['remoteEntityCloneControllerListBySourceUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling remoteEntityCloneControllerListBySourceUuid'
            );
        }

        // verify the required parameter 'siteId' is set
        if (null === $siteId || (is_array($siteId) && 0 === count($siteId))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $siteId when calling remoteEntityCloneControllerListBySourceUuid'
            );
        }

        $resourcePath = '/sync-core/remote-entity-clone/site/{siteId}/by-source-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeId,
            'entityTypeId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $flowId,
            'flowId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }
        // path params
        if (null !== $siteId) {
            $resourcePath = str_replace(
                '{siteId}',
                ObjectSerializer::toPathValue($siteId),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerCreate.
     *
     * @param  CreateRemoteEntityRevisionDto $createRemoteEntityRevisionDto createRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerCreate'] to see the possible values for this operation
     *
     * @return RemoteEntityRevisionEntityPushResult
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerCreate($createRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerCreate'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerCreateWithHttpInfo($createRemoteEntityRevisionDto, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerCreateWithHttpInfo.
     *
     * @param  CreateRemoteEntityRevisionDto $createRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerCreateWithHttpInfo($createRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerCreate'][0])
    {
        $request = $this->remoteEntityRevisionControllerCreateRequest($createRemoteEntityRevisionDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerCreateAsync.
     *
     * @param  CreateRemoteEntityRevisionDto $createRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerCreateAsync($createRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerCreate'][0])
    {
        return $this->remoteEntityRevisionControllerCreateAsyncWithHttpInfo($createRemoteEntityRevisionDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateRemoteEntityRevisionDto $createRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerCreateAsyncWithHttpInfo($createRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntityPushResult';
        $request = $this->remoteEntityRevisionControllerCreateRequest($createRemoteEntityRevisionDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerCreate'.
     *
     * @param  CreateRemoteEntityRevisionDto $createRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerCreateRequest($createRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerCreate'][0])
    {
        // verify the required parameter 'createRemoteEntityRevisionDto' is set
        if (null === $createRemoteEntityRevisionDto || (is_array($createRemoteEntityRevisionDto) && 0 === count($createRemoteEntityRevisionDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createRemoteEntityRevisionDto when calling remoteEntityRevisionControllerCreate'
            );
        }

        $resourcePath = '/sync-core/remote-entity-revision';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createRemoteEntityRevisionDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createRemoteEntityRevisionDto));
            } else {
                $httpBody = $createRemoteEntityRevisionDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerDelete.
     *
     * @param  DeleteRemoteEntityRevisionDto $deleteRemoteEntityRevisionDto deleteRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerDelete'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerDelete($deleteRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerDelete'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerDeleteWithHttpInfo($deleteRemoteEntityRevisionDto, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerDeleteWithHttpInfo.
     *
     * @param  DeleteRemoteEntityRevisionDto $deleteRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerDelete'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerDeleteWithHttpInfo($deleteRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerDelete'][0])
    {
        $request = $this->remoteEntityRevisionControllerDeleteRequest($deleteRemoteEntityRevisionDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerDeleteAsync.
     *
     * @param  DeleteRemoteEntityRevisionDto $deleteRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerDeleteAsync($deleteRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerDelete'][0])
    {
        return $this->remoteEntityRevisionControllerDeleteAsyncWithHttpInfo($deleteRemoteEntityRevisionDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerDeleteAsyncWithHttpInfo.
     *
     * @param  DeleteRemoteEntityRevisionDto $deleteRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerDeleteAsyncWithHttpInfo($deleteRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerDelete'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->remoteEntityRevisionControllerDeleteRequest($deleteRemoteEntityRevisionDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerDelete'.
     *
     * @param  DeleteRemoteEntityRevisionDto $deleteRemoteEntityRevisionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerDelete'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerDeleteRequest($deleteRemoteEntityRevisionDto, string $contentType = self::contentTypes['remoteEntityRevisionControllerDelete'][0])
    {
        // verify the required parameter 'deleteRemoteEntityRevisionDto' is set
        if (null === $deleteRemoteEntityRevisionDto || (is_array($deleteRemoteEntityRevisionDto) && 0 === count($deleteRemoteEntityRevisionDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deleteRemoteEntityRevisionDto when calling remoteEntityRevisionControllerDelete'
            );
        }

        $resourcePath = '/sync-core/remote-entity-revision';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($deleteRemoteEntityRevisionDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($deleteRemoteEntityRevisionDto));
            } else {
                $httpBody = $deleteRemoteEntityRevisionDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'DELETE',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerGetTranslationLanguages.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'] to see the possible values for this operation
     *
     * @return PagedTranslationDefinitionList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerGetTranslationLanguages($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerGetTranslationLanguagesWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerGetTranslationLanguagesWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerGetTranslationLanguagesWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'][0])
    {
        $request = $this->remoteEntityRevisionControllerGetTranslationLanguagesRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerGetTranslationLanguagesAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerGetTranslationLanguagesAsync($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'][0])
    {
        return $this->remoteEntityRevisionControllerGetTranslationLanguagesAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerGetTranslationLanguagesAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerGetTranslationLanguagesAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedTranslationDefinitionList';
        $request = $this->remoteEntityRevisionControllerGetTranslationLanguagesRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerGetTranslationLanguages'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerGetTranslationLanguagesRequest($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerGetTranslationLanguages'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityRevisionControllerGetTranslationLanguages'
            );
        }

        $resourcePath = '/sync-core/remote-entity-revision/{id}/translations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerItem'] to see the possible values for this operation
     *
     * @return RemoteEntityRevisionEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerItem($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerItem'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerItem'][0])
    {
        $request = $this->remoteEntityRevisionControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerItemAsync($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerItem'][0])
    {
        return $this->remoteEntityRevisionControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityRevisionEntity';
        $request = $this->remoteEntityRevisionControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerItemRequest($id, string $contentType = self::contentTypes['remoteEntityRevisionControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityRevisionControllerItem'
            );
        }

        $resourcePath = '/sync-core/remote-entity-revision/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerList.
     *
     * @param  string $latest latest (optional)
     * @param  string $forCustomer forCustomer (optional)
     * @param  string $poolMachineName poolMachineName (optional)
     * @param  string $entityTypeMachineName entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName entityTypeNamespaceMachineName (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerList'] to see the possible values for this operation
     *
     * @return PagedRemoteEntityRevisionList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerList($latest = null, $forCustomer = null, $poolMachineName = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerList'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerListWithHttpInfo($latest, $forCustomer, $poolMachineName, $entityTypeMachineName, $entityTypeNamespaceMachineName, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerListWithHttpInfo.
     *
     * @param  string $latest (optional)
     * @param  string $forCustomer (optional)
     * @param  string $poolMachineName (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerListWithHttpInfo($latest = null, $forCustomer = null, $poolMachineName = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerList'][0])
    {
        $request = $this->remoteEntityRevisionControllerListRequest($latest, $forCustomer, $poolMachineName, $entityTypeMachineName, $entityTypeNamespaceMachineName, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerListAsync.
     *
     * @param  string $latest (optional)
     * @param  string $forCustomer (optional)
     * @param  string $poolMachineName (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerListAsync($latest = null, $forCustomer = null, $poolMachineName = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerList'][0])
    {
        return $this->remoteEntityRevisionControllerListAsyncWithHttpInfo($latest, $forCustomer, $poolMachineName, $entityTypeMachineName, $entityTypeNamespaceMachineName, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerListAsyncWithHttpInfo.
     *
     * @param  string $latest (optional)
     * @param  string $forCustomer (optional)
     * @param  string $poolMachineName (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerListAsyncWithHttpInfo($latest = null, $forCustomer = null, $poolMachineName = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityRevisionList';
        $request = $this->remoteEntityRevisionControllerListRequest($latest, $forCustomer, $poolMachineName, $entityTypeMachineName, $entityTypeNamespaceMachineName, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerList'.
     *
     * @param  string $latest (optional)
     * @param  string $forCustomer (optional)
     * @param  string $poolMachineName (optional)
     * @param  string $entityTypeMachineName (optional)
     * @param  string $entityTypeNamespaceMachineName (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerListRequest($latest = null, $forCustomer = null, $poolMachineName = null, $entityTypeMachineName = null, $entityTypeNamespaceMachineName = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerList'][0])
    {
        $resourcePath = '/sync-core/remote-entity-revision';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $latest,
            'latest', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $forCustomer,
            'forCustomer', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $poolMachineName,
            'poolMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeMachineName,
            'entityTypeMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeNamespaceMachineName,
            'entityTypeNamespaceMachineName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityRevisionControllerSerialize.
     *
     * @param  string $id id (required)
     * @param  string $values values (optional)
     * @param  string $structure structure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerSerialize'] to see the possible values for this operation
     *
     * @return string
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerSerialize($id, $values = null, $structure = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerSerialize'][0])
    {
        [$response] = $this->remoteEntityRevisionControllerSerializeWithHttpInfo($id, $values, $structure, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityRevisionControllerSerializeWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $values (optional)
     * @param  string $structure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerSerialize'] to see the possible values for this operation
     *
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerSerializeWithHttpInfo($id, $values = null, $structure = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerSerialize'][0])
    {
        $request = $this->remoteEntityRevisionControllerSerializeRequest($id, $values, $structure, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = 'string';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityRevisionControllerSerializeAsync.
     *
     * @param  string $id (required)
     * @param  string $values (optional)
     * @param  string $structure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerSerialize'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerSerializeAsync($id, $values = null, $structure = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerSerialize'][0])
    {
        return $this->remoteEntityRevisionControllerSerializeAsyncWithHttpInfo($id, $values, $structure, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityRevisionControllerSerializeAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $values (optional)
     * @param  string $structure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerSerialize'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerSerializeAsyncWithHttpInfo($id, $values = null, $structure = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerSerialize'][0])
    {
        $returnType = 'string';
        $request = $this->remoteEntityRevisionControllerSerializeRequest($id, $values, $structure, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityRevisionControllerSerialize'.
     *
     * @param  string $id (required)
     * @param  string $values (optional)
     * @param  string $structure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityRevisionControllerSerialize'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityRevisionControllerSerializeRequest($id, $values = null, $structure = null, string $contentType = self::contentTypes['remoteEntityRevisionControllerSerialize'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityRevisionControllerSerialize'
            );
        }

        $resourcePath = '/sync-core/remote-entity-revision/{id}/serialize';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $values,
            'values', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $structure,
            'structure', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['text/yaml'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeControllerByMachineName.
     *
     * @param  string $machineName machineName (required)
     * @param  string $namespaceMachineName namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerByMachineName'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerByMachineName($machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeControllerByMachineName'][0])
    {
        [$response] = $this->remoteEntityTypeControllerByMachineNameWithHttpInfo($machineName, $namespaceMachineName, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeControllerByMachineNameWithHttpInfo.
     *
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerByMachineName'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerByMachineNameWithHttpInfo($machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeControllerByMachineName'][0])
    {
        $request = $this->remoteEntityTypeControllerByMachineNameRequest($machineName, $namespaceMachineName, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeControllerByMachineNameAsync.
     *
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerByMachineName'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerByMachineNameAsync($machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeControllerByMachineName'][0])
    {
        return $this->remoteEntityTypeControllerByMachineNameAsyncWithHttpInfo($machineName, $namespaceMachineName, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeControllerByMachineNameAsyncWithHttpInfo.
     *
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerByMachineName'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerByMachineNameAsyncWithHttpInfo($machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeControllerByMachineName'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity';
        $request = $this->remoteEntityTypeControllerByMachineNameRequest($machineName, $namespaceMachineName, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeControllerByMachineName'.
     *
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerByMachineName'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerByMachineNameRequest($machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeControllerByMachineName'][0])
    {
        // verify the required parameter 'machineName' is set
        if (null === $machineName || (is_array($machineName) && 0 === count($machineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $machineName when calling remoteEntityTypeControllerByMachineName'
            );
        }

        // verify the required parameter 'namespaceMachineName' is set
        if (null === $namespaceMachineName || (is_array($namespaceMachineName) && 0 === count($namespaceMachineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $namespaceMachineName when calling remoteEntityTypeControllerByMachineName'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type/by-machine-name/{namespaceMachineName}/{machineName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $machineName) {
            $resourcePath = str_replace(
                '{machineName}',
                ObjectSerializer::toPathValue($machineName),
                $resourcePath
            );
        }
        // path params
        if (null !== $namespaceMachineName) {
            $resourcePath = str_replace(
                '{namespaceMachineName}',
                ObjectSerializer::toPathValue($namespaceMachineName),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerItem'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerItem($id, string $contentType = self::contentTypes['remoteEntityTypeControllerItem'][0])
    {
        [$response] = $this->remoteEntityTypeControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityTypeControllerItem'][0])
    {
        $request = $this->remoteEntityTypeControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerItemAsync($id, string $contentType = self::contentTypes['remoteEntityTypeControllerItem'][0])
    {
        return $this->remoteEntityTypeControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityTypeControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity';
        $request = $this->remoteEntityTypeControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerItemRequest($id, string $contentType = self::contentTypes['remoteEntityTypeControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityTypeControllerItem'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeControllerList.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerList'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeEntity[]
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerList(string $contentType = self::contentTypes['remoteEntityTypeControllerList'][0])
    {
        [$response] = $this->remoteEntityTypeControllerListWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeControllerListWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[], HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerListWithHttpInfo(string $contentType = self::contentTypes['remoteEntityTypeControllerList'][0])
    {
        $request = $this->remoteEntityTypeControllerListRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeControllerListAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerListAsync(string $contentType = self::contentTypes['remoteEntityTypeControllerList'][0])
    {
        return $this->remoteEntityTypeControllerListAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeControllerListAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerListAsyncWithHttpInfo(string $contentType = self::contentTypes['remoteEntityTypeControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeEntity[]';
        $request = $this->remoteEntityTypeControllerListRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeControllerList'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeControllerListRequest(string $contentType = self::contentTypes['remoteEntityTypeControllerList'][0])
    {
        $resourcePath = '/sync-core/remote-entity-type';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeVersionControllerCreate.
     *
     * @param  CreateRemoteEntityTypeVersionDto $createRemoteEntityTypeVersionDto createRemoteEntityTypeVersionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerCreate'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeVersionEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerCreate($createRemoteEntityTypeVersionDto, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerCreate'][0])
    {
        [$response] = $this->remoteEntityTypeVersionControllerCreateWithHttpInfo($createRemoteEntityTypeVersionDto, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeVersionControllerCreateWithHttpInfo.
     *
     * @param  CreateRemoteEntityTypeVersionDto $createRemoteEntityTypeVersionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerCreateWithHttpInfo($createRemoteEntityTypeVersionDto, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerCreate'][0])
    {
        $request = $this->remoteEntityTypeVersionControllerCreateRequest($createRemoteEntityTypeVersionDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeVersionControllerCreateAsync.
     *
     * @param  CreateRemoteEntityTypeVersionDto $createRemoteEntityTypeVersionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerCreateAsync($createRemoteEntityTypeVersionDto, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerCreate'][0])
    {
        return $this->remoteEntityTypeVersionControllerCreateAsyncWithHttpInfo($createRemoteEntityTypeVersionDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeVersionControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateRemoteEntityTypeVersionDto $createRemoteEntityTypeVersionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerCreateAsyncWithHttpInfo($createRemoteEntityTypeVersionDto, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
        $request = $this->remoteEntityTypeVersionControllerCreateRequest($createRemoteEntityTypeVersionDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeVersionControllerCreate'.
     *
     * @param  CreateRemoteEntityTypeVersionDto $createRemoteEntityTypeVersionDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerCreateRequest($createRemoteEntityTypeVersionDto, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerCreate'][0])
    {
        // verify the required parameter 'createRemoteEntityTypeVersionDto' is set
        if (null === $createRemoteEntityTypeVersionDto || (is_array($createRemoteEntityTypeVersionDto) && 0 === count($createRemoteEntityTypeVersionDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createRemoteEntityTypeVersionDto when calling remoteEntityTypeVersionControllerCreate'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type-version';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createRemoteEntityTypeVersionDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createRemoteEntityTypeVersionDto));
            } else {
                $httpBody = $createRemoteEntityTypeVersionDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeVersionControllerGetVersionUsage.
     *
     * @param  string $versionId versionId (required)
     * @param  string $machineName machineName (required)
     * @param  string $namespaceMachineName namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'] to see the possible values for this operation
     *
     * @return EntityTypeVersionUsage
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerGetVersionUsage($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'][0])
    {
        [$response] = $this->remoteEntityTypeVersionControllerGetVersionUsageWithHttpInfo($versionId, $machineName, $namespaceMachineName, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeVersionControllerGetVersionUsageWithHttpInfo.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerGetVersionUsageWithHttpInfo($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'][0])
    {
        $request = $this->remoteEntityTypeVersionControllerGetVersionUsageRequest($versionId, $machineName, $namespaceMachineName, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeVersionControllerGetVersionUsageAsync.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerGetVersionUsageAsync($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'][0])
    {
        return $this->remoteEntityTypeVersionControllerGetVersionUsageAsyncWithHttpInfo($versionId, $machineName, $namespaceMachineName, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeVersionControllerGetVersionUsageAsyncWithHttpInfo.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerGetVersionUsageAsyncWithHttpInfo($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\EntityTypeVersionUsage';
        $request = $this->remoteEntityTypeVersionControllerGetVersionUsageRequest($versionId, $machineName, $namespaceMachineName, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeVersionControllerGetVersionUsage'.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerGetVersionUsageRequest($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerGetVersionUsage'][0])
    {
        // verify the required parameter 'versionId' is set
        if (null === $versionId || (is_array($versionId) && 0 === count($versionId))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $versionId when calling remoteEntityTypeVersionControllerGetVersionUsage'
            );
        }

        // verify the required parameter 'machineName' is set
        if (null === $machineName || (is_array($machineName) && 0 === count($machineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $machineName when calling remoteEntityTypeVersionControllerGetVersionUsage'
            );
        }

        // verify the required parameter 'namespaceMachineName' is set
        if (null === $namespaceMachineName || (is_array($namespaceMachineName) && 0 === count($namespaceMachineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $namespaceMachineName when calling remoteEntityTypeVersionControllerGetVersionUsage'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type-version/differences/{namespaceMachineName}/{machineName}/{versionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $versionId) {
            $resourcePath = str_replace(
                '{versionId}',
                ObjectSerializer::toPathValue($versionId),
                $resourcePath
            );
        }
        // path params
        if (null !== $machineName) {
            $resourcePath = str_replace(
                '{machineName}',
                ObjectSerializer::toPathValue($machineName),
                $resourcePath
            );
        }
        // path params
        if (null !== $namespaceMachineName) {
            $resourcePath = str_replace(
                '{namespaceMachineName}',
                ObjectSerializer::toPathValue($namespaceMachineName),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeVersionControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItem'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeVersionEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItem($id, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItem'][0])
    {
        [$response] = $this->remoteEntityTypeVersionControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItem'][0])
    {
        $request = $this->remoteEntityTypeVersionControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemAsync($id, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItem'][0])
    {
        return $this->remoteEntityTypeVersionControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
        $request = $this->remoteEntityTypeVersionControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeVersionControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemRequest($id, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityTypeVersionControllerItem'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type-version/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemByMachineName.
     *
     * @param  string $versionId versionId (required)
     * @param  string $machineName machineName (required)
     * @param  string $namespaceMachineName namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'] to see the possible values for this operation
     *
     * @return RemoteEntityTypeVersionEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemByMachineName($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'][0])
    {
        [$response] = $this->remoteEntityTypeVersionControllerItemByMachineNameWithHttpInfo($versionId, $machineName, $namespaceMachineName, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemByMachineNameWithHttpInfo.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemByMachineNameWithHttpInfo($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'][0])
    {
        $request = $this->remoteEntityTypeVersionControllerItemByMachineNameRequest($versionId, $machineName, $namespaceMachineName, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemByMachineNameAsync.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemByMachineNameAsync($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'][0])
    {
        return $this->remoteEntityTypeVersionControllerItemByMachineNameAsyncWithHttpInfo($versionId, $machineName, $namespaceMachineName, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityTypeVersionControllerItemByMachineNameAsyncWithHttpInfo.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemByMachineNameAsyncWithHttpInfo($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityTypeVersionEntity';
        $request = $this->remoteEntityTypeVersionControllerItemByMachineNameRequest($versionId, $machineName, $namespaceMachineName, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityTypeVersionControllerItemByMachineName'.
     *
     * @param  string $versionId (required)
     * @param  string $machineName (required)
     * @param  string $namespaceMachineName (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityTypeVersionControllerItemByMachineNameRequest($versionId, $machineName, $namespaceMachineName, string $contentType = self::contentTypes['remoteEntityTypeVersionControllerItemByMachineName'][0])
    {
        // verify the required parameter 'versionId' is set
        if (null === $versionId || (is_array($versionId) && 0 === count($versionId))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $versionId when calling remoteEntityTypeVersionControllerItemByMachineName'
            );
        }

        // verify the required parameter 'machineName' is set
        if (null === $machineName || (is_array($machineName) && 0 === count($machineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $machineName when calling remoteEntityTypeVersionControllerItemByMachineName'
            );
        }

        // verify the required parameter 'namespaceMachineName' is set
        if (null === $namespaceMachineName || (is_array($namespaceMachineName) && 0 === count($namespaceMachineName))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $namespaceMachineName when calling remoteEntityTypeVersionControllerItemByMachineName'
            );
        }

        $resourcePath = '/sync-core/remote-entity-type-version/by-machine-name/{namespaceMachineName}/{machineName}/{versionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $versionId) {
            $resourcePath = str_replace(
                '{versionId}',
                ObjectSerializer::toPathValue($versionId),
                $resourcePath
            );
        }
        // path params
        if (null !== $machineName) {
            $resourcePath = str_replace(
                '{machineName}',
                ObjectSerializer::toPathValue($machineName),
                $resourcePath
            );
        }
        // path params
        if (null !== $namespaceMachineName) {
            $resourcePath = str_replace(
                '{namespaceMachineName}',
                ObjectSerializer::toPathValue($namespaceMachineName),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityUsageControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerItem'] to see the possible values for this operation
     *
     * @return RemoteEntityUsageEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerItem($id, string $contentType = self::contentTypes['remoteEntityUsageControllerItem'][0])
    {
        [$response] = $this->remoteEntityUsageControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityUsageControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityUsageControllerItem'][0])
    {
        $request = $this->remoteEntityUsageControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityUsageControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerItemAsync($id, string $contentType = self::contentTypes['remoteEntityUsageControllerItem'][0])
    {
        return $this->remoteEntityUsageControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityUsageControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['remoteEntityUsageControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\RemoteEntityUsageEntity';
        $request = $this->remoteEntityUsageControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityUsageControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerItemRequest($id, string $contentType = self::contentTypes['remoteEntityUsageControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling remoteEntityUsageControllerItem'
            );
        }

        $resourcePath = '/sync-core/remote-entity-usage/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation remoteEntityUsageControllerList.
     *
     * @param  string $entityTypeId entityTypeId (optional)
     * @param  string $siteId siteId (optional)
     * @param  string $entityId entityId (optional)
     * @param  string $remoteUniqueId remoteUniqueId (optional)
     * @param  string $remoteUuid remoteUuid (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerList'] to see the possible values for this operation
     *
     * @return PagedRemoteEntityUsageListResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerList($entityTypeId = null, $siteId = null, $entityId = null, $remoteUniqueId = null, $remoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityUsageControllerList'][0])
    {
        [$response] = $this->remoteEntityUsageControllerListWithHttpInfo($entityTypeId, $siteId, $entityId, $remoteUniqueId, $remoteUuid, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation remoteEntityUsageControllerListWithHttpInfo.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $siteId (optional)
     * @param  string $entityId (optional)
     * @param  string $remoteUniqueId (optional)
     * @param  string $remoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerListWithHttpInfo($entityTypeId = null, $siteId = null, $entityId = null, $remoteUniqueId = null, $remoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityUsageControllerList'][0])
    {
        $request = $this->remoteEntityUsageControllerListRequest($entityTypeId, $siteId, $entityId, $remoteUniqueId, $remoteUuid, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation remoteEntityUsageControllerListAsync.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $siteId (optional)
     * @param  string $entityId (optional)
     * @param  string $remoteUniqueId (optional)
     * @param  string $remoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerListAsync($entityTypeId = null, $siteId = null, $entityId = null, $remoteUniqueId = null, $remoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityUsageControllerList'][0])
    {
        return $this->remoteEntityUsageControllerListAsyncWithHttpInfo($entityTypeId, $siteId, $entityId, $remoteUniqueId, $remoteUuid, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation remoteEntityUsageControllerListAsyncWithHttpInfo.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $siteId (optional)
     * @param  string $entityId (optional)
     * @param  string $remoteUniqueId (optional)
     * @param  string $remoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerListAsyncWithHttpInfo($entityTypeId = null, $siteId = null, $entityId = null, $remoteUniqueId = null, $remoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityUsageControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRemoteEntityUsageListResponse';
        $request = $this->remoteEntityUsageControllerListRequest($entityTypeId, $siteId, $entityId, $remoteUniqueId, $remoteUuid, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'remoteEntityUsageControllerList'.
     *
     * @param  string $entityTypeId (optional)
     * @param  string $siteId (optional)
     * @param  string $entityId (optional)
     * @param  string $remoteUniqueId (optional)
     * @param  string $remoteUuid (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['remoteEntityUsageControllerList'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function remoteEntityUsageControllerListRequest($entityTypeId = null, $siteId = null, $entityId = null, $remoteUniqueId = null, $remoteUuid = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['remoteEntityUsageControllerList'][0])
    {
        $resourcePath = '/sync-core/remote-entity-usage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityTypeId,
            'entityTypeId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $siteId,
            'siteId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entityId,
            'entityId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $remoteUniqueId,
            'remoteUniqueId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $remoteUuid,
            'remoteUuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerGetRequests.
     *
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $page page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetRequests'] to see the possible values for this operation
     *
     * @return PagedRequestList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetRequests($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['siteControllerGetRequests'][0])
    {
        [$response] = $this->siteControllerGetRequestsWithHttpInfo($itemsPerPage, $page, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerGetRequestsWithHttpInfo.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetRequests'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetRequestsWithHttpInfo($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['siteControllerGetRequests'][0])
    {
        $request = $this->siteControllerGetRequestsRequest($itemsPerPage, $page, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerGetRequestsAsync.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetRequests'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetRequestsAsync($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['siteControllerGetRequests'][0])
    {
        return $this->siteControllerGetRequestsAsyncWithHttpInfo($itemsPerPage, $page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerGetRequestsAsyncWithHttpInfo.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetRequests'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetRequestsAsyncWithHttpInfo($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['siteControllerGetRequests'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedRequestList';
        $request = $this->siteControllerGetRequestsRequest($itemsPerPage, $page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerGetRequests'.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetRequests'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetRequestsRequest($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['siteControllerGetRequests'][0])
    {
        $resourcePath = '/sync-core/site/requests';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerGetThrottling.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetThrottling'] to see the possible values for this operation
     *
     * @return GetThrottlingDto
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetThrottling(string $contentType = self::contentTypes['siteControllerGetThrottling'][0])
    {
        [$response] = $this->siteControllerGetThrottlingWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation siteControllerGetThrottlingWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetThrottling'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetThrottlingWithHttpInfo(string $contentType = self::contentTypes['siteControllerGetThrottling'][0])
    {
        $request = $this->siteControllerGetThrottlingRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerGetThrottlingAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetThrottling'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetThrottlingAsync(string $contentType = self::contentTypes['siteControllerGetThrottling'][0])
    {
        return $this->siteControllerGetThrottlingAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerGetThrottlingAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetThrottling'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetThrottlingAsyncWithHttpInfo(string $contentType = self::contentTypes['siteControllerGetThrottling'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto';
        $request = $this->siteControllerGetThrottlingRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerGetThrottling'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerGetThrottling'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerGetThrottlingRequest(string $contentType = self::contentTypes['siteControllerGetThrottling'][0])
    {
        $resourcePath = '/sync-core/site/throttling';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItem'] to see the possible values for this operation
     *
     * @return SmallSiteEntityWithDetails
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerItem($id, string $contentType = self::contentTypes['siteControllerItem'][0])
    {
        [$response] = $this->siteControllerItemWithHttpInfo($id, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemWithHttpInfo($id, string $contentType = self::contentTypes['siteControllerItem'][0])
    {
        $request = $this->siteControllerItemRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemAsync($id, string $contentType = self::contentTypes['siteControllerItem'][0])
    {
        return $this->siteControllerItemAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemAsyncWithHttpInfo($id, string $contentType = self::contentTypes['siteControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails';
        $request = $this->siteControllerItemRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemRequest($id, string $contentType = self::contentTypes['siteControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling siteControllerItem'
            );
        }

        $resourcePath = '/sync-core/site/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerItemByUuid.
     *
     * @param  string $uuid uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItemByUuid'] to see the possible values for this operation
     *
     * @return SmallSiteEntityWithDetails
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemByUuid($uuid, string $contentType = self::contentTypes['siteControllerItemByUuid'][0])
    {
        [$response] = $this->siteControllerItemByUuidWithHttpInfo($uuid, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerItemByUuidWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItemByUuid'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemByUuidWithHttpInfo($uuid, string $contentType = self::contentTypes['siteControllerItemByUuid'][0])
    {
        $request = $this->siteControllerItemByUuidRequest($uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerItemByUuidAsync.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemByUuidAsync($uuid, string $contentType = self::contentTypes['siteControllerItemByUuid'][0])
    {
        return $this->siteControllerItemByUuidAsyncWithHttpInfo($uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerItemByUuidAsyncWithHttpInfo.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItemByUuid'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemByUuidAsyncWithHttpInfo($uuid, string $contentType = self::contentTypes['siteControllerItemByUuid'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SmallSiteEntityWithDetails';
        $request = $this->siteControllerItemByUuidRequest($uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerItemByUuid'.
     *
     * @param  string $uuid (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerItemByUuid'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerItemByUuidRequest($uuid, string $contentType = self::contentTypes['siteControllerItemByUuid'][0])
    {
        // verify the required parameter 'uuid' is set
        if (null === $uuid || (is_array($uuid) && 0 === count($uuid))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $uuid when calling siteControllerItemByUuid'
            );
        }

        $resourcePath = '/sync-core/site/by-uuid/{uuid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $uuid) {
            $resourcePath = str_replace(
                '{uuid}',
                ObjectSerializer::toPathValue($uuid),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerRegister.
     *
     * @param  RegisterSiteDto $registerSiteDto registerSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegister'] to see the possible values for this operation
     *
     * @return SiteEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegister($registerSiteDto, string $contentType = self::contentTypes['siteControllerRegister'][0])
    {
        [$response] = $this->siteControllerRegisterWithHttpInfo($registerSiteDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerRegisterWithHttpInfo.
     *
     * @param  RegisterSiteDto $registerSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegister'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SiteEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterWithHttpInfo($registerSiteDto, string $contentType = self::contentTypes['siteControllerRegister'][0])
    {
        $request = $this->siteControllerRegisterRequest($registerSiteDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerRegisterAsync.
     *
     * @param  RegisterSiteDto $registerSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegister'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterAsync($registerSiteDto, string $contentType = self::contentTypes['siteControllerRegister'][0])
    {
        return $this->siteControllerRegisterAsyncWithHttpInfo($registerSiteDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerRegisterAsyncWithHttpInfo.
     *
     * @param  RegisterSiteDto $registerSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegister'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterAsyncWithHttpInfo($registerSiteDto, string $contentType = self::contentTypes['siteControllerRegister'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
        $request = $this->siteControllerRegisterRequest($registerSiteDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerRegister'.
     *
     * @param  RegisterSiteDto $registerSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegister'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterRequest($registerSiteDto, string $contentType = self::contentTypes['siteControllerRegister'][0])
    {
        // verify the required parameter 'registerSiteDto' is set
        if (null === $registerSiteDto || (is_array($registerSiteDto) && 0 === count($registerSiteDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $registerSiteDto when calling siteControllerRegister'
            );
        }

        $resourcePath = '/sync-core/site';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($registerSiteDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($registerSiteDto));
            } else {
                $httpBody = $registerSiteDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerRegisterNew.
     *
     * @param  RegisterNewSiteDto $registerNewSiteDto registerNewSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegisterNew'] to see the possible values for this operation
     *
     * @return SiteEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterNew($registerNewSiteDto, string $contentType = self::contentTypes['siteControllerRegisterNew'][0])
    {
        [$response] = $this->siteControllerRegisterNewWithHttpInfo($registerNewSiteDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerRegisterNewWithHttpInfo.
     *
     * @param  RegisterNewSiteDto $registerNewSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegisterNew'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SiteEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterNewWithHttpInfo($registerNewSiteDto, string $contentType = self::contentTypes['siteControllerRegisterNew'][0])
    {
        $request = $this->siteControllerRegisterNewRequest($registerNewSiteDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerRegisterNewAsync.
     *
     * @param  RegisterNewSiteDto $registerNewSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegisterNew'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterNewAsync($registerNewSiteDto, string $contentType = self::contentTypes['siteControllerRegisterNew'][0])
    {
        return $this->siteControllerRegisterNewAsyncWithHttpInfo($registerNewSiteDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerRegisterNewAsyncWithHttpInfo.
     *
     * @param  RegisterNewSiteDto $registerNewSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegisterNew'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterNewAsyncWithHttpInfo($registerNewSiteDto, string $contentType = self::contentTypes['siteControllerRegisterNew'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
        $request = $this->siteControllerRegisterNewRequest($registerNewSiteDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerRegisterNew'.
     *
     * @param  RegisterNewSiteDto $registerNewSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRegisterNew'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRegisterNewRequest($registerNewSiteDto, string $contentType = self::contentTypes['siteControllerRegisterNew'][0])
    {
        // verify the required parameter 'registerNewSiteDto' is set
        if (null === $registerNewSiteDto || (is_array($registerNewSiteDto) && 0 === count($registerNewSiteDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $registerNewSiteDto when calling siteControllerRegisterNew'
            );
        }

        $resourcePath = '/sync-core/site/new';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($registerNewSiteDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($registerNewSiteDto));
            } else {
                $httpBody = $registerNewSiteDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerRespondToRequest.
     *
     * @param  string $id id (required)
     * @param  RequestResponseDto $requestResponseDto requestResponseDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRespondToRequest'] to see the possible values for this operation
     *
     * @return SuccessResponse
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRespondToRequest($id, $requestResponseDto, string $contentType = self::contentTypes['siteControllerRespondToRequest'][0])
    {
        [$response] = $this->siteControllerRespondToRequestWithHttpInfo($id, $requestResponseDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerRespondToRequestWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  RequestResponseDto $requestResponseDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRespondToRequest'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerRespondToRequestWithHttpInfo($id, $requestResponseDto, string $contentType = self::contentTypes['siteControllerRespondToRequest'][0])
    {
        $request = $this->siteControllerRespondToRequestRequest($id, $requestResponseDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerRespondToRequestAsync.
     *
     * @param  string $id (required)
     * @param  RequestResponseDto $requestResponseDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRespondToRequest'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRespondToRequestAsync($id, $requestResponseDto, string $contentType = self::contentTypes['siteControllerRespondToRequest'][0])
    {
        return $this->siteControllerRespondToRequestAsyncWithHttpInfo($id, $requestResponseDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerRespondToRequestAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  RequestResponseDto $requestResponseDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRespondToRequest'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRespondToRequestAsyncWithHttpInfo($id, $requestResponseDto, string $contentType = self::contentTypes['siteControllerRespondToRequest'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SuccessResponse';
        $request = $this->siteControllerRespondToRequestRequest($id, $requestResponseDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerRespondToRequest'.
     *
     * @param  string $id (required)
     * @param  RequestResponseDto $requestResponseDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerRespondToRequest'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerRespondToRequestRequest($id, $requestResponseDto, string $contentType = self::contentTypes['siteControllerRespondToRequest'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling siteControllerRespondToRequest'
            );
        }

        // verify the required parameter 'requestResponseDto' is set
        if (null === $requestResponseDto || (is_array($requestResponseDto) && 0 === count($requestResponseDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $requestResponseDto when calling siteControllerRespondToRequest'
            );
        }

        $resourcePath = '/sync-core/site/requests/{id}/respond';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($requestResponseDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($requestResponseDto));
            } else {
                $httpBody = $requestResponseDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerSearch.
     *
     * @param  string $baseUrl baseUrl (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $search search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSearch'] to see the possible values for this operation
     *
     * @return PagedSiteList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSearch($baseUrl = null, $page = null, $itemsPerPage = null, $search = null, string $contentType = self::contentTypes['siteControllerSearch'][0])
    {
        [$response] = $this->siteControllerSearchWithHttpInfo($baseUrl, $page, $itemsPerPage, $search, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerSearchWithHttpInfo.
     *
     * @param  string $baseUrl (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSearch'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSearchWithHttpInfo($baseUrl = null, $page = null, $itemsPerPage = null, $search = null, string $contentType = self::contentTypes['siteControllerSearch'][0])
    {
        $request = $this->siteControllerSearchRequest($baseUrl, $page, $itemsPerPage, $search, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerSearchAsync.
     *
     * @param  string $baseUrl (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSearch'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSearchAsync($baseUrl = null, $page = null, $itemsPerPage = null, $search = null, string $contentType = self::contentTypes['siteControllerSearch'][0])
    {
        return $this->siteControllerSearchAsyncWithHttpInfo($baseUrl, $page, $itemsPerPage, $search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerSearchAsyncWithHttpInfo.
     *
     * @param  string $baseUrl (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSearch'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSearchAsyncWithHttpInfo($baseUrl = null, $page = null, $itemsPerPage = null, $search = null, string $contentType = self::contentTypes['siteControllerSearch'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedSiteList';
        $request = $this->siteControllerSearchRequest($baseUrl, $page, $itemsPerPage, $search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerSearch'.
     *
     * @param  string $baseUrl (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSearch'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSearchRequest($baseUrl = null, $page = null, $itemsPerPage = null, $search = null, string $contentType = self::contentTypes['siteControllerSearch'][0])
    {
        $resourcePath = '/sync-core/site';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $baseUrl,
            'baseUrl', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerSelf.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSelf'] to see the possible values for this operation
     *
     * @return SiteSelfDto
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSelf(string $contentType = self::contentTypes['siteControllerSelf'][0])
    {
        [$response] = $this->siteControllerSelfWithHttpInfo($contentType);

        return $response;
    }

    /**
     * Operation siteControllerSelfWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSelf'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSelfWithHttpInfo(string $contentType = self::contentTypes['siteControllerSelf'][0])
    {
        $request = $this->siteControllerSelfRequest($contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerSelfAsync.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSelf'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSelfAsync(string $contentType = self::contentTypes['siteControllerSelf'][0])
    {
        return $this->siteControllerSelfAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerSelfAsyncWithHttpInfo.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSelf'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSelfAsyncWithHttpInfo(string $contentType = self::contentTypes['siteControllerSelf'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteSelfDto';
        $request = $this->siteControllerSelfRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerSelf'.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSelf'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSelfRequest(string $contentType = self::contentTypes['siteControllerSelf'][0])
    {
        $resourcePath = '/sync-core/site/self';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerSetThrottling.
     *
     * @param  SetThrottlingDto $setThrottlingDto setThrottlingDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSetThrottling'] to see the possible values for this operation
     *
     * @return GetThrottlingDto
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSetThrottling($setThrottlingDto, string $contentType = self::contentTypes['siteControllerSetThrottling'][0])
    {
        [$response] = $this->siteControllerSetThrottlingWithHttpInfo($setThrottlingDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerSetThrottlingWithHttpInfo.
     *
     * @param  SetThrottlingDto $setThrottlingDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSetThrottling'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerSetThrottlingWithHttpInfo($setThrottlingDto, string $contentType = self::contentTypes['siteControllerSetThrottling'][0])
    {
        $request = $this->siteControllerSetThrottlingRequest($setThrottlingDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerSetThrottlingAsync.
     *
     * @param  SetThrottlingDto $setThrottlingDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSetThrottling'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSetThrottlingAsync($setThrottlingDto, string $contentType = self::contentTypes['siteControllerSetThrottling'][0])
    {
        return $this->siteControllerSetThrottlingAsyncWithHttpInfo($setThrottlingDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerSetThrottlingAsyncWithHttpInfo.
     *
     * @param  SetThrottlingDto $setThrottlingDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSetThrottling'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSetThrottlingAsyncWithHttpInfo($setThrottlingDto, string $contentType = self::contentTypes['siteControllerSetThrottling'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\GetThrottlingDto';
        $request = $this->siteControllerSetThrottlingRequest($setThrottlingDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerSetThrottling'.
     *
     * @param  SetThrottlingDto $setThrottlingDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerSetThrottling'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerSetThrottlingRequest($setThrottlingDto, string $contentType = self::contentTypes['siteControllerSetThrottling'][0])
    {
        // verify the required parameter 'setThrottlingDto' is set
        if (null === $setThrottlingDto || (is_array($setThrottlingDto) && 0 === count($setThrottlingDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setThrottlingDto when calling siteControllerSetThrottling'
            );
        }

        $resourcePath = '/sync-core/site/throttling';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setThrottlingDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($setThrottlingDto));
            } else {
                $httpBody = $setThrottlingDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerUpdate.
     *
     * @param  CreateSiteDto $createSiteDto createSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdate'] to see the possible values for this operation
     *
     * @return SiteEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdate($createSiteDto, string $contentType = self::contentTypes['siteControllerUpdate'][0])
    {
        [$response] = $this->siteControllerUpdateWithHttpInfo($createSiteDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerUpdateWithHttpInfo.
     *
     * @param  CreateSiteDto $createSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SiteEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateWithHttpInfo($createSiteDto, string $contentType = self::contentTypes['siteControllerUpdate'][0])
    {
        $request = $this->siteControllerUpdateRequest($createSiteDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerUpdateAsync.
     *
     * @param  CreateSiteDto $createSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateAsync($createSiteDto, string $contentType = self::contentTypes['siteControllerUpdate'][0])
    {
        return $this->siteControllerUpdateAsyncWithHttpInfo($createSiteDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerUpdateAsyncWithHttpInfo.
     *
     * @param  CreateSiteDto $createSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateAsyncWithHttpInfo($createSiteDto, string $contentType = self::contentTypes['siteControllerUpdate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SiteEntity';
        $request = $this->siteControllerUpdateRequest($createSiteDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerUpdate'.
     *
     * @param  CreateSiteDto $createSiteDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateRequest($createSiteDto, string $contentType = self::contentTypes['siteControllerUpdate'][0])
    {
        // verify the required parameter 'createSiteDto' is set
        if (null === $createSiteDto || (is_array($createSiteDto) && 0 === count($createSiteDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createSiteDto when calling siteControllerUpdate'
            );
        }

        $resourcePath = '/sync-core/site';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createSiteDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createSiteDto));
            } else {
                $httpBody = $createSiteDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'PATCH',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation siteControllerUpdateConfig.
     *
     * @param  SiteConfigUpdateRequestDto $siteConfigUpdateRequestDto siteConfigUpdateRequestDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdateConfig'] to see the possible values for this operation
     *
     * @return SyndicationEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateConfig($siteConfigUpdateRequestDto, string $contentType = self::contentTypes['siteControllerUpdateConfig'][0])
    {
        [$response] = $this->siteControllerUpdateConfigWithHttpInfo($siteConfigUpdateRequestDto, $contentType);

        return $response;
    }

    /**
     * Operation siteControllerUpdateConfigWithHttpInfo.
     *
     * @param  SiteConfigUpdateRequestDto $siteConfigUpdateRequestDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdateConfig'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateConfigWithHttpInfo($siteConfigUpdateRequestDto, string $contentType = self::contentTypes['siteControllerUpdateConfig'][0])
    {
        $request = $this->siteControllerUpdateConfigRequest($siteConfigUpdateRequestDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation siteControllerUpdateConfigAsync.
     *
     * @param  SiteConfigUpdateRequestDto $siteConfigUpdateRequestDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdateConfig'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateConfigAsync($siteConfigUpdateRequestDto, string $contentType = self::contentTypes['siteControllerUpdateConfig'][0])
    {
        return $this->siteControllerUpdateConfigAsyncWithHttpInfo($siteConfigUpdateRequestDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation siteControllerUpdateConfigAsyncWithHttpInfo.
     *
     * @param  SiteConfigUpdateRequestDto $siteConfigUpdateRequestDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdateConfig'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateConfigAsyncWithHttpInfo($siteConfigUpdateRequestDto, string $contentType = self::contentTypes['siteControllerUpdateConfig'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity';
        $request = $this->siteControllerUpdateConfigRequest($siteConfigUpdateRequestDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'siteControllerUpdateConfig'.
     *
     * @param  SiteConfigUpdateRequestDto $siteConfigUpdateRequestDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['siteControllerUpdateConfig'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function siteControllerUpdateConfigRequest($siteConfigUpdateRequestDto, string $contentType = self::contentTypes['siteControllerUpdateConfig'][0])
    {
        // verify the required parameter 'siteConfigUpdateRequestDto' is set
        if (null === $siteConfigUpdateRequestDto || (is_array($siteConfigUpdateRequestDto) && 0 === count($siteConfigUpdateRequestDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $siteConfigUpdateRequestDto when calling siteControllerUpdateConfig'
            );
        }

        $resourcePath = '/sync-core/site/config';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($siteConfigUpdateRequestDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($siteConfigUpdateRequestDto));
            } else {
                $httpBody = $siteConfigUpdateRequestDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syndicationControllerCreate.
     *
     * @param  CreateSyndicationDto $createSyndicationDto createSyndicationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerCreate'] to see the possible values for this operation
     *
     * @return SyndicationEntity
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerCreate($createSyndicationDto, string $contentType = self::contentTypes['syndicationControllerCreate'][0])
    {
        [$response] = $this->syndicationControllerCreateWithHttpInfo($createSyndicationDto, $contentType);

        return $response;
    }

    /**
     * Operation syndicationControllerCreateWithHttpInfo.
     *
     * @param  CreateSyndicationDto $createSyndicationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerCreate'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerCreateWithHttpInfo($createSyndicationDto, string $contentType = self::contentTypes['syndicationControllerCreate'][0])
    {
        $request = $this->syndicationControllerCreateRequest($createSyndicationDto, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation syndicationControllerCreateAsync.
     *
     * @param  CreateSyndicationDto $createSyndicationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerCreateAsync($createSyndicationDto, string $contentType = self::contentTypes['syndicationControllerCreate'][0])
    {
        return $this->syndicationControllerCreateAsyncWithHttpInfo($createSyndicationDto, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation syndicationControllerCreateAsyncWithHttpInfo.
     *
     * @param  CreateSyndicationDto $createSyndicationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerCreate'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerCreateAsyncWithHttpInfo($createSyndicationDto, string $contentType = self::contentTypes['syndicationControllerCreate'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity';
        $request = $this->syndicationControllerCreateRequest($createSyndicationDto, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'syndicationControllerCreate'.
     *
     * @param  CreateSyndicationDto $createSyndicationDto (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerCreate'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerCreateRequest($createSyndicationDto, string $contentType = self::contentTypes['syndicationControllerCreate'][0])
    {
        // verify the required parameter 'createSyndicationDto' is set
        if (null === $createSyndicationDto || (is_array($createSyndicationDto) && 0 === count($createSyndicationDto))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $createSyndicationDto when calling syndicationControllerCreate'
            );
        }

        $resourcePath = '/sync-core/syndication';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($createSyndicationDto)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($createSyndicationDto));
            } else {
                $httpBody = $createSyndicationDto;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'POST',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syndicationControllerDelete.
     *
     * @param  SyndicationDeleteRequest $syndicationDeleteRequest syndicationDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerDelete'] to see the possible values for this operation
     *
     * @return SyndicationEntity[]
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerDelete($syndicationDeleteRequest, string $contentType = self::contentTypes['syndicationControllerDelete'][0])
    {
        [$response] = $this->syndicationControllerDeleteWithHttpInfo($syndicationDeleteRequest, $contentType);

        return $response;
    }

    /**
     * Operation syndicationControllerDeleteWithHttpInfo.
     *
     * @param  SyndicationDeleteRequest $syndicationDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerDelete'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[], HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerDeleteWithHttpInfo($syndicationDeleteRequest, string $contentType = self::contentTypes['syndicationControllerDelete'][0])
    {
        $request = $this->syndicationControllerDeleteRequest($syndicationDeleteRequest, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation syndicationControllerDeleteAsync.
     *
     * @param  SyndicationDeleteRequest $syndicationDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerDeleteAsync($syndicationDeleteRequest, string $contentType = self::contentTypes['syndicationControllerDelete'][0])
    {
        return $this->syndicationControllerDeleteAsyncWithHttpInfo($syndicationDeleteRequest, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation syndicationControllerDeleteAsyncWithHttpInfo.
     *
     * @param  SyndicationDeleteRequest $syndicationDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerDelete'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerDeleteAsyncWithHttpInfo($syndicationDeleteRequest, string $contentType = self::contentTypes['syndicationControllerDelete'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntity[]';
        $request = $this->syndicationControllerDeleteRequest($syndicationDeleteRequest, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'syndicationControllerDelete'.
     *
     * @param  SyndicationDeleteRequest $syndicationDeleteRequest (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerDelete'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerDeleteRequest($syndicationDeleteRequest, string $contentType = self::contentTypes['syndicationControllerDelete'][0])
    {
        // verify the required parameter 'syndicationDeleteRequest' is set
        if (null === $syndicationDeleteRequest || (is_array($syndicationDeleteRequest) && 0 === count($syndicationDeleteRequest))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $syndicationDeleteRequest when calling syndicationControllerDelete'
            );
        }

        $resourcePath = '/sync-core/syndication';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($syndicationDeleteRequest)) {
            if (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the body
                $httpBody = ObjectSerializer::guzzleJsonEncode(ObjectSerializer::sanitizeForSerialization($syndicationDeleteRequest));
            } else {
                $httpBody = $syndicationDeleteRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'DELETE',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syndicationControllerGetErrors.
     *
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $page page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerGetErrors'] to see the possible values for this operation
     *
     * @return SyndicationErrorList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerGetErrors($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['syndicationControllerGetErrors'][0])
    {
        [$response] = $this->syndicationControllerGetErrorsWithHttpInfo($itemsPerPage, $page, $contentType);

        return $response;
    }

    /**
     * Operation syndicationControllerGetErrorsWithHttpInfo.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerGetErrors'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerGetErrorsWithHttpInfo($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['syndicationControllerGetErrors'][0])
    {
        $request = $this->syndicationControllerGetErrorsRequest($itemsPerPage, $page, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation syndicationControllerGetErrorsAsync.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerGetErrors'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerGetErrorsAsync($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['syndicationControllerGetErrors'][0])
    {
        return $this->syndicationControllerGetErrorsAsyncWithHttpInfo($itemsPerPage, $page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation syndicationControllerGetErrorsAsyncWithHttpInfo.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerGetErrors'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerGetErrorsAsyncWithHttpInfo($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['syndicationControllerGetErrors'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationErrorList';
        $request = $this->syndicationControllerGetErrorsRequest($itemsPerPage, $page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'syndicationControllerGetErrors'.
     *
     * @param  string $itemsPerPage (optional)
     * @param  string $page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerGetErrors'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerGetErrorsRequest($itemsPerPage = null, $page = null, string $contentType = self::contentTypes['syndicationControllerGetErrors'][0])
    {
        $resourcePath = '/sync-core/syndication/errors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $itemsPerPage,
            'itemsPerPage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syndicationControllerItem.
     *
     * @param  string $id id (required)
     * @param  string $includeUsage includeUsage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerItem'] to see the possible values for this operation
     *
     * @return SyndicationEntityWithUsage
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerItem($id, $includeUsage = null, string $contentType = self::contentTypes['syndicationControllerItem'][0])
    {
        [$response] = $this->syndicationControllerItemWithHttpInfo($id, $includeUsage, $contentType);

        return $response;
    }

    /**
     * Operation syndicationControllerItemWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $includeUsage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerItem'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerItemWithHttpInfo($id, $includeUsage = null, string $contentType = self::contentTypes['syndicationControllerItem'][0])
    {
        $request = $this->syndicationControllerItemRequest($id, $includeUsage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation syndicationControllerItemAsync.
     *
     * @param  string $id (required)
     * @param  string $includeUsage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerItemAsync($id, $includeUsage = null, string $contentType = self::contentTypes['syndicationControllerItem'][0])
    {
        return $this->syndicationControllerItemAsyncWithHttpInfo($id, $includeUsage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation syndicationControllerItemAsyncWithHttpInfo.
     *
     * @param  string $id (required)
     * @param  string $includeUsage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerItem'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerItemAsyncWithHttpInfo($id, $includeUsage = null, string $contentType = self::contentTypes['syndicationControllerItem'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\SyndicationEntityWithUsage';
        $request = $this->syndicationControllerItemRequest($id, $includeUsage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFileObject' === $returnType) {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== $returnType) {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();

                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            )
        ;
    }

    /**
     * Create request for operation 'syndicationControllerItem'.
     *
     * @param  string $id (required)
     * @param  string $includeUsage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerItem'] to see the possible values for this operation
     *
     * @return Request
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerItemRequest($id, $includeUsage = null, string $contentType = self::contentTypes['syndicationControllerItem'][0])
    {
        // verify the required parameter 'id' is set
        if (null === $id || (is_array($id) && 0 === count($id))) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling syndicationControllerItem'
            );
        }

        $resourcePath = '/sync-core/syndication/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $includeUsage,
            'includeUsage', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // path params
        if (null !== $id) {
            $resourcePath = str_replace(
                '{id}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (false !== stripos($headers['Content-Type'], 'application/json')) {
                // if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = ObjectSerializer::guzzleJsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer '.$this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);

        return new Request(
            'GET',
            $operationHost.$resourcePath.($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syndicationControllerList.
     *
     * @param  string $isCloning isCloning (optional)
     * @param  string $types types (optional)
     * @param  string $isRegularSyndication isRegularSyndication (optional)
     * @param  string $isUpdate isUpdate (optional)
     * @param  string $statuses statuses (optional)
     * @param  string $migrationId migrationId (optional)
     * @param  string $includeUsage includeUsage (optional)
     * @param  string $sourceSyndicationId sourceSyndicationId (optional)
     * @param  string $flowMachineNames flowMachineNames (optional)
     * @param  string $flowIds flowIds (optional)
     * @param  string $poolMachineNames poolMachineNames (optional)
     * @param  string $poolIds poolIds (optional)
     * @param  string $siteUuids siteUuids (optional)
     * @param  string $siteIds siteIds (optional)
     * @param  string $entityRemoteUniqueIds entityRemoteUniqueIds (optional)
     * @param  string $entityRemoteUuids entityRemoteUuids (optional)
     * @param  string $entityIds entityIds (optional)
     * @param  string $groupBy groupBy (optional)
     * @param  string $page page (optional)
     * @param  string $itemsPerPage itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerList'] to see the possible values for this operation
     *
     * @return PagedSyndicationList
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerList($isCloning = null, $types = null, $isRegularSyndication = null, $isUpdate = null, $statuses = null, $migrationId = null, $includeUsage = null, $sourceSyndicationId = null, $flowMachineNames = null, $flowIds = null, $poolMachineNames = null, $poolIds = null, $siteUuids = null, $siteIds = null, $entityRemoteUniqueIds = null, $entityRemoteUuids = null, $entityIds = null, $groupBy = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['syndicationControllerList'][0])
    {
        [$response] = $this->syndicationControllerListWithHttpInfo($isCloning, $types, $isRegularSyndication, $isUpdate, $statuses, $migrationId, $includeUsage, $sourceSyndicationId, $flowMachineNames, $flowIds, $poolMachineNames, $poolIds, $siteUuids, $siteIds, $entityRemoteUniqueIds, $entityRemoteUuids, $entityIds, $groupBy, $page, $itemsPerPage, $contentType);

        return $response;
    }

    /**
     * Operation syndicationControllerListWithHttpInfo.
     *
     * @param  string $isCloning (optional)
     * @param  string $types (optional)
     * @param  string $isRegularSyndication (optional)
     * @param  string $isUpdate (optional)
     * @param  string $statuses (optional)
     * @param  string $migrationId (optional)
     * @param  string $includeUsage (optional)
     * @param  string $sourceSyndicationId (optional)
     * @param  string $flowMachineNames (optional)
     * @param  string $flowIds (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $poolIds (optional)
     * @param  string $siteUuids (optional)
     * @param  string $siteIds (optional)
     * @param  string $entityRemoteUniqueIds (optional)
     * @param  string $entityRemoteUuids (optional)
     * @param  string $entityIds (optional)
     * @param  string $groupBy (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerList'] to see the possible values for this operation
     *
     * @return array of \EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList, HTTP status code, HTTP response headers (array of strings)
     *
     * @throws ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerListWithHttpInfo($isCloning = null, $types = null, $isRegularSyndication = null, $isUpdate = null, $statuses = null, $migrationId = null, $includeUsage = null, $sourceSyndicationId = null, $flowMachineNames = null, $flowIds = null, $poolMachineNames = null, $poolIds = null, $siteUuids = null, $siteIds = null, $entityRemoteUniqueIds = null, $entityRemoteUuids = null, $entityIds = null, $groupBy = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['syndicationControllerList'][0])
    {
        $request = $this->syndicationControllerListRequest($isCloning, $types, $isRegularSyndication, $isUpdate, $statuses, $migrationId, $includeUsage, $sourceSyndicationId, $flowMachineNames, $flowIds, $poolMachineNames, $poolIds, $siteUuids, $siteIds, $entityRemoteUniqueIds, $entityRemoteUuids, $entityIds, $groupBy, $page, $itemsPerPage, $contentType);

        try {
            $options = $this->createHttpClientOption();

            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList' === '\SplFileObject') {
                        $content = $response->getBody(); // stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList', []),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                    ];
            }

            $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList';
            if ('\SplFileObject' === $returnType) {
                $content = $response->getBody(); // stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ('string' !== $returnType) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders(),
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);

                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation syndicationControllerListAsync.
     *
     * @param  string $isCloning (optional)
     * @param  string $types (optional)
     * @param  string $isRegularSyndication (optional)
     * @param  string $isUpdate (optional)
     * @param  string $statuses (optional)
     * @param  string $migrationId (optional)
     * @param  string $includeUsage (optional)
     * @param  string $sourceSyndicationId (optional)
     * @param  string $flowMachineNames (optional)
     * @param  string $flowIds (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $poolIds (optional)
     * @param  string $siteUuids (optional)
     * @param  string $siteIds (optional)
     * @param  string $entityRemoteUniqueIds (optional)
     * @param  string $entityRemoteUuids (optional)
     * @param  string $entityIds (optional)
     * @param  string $groupBy (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerListAsync($isCloning = null, $types = null, $isRegularSyndication = null, $isUpdate = null, $statuses = null, $migrationId = null, $includeUsage = null, $sourceSyndicationId = null, $flowMachineNames = null, $flowIds = null, $poolMachineNames = null, $poolIds = null, $siteUuids = null, $siteIds = null, $entityRemoteUniqueIds = null, $entityRemoteUuids = null, $entityIds = null, $groupBy = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['syndicationControllerList'][0])
    {
        return $this->syndicationControllerListAsyncWithHttpInfo($isCloning, $types, $isRegularSyndication, $isUpdate, $statuses, $migrationId, $includeUsage, $sourceSyndicationId, $flowMachineNames, $flowIds, $poolMachineNames, $poolIds, $siteUuids, $siteIds, $entityRemoteUniqueIds, $entityRemoteUuids, $entityIds, $groupBy, $page, $itemsPerPage, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            )
        ;
    }

    /**
     * Operation syndicationControllerListAsyncWithHttpInfo.
     *
     * @param  string $isCloning (optional)
     * @param  string $types (optional)
     * @param  string $isRegularSyndication (optional)
     * @param  string $isUpdate (optional)
     * @param  string $statuses (optional)
     * @param  string $migrationId (optional)
     * @param  string $includeUsage (optional)
     * @param  string $sourceSyndicationId (optional)
     * @param  string $flowMachineNames (optional)
     * @param  string $flowIds (optional)
     * @param  string $poolMachineNames (optional)
     * @param  string $poolIds (optional)
     * @param  string $siteUuids (optional)
     * @param  string $siteIds (optional)
     * @param  string $entityRemoteUniqueIds (optional)
     * @param  string $entityRemoteUuids (optional)
     * @param  string $entityIds (optional)
     * @param  string $groupBy (optional)
     * @param  string $page (optional)
     * @param  string $itemsPerPage (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syndicationControllerList'] to see the possible values for this operation
     *
     * @return PromiseInterface
     *
     * @throws \InvalidArgumentException
     */
    public function syndicationControllerListAsyncWithHttpInfo($isCloning = null, $types = null, $isRegularSyndication = null, $isUpdate = null, $statuses = null, $migrationId = null, $includeUsage = null, $sourceSyndicationId = null, $flowMachineNames = null, $flowIds = null, $poolMachineNames = null, $poolIds = null, $siteUuids = null, $siteIds = null, $entityRemoteUniqueIds = null, $entityRemoteUuids = null, $entityIds = null, $groupBy = null, $page = null, $itemsPerPage = null, string $contentType = self::contentTypes['syndicationControllerList'][0])
    {
        $returnType = '\EdgeBox\SyncCore\V2\Raw\Model\PagedSyndicationList';
        $request = $this->syndicationControllerListRequest($isCloning, $types, $isRegularSyndication, $isUpdate, $statuses, $migrationId, $includeUsage, $sourceSyndicationId, $flowMachineNames, $flowIds, $poolMachineNames, $poolIds, $siteUuids, $siteIds, $entityRemoteUniqueIds, $entityRemoteUuids, $entityIds, $groupBy, $page, $itemsPerPage, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ('\SplFi