Drush is a command line shell and Unix scripting interface for Drupal. Drush core ships with lots of [useful commands](commands/all.md) and [generators](generators/all.md). Similarly, it runs update.php, executes SQL queries, runs content  migrations, and misc utilities like cron or cache rebuild. Drush can be extended by [3rd party commandfiles](https://www.drupal.org/project/project_module?f[2]=im_vid_3%3A4654).

[![Latest Stable Version](https://poser.pugx.org/drush/drush/v/stable.png)](https://packagist.org/packages/drush/drush) [![Total Downloads](https://poser.pugx.org/drush/drush/downloads.png)](https://packagist.org/packages/drush/drush) [![License](https://poser.pugx.org/drush/drush/license.png)](https://packagist.org/packages/drush/drush) <a href="https://circleci.com/gh/drush-ops/drush"><img src="https://circleci.com/gh/drush-ops/drush.svg?style=shield"></a> [![Twitter](https://img.shields.io/badge/Twitter-%40DrushCli-blue.svg)](https://twitter.com/intent/user?screen_name=DrushCli)

Resources
-----------
* [Installing and Upgrading](install.md)
* [Commands](commands/all.md) and [Generators](generators/all.md)
* [API Documentation](https://www.drush.org/latest/api)
* [Drush packages available via Composer](https://packagist.org/search/?type=drupal-drush)
* [A list of modules that include Drush integration](https://www.drupal.org/project/project_module?f[2]=im_vid_3%3A4654&solrsort=ds_project_latest_release+desc)
* Drush expects all participants to abide by the [Drupal Code of Conduct](https://www.drupal.org/dcoc).
* Drush 8 is no longer recommended, but [here are its docs](https://docs.drush.org/en/8.x/install/).

Support
-----------
* Post support requests to [Drupal Answers](http://drupal.stackexchange.com/questions/tagged/drush). Tag question with _drush_.
* Report bugs and request features in the [GitHub Drush Issue Queue](https://github.com/drush-ops/drush/issues).
* Use pull requests (PRs) to contribute to Drush. [Guidelines](contribute/CONTRIBUTING.md).

FAQ
------

#### What does *Drush* stand for?
A: The Drupal Shell.

#### How do I pronounce Drush?
Some people pronounce the *dru* with a long 'u' like Dr*u*pal. Fidelity points
go to them, but they are in the minority. Most pronounce Drush so that it
rhymes with hush, rush, flush, etc. This is the preferred pronunciation.

Credits
-----------

* Maintained by [Moshe Weitzman](http://drupal.org/moshe) with much help from the folks listed at https://github.com/orgs/drush-ops/people.
* Originally developed by [Arto Bendiken](http://bendiken.net) for Drupal 4.7.
* Redesigned by [Franz Heinzmann](http://unbiskant.org) in May 2007 for Drupal 5.
* Thanks to [JetBrains](https://www.jetbrains.com) for [supporting this project and open source software](https://www.jetbrains.com/buy/opensource/).

![Drush Logo](drush_logo-black.png)
[![PhpStorm Logo](misc/icon_PhpStorm.png)](https://www.jetbrains.com/phpstorm/)
