/**
 * @file
 * JavaScript behaviors for RateIt integration.
 */

(function ($, Drupal, once) {
  // All options can be override using custom data-* attributes.
  // @see https://github.com/gjunge/rateit.js/wiki#options.

  /**
   * Initialize rating element using RateIt.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.webformRating = {
    attach(context) {
      $(once('webform-rating', '[data-rateit-backingfld]', context))
        .each(function () {
          var $rateit = $(this);
          var $input = $($rateit.attr('data-rateit-backingfld'));
          if (!$.fn.rateit) {
            $rateit.remove();
            $input.removeClass('js-webform-visually-hidden');
            return;
          }

          // Rateit only initialize inputs on load.
          if (document.readyState === 'complete') {
            $rateit.rateit();
          }
          else {
            window.setTimeout(function () {$rateit.rateit();});
          }

          // Update the RateIt widget when the input's value has changed.
          // @see webform.states.js
          $input.on('change', function () {
            $rateit.rateit('value', $input.val());
          });

          // Set RateIt widget to be readonly when the input is disabled.
          // @see webform.states.js
          $input.on('webform:disabled', function () {
            $rateit.rateit('readonly', $input.is(':disabled'));
          });
        });
    }
  };

})(jQuery, Drupal, once);
