<?php

namespace Drupal\Tests\scheduler\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\scheduler\Traits\SchedulerCommerceProductSetupTrait;
use Drupal\Tests\scheduler\Traits\SchedulerMediaSetupTrait;
use Drupal\Tests\scheduler\Traits\SchedulerSetupTrait;

/**
 * Base class to provide common browser test setup.
 */
abstract class SchedulerBrowserTestBase extends BrowserTestBase {

  use SchedulerSetupTrait;
  use SchedulerMediaSetupTrait;
  use SchedulerCommerceProductSetupTrait;

  /**
   * The standard modules to load for all browser tests.
   *
   * Additional modules can be specified in the tests that need them.
   *
   * @var array
   */
  protected static $modules = [
    'scheduler',
    'dblog',
    'media',
    'commerce_product',
  ];

  /**
   * The profile to install as a basis for testing.
   *
   * @var string
   */
  protected $profile = 'testing';

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    // Call the common set-up functions defined in the traits.
    $this->schedulerSetUp();
    // $this->getName() includes the test class and the dataProvider key. We can
    // use this to save time and resources by avoiding calls to the media and
    // product setup functions when they are not needed. The exception is the
    // permissions tests, which use all entities for all tests.
    $testName = $this->getName();
    if (stristr($testName, 'media') || stristr($testName, 'permission')) {
      $this->schedulerMediaSetUp();
    }
    if (stristr($this->getName(), 'product') || stristr($testName, 'permission')) {
      $this->SchedulerCommerceProductSetUp();
    }
  }

}
