<?php

declare(strict_types=1);

namespace Drupal\Tests\rules\Unit\Integration\Event;

/**
 * Checks that the event "rules_system_logger_event" is correctly defined.
 *
 * @group RulesEvent
 */
class SystemLoggerEventTest extends EventTestBase {

  /**
   * Tests the event metadata.
   */
  public function testSystemLoggerEvent(): void {
    $event = $this->eventManager->createInstance('rules_system_logger_event');
    $logger_entry = $event->getContextDefinition('logger_entry');

    // @todo Create a TypedData logger-entry object: https://www.drupal.org/node/2625238
    $this->assertSame('any', $logger_entry->getDataType());
  }

}
