<?php

declare(strict_types=1);

namespace Drupal\monolog;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Overrides the `logger.factory` service with the Monolog factory.
 */
class MonologServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $definition = $container->getDefinition('logger.factory');
    $definition
      ->setClass('Drupal\monolog\Logger\MonologLoggerChannelFactory')
      ->setArguments([
        new Reference('request_stack'),
        new Reference('current_user'),
        new Reference('messenger'),
        new Reference('service_container'),
      ])
      ->clearTags();

    // Allow existing Drupal loggers to be added as handlers.
    $drupalLoggers = $container->findTaggedServiceIds('logger');
    foreach ($drupalLoggers as $id => $tags) {
      $handlerId = sprintf('monolog.handler.drupal.%s',
        preg_replace('/^logger\./', '', $id));

      // Allow the handler to be explicitly defined elsewhere.
      if (!$container->has($handlerId)) {
        $definition = $container->register($handlerId,
          'Drupal\monolog\Logger\Handler\DrupalHandler');
        $definition->addArgument(new Reference($id));
        $definition->setShared(FALSE);
      }

    }

    $on_gcp = \getenv('MONOLOG_ON_GCP');
    if ($on_gcp === '1' || $on_gcp === 'true') {
      $container->setParameter('monolog.on_gcp', TRUE);
    }
    else {
      $container->setParameter('monolog.on_gcp', FALSE);
    }
  }

}
