<?php

declare(strict_types=1);

namespace Drupal\monolog\Logger;

use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

/**
 * A logger that is always present.
 *
 * @internal This class is not part of the public API.
 */
class OptionalLogger {

  /**
   * @var mixed|null
   */
  private $value = NULL;

  /**
   * @param $value
   */
  private function __construct($value = NULL) {
    $this->value = $value;
  }

  /**
   * @param mixed $value
   *   The value to store.
   *
   * @return static
   */
  public static function of($value) {
    return new static($value);
  }

  /**
   * @return static
   */
  public static function none() {
    return new static();
  }

  /**
   * @param callable $fn
   *   The next function to call.
   *
   * @return $this
   */
  public function bind(callable $fn): self {
    if (!is_null($this->value)) {
      return $fn($this->value);
    }

    return $this;
  }

  /**
   * @return \Psr\Log\LoggerInterface
   */
  public function get(): LoggerInterface {
    return $this->value ?? new NullLogger();
  }

}
