<?php

declare(strict_types=1);

namespace Drupal\migrate_plus;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\migrate_plus\Attribute\DataFetcher;

/**
 * Provides a plugin manager for data fetchers.
 *
 * @see \Drupal\migrate_plus\Attribute\DataFetcher
 * @see \Drupal\migrate_plus\DataFetcherPluginBase
 * @see \Drupal\migrate_plus\DataFetcherPluginInterface
 * @see plugin_api
 */
class DataFetcherPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new DataFetcherPluginManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/migrate_plus/data_fetcher', $namespaces, $module_handler, DataFetcherPluginInterface::class, DataFetcher::class, 'Drupal\migrate_plus\Annotation\DataFetcher');

    $this->alterInfo('data_fetcher_info');
    $this->setCacheBackend($cache_backend, 'migrate_plus_plugins_data_fetcher');
  }

}
