<?php

namespace Drupal\imagick\Plugin\ImageToolkit\Operation\imagick;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\ImageToolkit\ImageToolkitInterface;
use Drupal\imagick\Plugin\ImageToolkit\ImagickToolkit;
use Drupal\system\Plugin\ImageToolkit\Operation\gd\Resize as GdResize;
use Psr\Log\LoggerInterface;

/**
 * Defines imagick resize operation.
 *
 * @ImageToolkitOperation(
 *   id = "imagick_resize",
 *   toolkit = "imagick",
 *   operation = "resize",
 *   label = @Translation("Resize"),
 *   description = @Translation("Resizes an image to the given dimensions (ignoring aspect ratio).")
 * )
 */
class Resize extends GdResize {

  use ImagickOperationTrait;

  /**
   * Configuration Factory.
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * Constructs an image toolkit operation plugin.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param array $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\ImageToolkit\ImageToolkitInterface $toolkit
   *   The image toolkit.
   * @param \Psr\Log\LoggerInterface $logger
   *   A logger instance.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    array $plugin_definition,
    ImageToolkitInterface $toolkit,
    LoggerInterface $logger,
    ConfigFactoryInterface $config_factory,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $toolkit, $logger);
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  protected function execute(array $arguments = []) {
    return $this->processFrames($arguments);
  }

  /**
   * {@inheritdoc}
   */
  protected function process(\Imagick $resource, array $arguments) {
    $filter = $this->configFactory->get(ImagickToolkit::CONFIG)
      ->get(ImagickToolkit::CONFIG_RESIZE_FILTER);

    if ($filter == -1) {
      return $resource->scaleImage($arguments['width'], $arguments['height']);
    }
    else {
      return $resource->resizeImage($arguments['width'], $arguments['height'], $filter, 1);
    }
  }

}
