<?php

namespace Drupal\imagick\Plugin\ImageToolkit\Operation\imagick;

/**
 * Defines imagick encipher operation.
 *
 * @ImageToolkitOperation(
 *   id = "imagick_encipher",
 *   toolkit = "imagick",
 *   operation = "encipher",
 *   label = @Translation("Encipher"),
 *   description = @Translation("Applies the encipher effect on an image")
 * )
 */
class Encipher extends ImagickOperationBase {

  /**
   * {@inheritdoc}
   */
  protected function arguments() {
    return [
      'password' => [
        'description' => 'The password to encrypt the image with.',
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function process(\Imagick $resource, array $arguments) {
    return $resource->encipherImage($arguments['password']);
  }

}
