<?php

namespace Drupal\imagick\Plugin\ImageToolkit\Operation\imagick;

/**
 * Defines imagick coloroverlay operation.
 *
 * @ImageToolkitOperation(
 *   id = "imagick_coloroverlay",
 *   toolkit = "imagick",
 *   operation = "coloroverlay",
 *   label = @Translation("Coloroverlay"),
 *   description = @Translation("Applies the coloroverlay effect on an image")
 * )
 */
class Coloroverlay extends ImagickOperationBase {

  /**
   * {@inheritdoc}
   */
  protected function arguments() {
    return [
      'HEX' => [
        'description' => 'The color used to create the overlay.',
      ],
      'alpha' => [
        'description' => 'The transparency of the overlay layer.',
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function process(\Imagick $resource, array $arguments) {
    $color = new \Imagick();
    $color->newImage($resource->getImageWidth(), $resource->getImageHeight(), $arguments['HEX']);

    $alpha = $arguments['alpha'] / 100;
    if (method_exists($color, 'setImageOpacity')) {
      $color->setImageOpacity($alpha);
    }
    else {
      $color->setImageAlpha($alpha);
    }

    return $resource->compositeImage($color, \Imagick::COMPOSITE_DEFAULT, 0, 0);
  }

}
