<?php

namespace Drupal\Tests\geolocation_geometry\Functional;

use Drupal\Core\Entity\Entity\EntityFormDisplay;
use Drupal\Core\Entity\Entity\EntityViewDisplay;
use Drupal\Tests\BrowserTestBase;
use Drupal\user\Entity\User;

/**
 * Tests the creation of geolocation fields.
 *
 * @group geolocation
 */
class GeolocationGeometryFieldTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'field',
    'node',
    'taxonomy',
    'geolocation',
    'geolocation_geometry',
    'geolocation_geometry_demo',
  ];

  /**
   * Test user.
   *
   * @var \Drupal\user\Entity\User|false
   */
  protected User $articleCreator;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Kenya geo data.
   *
   * @var string[]
   */
  protected array $kenya = [
    'wkt' => 'POLYGON((39.202 -4.676,39.604 -4.346,39.8 -3.681,40.121 -3.277,40.263 -2.573,40.637 -2.499,40.884 -2.082,41.585 -1.683,40.993 -0.858,40.981 2.784,41.855 3.918,41.171 3.91,40.768 4.257,39.854 3.838,39.55 3.422,38.892 3.5,38.671 3.616,38.436 3.588,38.12 3.598,36.855 4.447,36.159 4.447,35.817 4.776,35.817 5.338,35.298 5.506,34.62 4.847,34.005 4.249,34.479 3.555,34.596 3.053,35.035 1.905,34.672 1.176,34.18 0.515,33.893 0.109,33.903 -0.95,34.072 -1.059,37.698 -3.096,37.766 -3.677,39.202 -4.676))',
    'geojson' => '{"type":"Polygon","coordinates":[[[39.202,-4.676],[39.604,-4.346],[39.8,-3.681],[40.121,-3.277],[40.263,-2.573],[40.637,-2.499],[40.884,-2.082],[41.585,-1.683],[40.993,-0.858],[40.981,2.784],[41.855,3.918],[41.171,3.91],[40.768,4.257],[39.854,3.838],[39.55,3.422],[38.892,3.5],[38.671,3.616],[38.436,3.588],[38.12,3.598],[36.855,4.447],[36.159,4.447],[35.817,4.776],[35.817,5.338],[35.298,5.506],[34.62,4.847],[34.005,4.249],[34.479,3.555],[34.596,3.053],[35.035,1.905],[34.672,1.176],[34.18,0.515],[33.893,0.109],[33.903,-0.95],[34.072,-1.059],[37.698,-3.096],[37.766,-3.677],[39.202,-4.676]]]}',
  ];

  /**
   * Chile geo data.
   *
   * @var string[]
   */
  protected array $chile = [
    'wkt' => 'MULTIPOLYGON(((-68.63401022758323 -52.63637045887449,-69.34564999999992 -52.518299999999954,-70.26747999999998 -52.93123000000003,-70.59177999999986 -53.61582999999996,-71.10773 -54.07432999999992,-72.43417999999997 -53.71539999999999,-73.8381 -53.04743000000002,-74.66253 -52.837489999999946,-73.28519999999997 -53.95751999999993,-72.26390000000004 -54.49513999999999,-71.00567999999998 -55.053830000000005,-69.95808999999997 -55.19843000000003,-69.2321 -55.49905999999993,-68.63999081081187 -55.58001799908692,-68.14862999999991 -55.61183,-67.29102999999992 -55.30123999999995,-66.95992000000001 -54.896810000000016,-67.56244 -54.87001,-68.63335000000001 -54.869499999999995,-68.63401022758323 -52.63637045887449)),((-69.59042375352405 -17.580011895419332,-69.85844356960587 -18.092693780187012,-70.37257239447771 -18.34797535570887,-70.16441972520605 -19.756468194256165,-70.09124589708074 -21.39331918710126,-70.40396582709502 -23.628996677344578,-70.72495398627599 -25.705924167587256,-70.90512386746161 -27.640379734001247,-71.48989437527645 -28.861442152625923,-71.37008256700773 -30.09568206148503,-71.66872066922247 -30.920644626592495,-71.4384504869299 -32.41889942803078,-71.86173214383263 -33.90909270603153,-72.55313696968174 -35.50884002049106,-73.1667170884993 -37.12378020604439,-73.58806087919109 -37.15628468195598,-73.50555945503712 -38.282882582351114,-73.21759253609065 -39.25868865331856,-73.67709937202999 -39.94221282324317,-74.0179571194272 -41.79481292090683,-74.33194312203261 -43.22495818458442,-73.70133561877488 -43.365776462579774,-73.38889990913822 -42.117532240569574,-72.7178039211798 -42.38335580827898,-73.24035600451522 -44.4549606259956,-74.35170935738425 -44.10304412208794,-74.69215369332312 -45.76397633238103,-75.64439531116545 -46.64764332457207,-74.1265809801047 -46.93925343199511,-75.18276974150216 -47.7119194476232,-75.60801510283198 -48.67377288187184,-75.47975419788355 -50.37837167745158,-74.97663245308988 -51.0433956846157,-75.2600260077785 -51.62935475037325,-74.94676347522517 -52.262753588419,-73.7027567206629 -52.835070076051494,-73.7027567206629 -52.835069268607235,-72.55794287788488 -53.53141000118449,-71.429794684521 -53.85645476030037,-71.00633216010525 -53.83325204220132,-70.8451016913546 -52.89920052852571,-69.9427795071062 -52.53793059037322,-69.46128434922667 -52.29195077266391,-68.57154537624133 -52.299443855346226,-69.49836218939609 -52.14276091263727,-71.91480383979638 -52.0090223058659,-72.32940385607407 -51.42595631287243,-72.30997351753234 -50.67700977966632,-72.97574683296469 -50.741450290734285,-73.32805091011453 -50.378785088909915,-73.4154357571201 -49.31843637471297,-72.64824744331494 -48.87861825947683,-72.33116085477201 -48.2442383766618,-72.44735531278027 -47.73853281025352,-71.91725847033024 -46.88483814879177,-71.55200944689128 -45.5607329241771,-71.65931555854536 -44.973688653341426,-71.22277889675976 -44.784242852559416,-71.32980078803622 -44.407521661151655,-71.79362260607193 -44.207172133156064,-71.46405615913051 -43.787611179378345,-71.91542395698389 -43.40856454851745,-72.14889807807856 -42.254888197601375,-71.7468037584155 -42.05138640723598,-71.91573401557763 -40.83233936947069,-71.68076127794649 -39.808164157878046,-71.41351660834906 -38.91602223079114,-70.81466427273469 -38.55299529394074,-71.11862504747549 -37.57682748794724,-71.12188066270987 -36.65812387466232,-70.36476925320164 -36.00508879978992,-70.38804948594913 -35.16968759535949,-69.81730912950152 -34.1935714657983,-69.81477698431922 -33.273886000299825,-70.0743993801536 -33.09120981214805,-70.53506893581951 -31.36501026787031,-69.91900834825194 -30.33633920666828,-70.01355038112992 -29.367922865518572,-69.65613033718317 -28.45914112723369,-69.00123491074825 -27.52121388113618,-68.29554155137043 -26.89933969493578,-68.59479977077268 -26.506908868111296,-68.38600114609736 -26.185016371365215,-68.41765296087614 -24.51855478281688,-67.32844295924417 -24.02530323659095,-66.9852339341777 -22.98634856536284,-67.1066735500636 -22.735924574476417,-67.82817989772273 -22.872918796482175,-68.21991309271128 -21.494346612231865,-68.75716712103375 -20.372657972904463,-68.44222510443092 -19.40506845467143,-68.96681840684187 -18.981683444904107,-69.10024695501949 -18.26012542081268,-69.59042375352405 -17.580011895419332)))',
    'geojson' => '{"type":"MultiPolygon","coordinates":[[[[-68.63401022758323,-52.63637045887449],[-69.34564999999992,-52.518299999999954],[-70.26747999999998,-52.93123000000003],[-70.59177999999986,-53.61582999999996],[-71.10773,-54.07432999999992],[-72.43417999999997,-53.71539999999999],[-73.8381,-53.04743000000002],[-74.66253,-52.837489999999946],[-73.28519999999997,-53.95751999999993],[-72.26390000000004,-54.49513999999999],[-71.00567999999998,-55.053830000000005],[-69.95808999999997,-55.19843000000003],[-69.2321,-55.49905999999993],[-68.63999081081187,-55.58001799908692],[-68.14862999999991,-55.61183],[-67.29102999999992,-55.30123999999995],[-66.95992000000001,-54.896810000000016],[-67.56244,-54.87001],[-68.63335000000001,-54.869499999999995],[-68.63401022758323,-52.63637045887449]]],[[[-69.59042375352405,-17.580011895419332],[-69.85844356960587,-18.092693780187012],[-70.37257239447771,-18.34797535570887],[-70.16441972520605,-19.756468194256165],[-70.09124589708074,-21.39331918710126],[-70.40396582709502,-23.628996677344574],[-70.72495398627599,-25.705924167587256],[-70.90512386746161,-27.640379734001247],[-71.48989437527645,-28.861442152625923],[-71.37008256700773,-30.09568206148503],[-71.66872066922247,-30.920644626592495],[-71.4384504869299,-32.41889942803078],[-71.86173214383263,-33.90909270603153],[-72.55313696968174,-35.50884002049106],[-73.1667170884993,-37.12378020604439],[-73.58806087919109,-37.15628468195598],[-73.50555945503712,-38.282882582351114],[-73.21759253609065,-39.25868865331856],[-73.67709937202999,-39.94221282324317],[-74.0179571194272,-41.79481292090683],[-74.33194312203261,-43.22495818458442],[-73.70133561877488,-43.365776462579774],[-73.38889990913822,-42.117532240569574],[-72.7178039211798,-42.38335580827898],[-73.24035600451522,-44.454960625995604],[-74.35170935738425,-44.10304412208794],[-74.69215369332312,-45.76397633238103],[-75.64439531116545,-46.64764332457207],[-74.1265809801047,-46.93925343199511],[-75.18276974150216,-47.7119194476232],[-75.60801510283198,-48.67377288187184],[-75.47975419788355,-50.37837167745158],[-74.97663245308988,-51.0433956846157],[-75.2600260077785,-51.62935475037325],[-74.94676347522517,-52.262753588419],[-73.7027567206629,-52.835070076051494],[-73.7027567206629,-52.835069268607235],[-72.55794287788488,-53.53141000118449],[-71.429794684521,-53.85645476030037],[-71.00633216010525,-53.83325204220132],[-70.8451016913546,-52.89920052852571],[-69.9427795071062,-52.53793059037322],[-69.46128434922667,-52.29195077266391],[-68.57154537624133,-52.299443855346226],[-69.49836218939609,-52.14276091263727],[-71.91480383979638,-52.0090223058659],[-72.32940385607407,-51.42595631287243],[-72.30997351753234,-50.67700977966632],[-72.97574683296469,-50.741450290734285],[-73.32805091011453,-50.378785088909915],[-73.4154357571201,-49.31843637471297],[-72.64824744331494,-48.87861825947683],[-72.33116085477201,-48.2442383766618],[-72.44735531278027,-47.73853281025352],[-71.91725847033024,-46.88483814879177],[-71.55200944689128,-45.5607329241771],[-71.65931555854536,-44.973688653341426],[-71.22277889675976,-44.784242852559416],[-71.32980078803622,-44.407521661151655],[-71.79362260607193,-44.207172133156064],[-71.46405615913051,-43.787611179378345],[-71.91542395698389,-43.40856454851745],[-72.14889807807856,-42.254888197601375],[-71.7468037584155,-42.05138640723598],[-71.91573401557763,-40.83233936947069],[-71.68076127794649,-39.808164157878046],[-71.41351660834906,-38.91602223079114],[-70.81466427273469,-38.55299529394074],[-71.11862504747549,-37.57682748794724],[-71.12188066270987,-36.65812387466232],[-70.36476925320164,-36.00508879978992],[-70.38804948594913,-35.16968759535949],[-69.81730912950152,-34.1935714657983],[-69.81477698431922,-33.273886000299825],[-70.0743993801536,-33.09120981214805],[-70.53506893581951,-31.36501026787031],[-69.91900834825194,-30.33633920666828],[-70.01355038112992,-29.367922865518572],[-69.65613033718317,-28.459141127233686],[-69.00123491074825,-27.52121388113618],[-68.29554155137043,-26.89933969493578],[-68.59479977077268,-26.506908868111296],[-68.38600114609736,-26.185016371365215],[-68.41765296087614,-24.51855478281688],[-67.32844295924417,-24.02530323659095],[-66.9852339341777,-22.98634856536284],[-67.1066735500636,-22.735924574476417],[-67.82817989772273,-22.872918796482175],[-68.21991309271128,-21.494346612231865],[-68.75716712103375,-20.372657972904463],[-68.44222510443092,-19.40506845467143],[-68.96681840684187,-18.981683444904107],[-69.10024695501949,-18.260125420812678],[-69.59042375352405,-17.580011895419332]]]]}',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->articleCreator = $this->drupalCreateUser([
      'create geolocation_geometry_demo content',
      'edit own geolocation_geometry_demo content',
    ]);
    $this->drupalLogin($this->articleCreator);
  }

  /**
   * Test GeoJSON to WKT.
   */
  public function testGeojsonToWkt() {
    EntityFormDisplay::load('node.geolocation_geometry_demo.default')
      ->setComponent('field_geolocation_geometry_polyg', [
        'type' => 'geolocation_geometry_geojson',
      ])
      ->save();

    EntityViewDisplay::load('node.geolocation_geometry_demo.default')
      ->setComponent('field_geolocation_geometry_polyg', [
        'type' => 'geolocation_geometry_data',
        'weight' => 1,
        'settings' => [
          'geometry_format' => 'wkt',
        ],
      ])
      ->save();

    // Display creation form.
    $this->drupalGet('node/add/geolocation_geometry_demo');
    $this->assertSession()->fieldExists("field_geolocation_geometry_polyg[0][geojson]");

    $edit = [
      'title[0][value]' => $this->randomMachineName(),
      'field_geolocation_geometry_polyg[0][geojson]' => $this->kenya['geojson'],
    ];

    $this->submitForm($edit, 'Save');
    $this->assertSession()->pageTextContainsOnce($this->kenya['wkt']);
  }

  /**
   * Test WKT to GeoJSON.
   */
  public function testWktToGeojson() {
    EntityFormDisplay::load('node.geolocation_geometry_demo.default')
      ->setComponent('field_geolocation_geometry_polyg', [
        'type' => 'geolocation_geometry_wkt',
      ])
      ->save();

    EntityViewDisplay::load('node.geolocation_geometry_demo.default')
      ->setComponent('field_geolocation_geometry_polyg', [
        'type' => 'geolocation_geometry_data',
        'weight' => 1,
        'settings' => [
          'geometry_format' => 'geojson',
        ],
      ])
      ->save();

    // Display creation form.
    $this->drupalGet('node/add/geolocation_geometry_demo');
    $this->assertSession()->fieldExists("field_geolocation_geometry_polyg[0][wkt]");

    $edit = [
      'title[0][value]' => $this->randomMachineName(),
      'field_geolocation_geometry_polyg[0][wkt]' => $this->kenya['wkt'],
    ];

    $this->submitForm($edit, 'Save');
    $this->assertSession()->responseContains($this->kenya['geojson']);
  }

}
